/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.baseinfo.plan;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.enums.provision.TaxPlanCfgEnum;
import kd.taxc.tctb.business.provision.ProvisionPlanBusiness;
import kd.taxc.tctb.opplugin.baseinfo.plan.ProvisionUniqueValidator;

public class ProvistonPlanOp
extends AbstractOperationServicePlugIn {
    private static final String[] TAX_TYPE = new String[]{"007", "008", "009"};
    private static final String[] keys = new String[]{"taxsystem.id", "taxsystem.number", "taxsystem.name", "taxsystem.countryid", "taxtype.id", "taxtype.number", "taxtype.name", "taxarea.id", "taxarea.number", "taxarea.name", "systemset", "isdimprovision", "provisiondimension", "businessdimension", "businessdimension.fbasedataid", "planuse", "enable", "startdate", "enddate", "cycle", "booktype"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(Arrays.asList(keys));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(this.getFildValueCheckValidator());
        e.getValidators().add(this.getFildBusinessCheckValidator());
        e.getValidators().add(new ProvisionUniqueValidator());
    }

    private AbstractValidator getFildBusinessCheckValidator() {
        return new AbstractValidator(){

            public void validate() {
                Map vas = this.getOption().getVariables();
                if (vas.containsKey("importtype")) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        String number;
                        DynamicObject dyn;
                        DynamicObject currobj = dataEntity.getDataEntity();
                        if (!"override".equals(vas.get("importtype")) && !"overridenew".equals(vas.get("importtype")) || (dyn = BusinessDataServiceHelper.loadSingle((String)"itp_proviston_plan", (String)"systemset", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = currobj.getString("number")))})) == null || !"1".equalsIgnoreCase(dyn.getString("systemset"))) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ProvistonPlanOp_4", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        };
    }

    private AbstractValidator getFildValueCheckValidator() {
        return new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String cycle;
                    DynamicObject taxarea;
                    DynamicObject plan = dataEntity.getDataEntity();
                    String planuseCode = plan.getString("planuse");
                    String planuseName = ProvistonPlanOp.this.getPlanuseName(planuseCode);
                    String taxsysCode = plan.getString("taxsystem.number");
                    String taxsysName = plan.getString("taxsystem.name");
                    String taxtypeCode = plan.getString("taxtype.number");
                    String taxtypeName = plan.getString("taxtype.name");
                    if (!ProvistonPlanOp.this.checkTaxtsysAvailable(planuseCode, taxsysCode)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7528\u9014%1$s\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7a0e\u6536\u5236\u5ea6\uff1a%2$s", (String)"ProvistonPlanOp_14", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxsysName));
                        continue;
                    }
                    DynamicObject taxsys = plan.getDynamicObject("taxsystem");
                    if (!ProvistonPlanOp.this.checkTaxAreaAvailable(taxsys, taxarea = plan.getDynamicObject("taxarea"))) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6%1$s\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7a0e\u6536\u8f96\u533a\uff1a%2$s", (String)"ProvistonPlanOp_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), taxsysName, taxarea.get("name")));
                        continue;
                    }
                    Long taxsysId = taxsys.getLong("id");
                    Long areaId = taxarea.getLong("id");
                    if (taxsysId == 1L && Long.compare(areaId, 1708040530098667520L) != 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u201d\u4e3a\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u201c\uff0c\u7a0e\u6536\u8f96\u533a\u53ea\u80fd\u9009\u62e9\u201d\u4e2d\u56fd\u5927\u9646\u201c\u3002", (String)"ProvistonPlanOp_20", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!ProvistonPlanOp.this.checkTaxtypeAvailable(planuseCode, taxsysCode, taxtypeCode)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7528\u9014%1$s\u4e0b\u7a0e\u6536\u5236\u5ea6%2$s\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7a0e\u79cd\uff1a%3$s", (String)"ProvistonPlanOp_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxsysName, taxtypeName));
                        continue;
                    }
                    TaxPlanCfgEnum taxplanCfg = TaxPlanCfgEnum.valueOf((String)planuseCode, (String)taxsysCode, (String)taxtypeCode);
                    boolean[] cycleCfg = ProvisionPlanBusiness.cycleCfg((TaxPlanCfgEnum)taxplanCfg);
                    if (!cycleCfg[0] && StringUtils.isNotBlank((CharSequence)plan.getString("cycle"))) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7528\u9014%1$s\u4e0b\u7a0e\u79cd%2$s\u4e0b\u4e0d\u5141\u8bb8\u5f55\u5165\u8ba1\u7a0e\u5468\u671f", (String)"ProvistonPlanOp_15", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    if (cycleCfg[2] && StringUtils.isBlank((CharSequence)plan.getString("cycle"))) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7528\u9014%1$s\u4e0b\u7a0e\u79cd%2$s\u4e0b\u8ba1\u7a0e\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProvistonPlanOp_28", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    boolean[] isdimCfg = ProvisionPlanBusiness.isdimprovisionCfg((TaxPlanCfgEnum)taxplanCfg);
                    boolean isdim = plan.getBoolean("isdimprovision");
                    boolean pass = true;
                    if (!isdimCfg[0] && isdim) {
                        pass = false;
                    } else if (isdimCfg[0] && !isdimCfg[1]) {
                        boolean bl = pass = isdimCfg[2] == isdim;
                    }
                    if (!pass) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65b9\u6848\u7528\u9014%1$s\u4e0b\u7a0e\u79cd%2$s\u4e0b\u5206\u7ef4\u5ea6\u8ba1\u7a0e\u5f55\u5165\u503c\u4e0d\u6b63\u786e", (String)"ProvistonPlanOp_16", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    String dimision = plan.getString("provisiondimension");
                    if (StringUtil.isNotEmpty((CharSequence)dimision) && !isdim) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u7ef4\u5ea6\u8ba1\u7a0e\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u8ba1\u7a0e\u7ef4\u5ea6\u3002", (String)"ProvistonPlanOp_29", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    if (StringUtil.isEmpty((CharSequence)dimision) && isdim) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u7ef4\u5ea6\u8ba1\u7a0e\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u8ba1\u7a0e\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProvistonPlanOp_30", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    if (dimision == null) {
                        dimision = "";
                    }
                    boolean isBusinessDim = dimision.contains("businessdimension");
                    DynamicObjectCollection businessDims = plan.getDynamicObjectCollection("businessdimension");
                    if (businessDims != null && !businessDims.isEmpty() && !isBusinessDim) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u7a0e\u7ef4\u5ea6\u4e0d\u5305\u542b\u201c\u4e1a\u52a1\u7ef4\u5ea6\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u4e1a\u52a1\u7ef4\u5ea6\u3002", (String)"ProvistonPlanOp_31", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    if ((businessDims == null || businessDims.isEmpty()) && isBusinessDim) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u7a0e\u7ef4\u5ea6\u5305\u542b\u201c\u4e1a\u52a1\u7ef4\u5ea6\u201d\u65f6\uff0c\u4e1a\u52a1\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProvistonPlanOp_32", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    Long taxType = plan.getLong("taxtype.id");
                    String booktype = plan.getString("booktype");
                    if (3L != taxType && StringUtil.isNotEmpty((CharSequence)booktype)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u4e3a\u201c\u4f01\u4e1a\u6240\u5f97\u7a0e\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ProvistonPlanOp_34", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), planuseName, taxtypeName));
                        continue;
                    }
                    Date startDate = plan.getDate("startdate");
                    Date endDate = plan.getDate("enddate");
                    if (startDate == null) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProvistonPlanOp_21", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (endDate != null && endDate.before(startDate)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u3002", (String)"ProvistonPlanOp_13", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (taxsysId == 1L) {
                        if (!DateUtils.format((Date)startDate).equalsIgnoreCase(DateUtils.getFirstDateOfMonthStr((Date)startDate, (String)"yyyy-MM-dd"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u9700\u4e3a\u6708\u521d1\u53f7\u3002", (String)"ProvistonPlanOp_11", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (Objects.nonNull(endDate) && !DateUtils.format((Date)endDate).equalsIgnoreCase(DateUtils.getLastDateOfMonthStr((Date)endDate, (String)"yyyy-MM-dd"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u9700\u4e3a\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"ProvistonPlanOp_12", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    if ((cycle = plan.getString("cycle")) == null) continue;
                    if ("month".equals(cycle)) {
                        if (!DateUtils.isMonthStartDay((Date)startDate)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8ba1\u7a0e\u5468\u671f\u201d\u4e3a\u6708\uff0c\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"ProvistonPlanOp_22", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (endDate == null || DateUtils.isMonthEndDay((Date)endDate)) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8ba1\u7a0e\u5468\u671f\u201d\u4e3a\u6708\uff0c\u6709\u6548\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"ProvistonPlanOp_23", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if ("season".equals(cycle)) {
                        if (!DateUtils.isSeasonStartDay((Date)startDate)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8ba1\u7a0e\u5468\u671f\u201d\u4e3a\u5b63\uff0c\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u5b63\u521d1\u53f7\u3002", (String)"ProvistonPlanOp_24", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (endDate == null || DateUtils.isSeasonEndDay((Date)endDate)) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8ba1\u7a0e\u5468\u671f\u201d\u4e3a\u5b63\uff0c\u6709\u6548\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u5b63\u672b\u6700\u540e1\u5929\u3002", (String)"ProvistonPlanOp_25", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!"year".equals(cycle)) continue;
                    if (!DateUtils.isYearStartDay((Date)startDate)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8ba1\u7a0e\u5468\u671f\u201d\u4e3a\u5e74\uff0c\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u5e74\u521d1\u53f7\u3002", (String)"ProvistonPlanOp_26", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (endDate == null || DateUtils.isYearEndDay((Date)endDate)) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8ba1\u7a0e\u5468\u671f\u201d\u4e3a\u5e74\uff0c\u6709\u6548\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u5e74\u672b\u6700\u540e1\u5929\u3002", (String)"ProvistonPlanOp_27", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                }
            }
        };
    }

    private boolean checkTaxAreaAvailable(DynamicObject taxsys, DynamicObject taxarea) {
        List areaGroupIds;
        DynamicObject country;
        TaxResult listTaxResult;
        return taxsys == null || taxsys.getDynamicObject("countryid") == null || (listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)(country = taxsys.getDynamicObject("countryid")).getLong("id"))) == null || CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) || (areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList())).contains(taxarea.getLong("id"));
    }

    private boolean checkTaxtsysAvailable(String planuseCode, String checkTaxsyssCode) {
        Optional<String> op = ProvisionPlanBusiness.getUsabaleTaxsys((String)planuseCode).stream().filter(item -> item.equals(checkTaxsyssCode)).findFirst();
        return op.isPresent();
    }

    private boolean checkTaxtypeAvailable(String planuseCode, String taxsysCode, String checkTaxtypeCode) {
        Optional<String> op = ProvisionPlanBusiness.getUsabaleTaxtype((String)planuseCode, (String)taxsysCode).stream().filter(item -> item.equals(checkTaxtypeCode)).findFirst();
        return op.isPresent();
    }

    private String getPlanuseName(String planuseCode) {
        String planuseName = "";
        if (planuseCode.contains("1") && planuseCode.contains("2")) {
            planuseName = ResManager.loadKDString((String)"\u7a0e\u91d1\u8ba1\u63d0\uff1b\u7eb3\u7a0e\u7533\u62a5", (String)"ProvistonPlanOp_17", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        } else if (planuseCode.contains("1")) {
            planuseName = ResManager.loadKDString((String)"\u7a0e\u91d1\u8ba1\u63d0", (String)"ProvistonPlanOp_18", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        } else if (planuseCode.contains("2")) {
            planuseName = ResManager.loadKDString((String)"\u7eb3\u7a0e\u7533\u62a5", (String)"ProvistonPlanOp_19", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        }
        return planuseName;
    }
}

