/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.org.mapping;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.common.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class OrgMapEntitySaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    String mapObjectId = currentObj.getString("mapobject.id");
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mapObjectId);
                    IDataEntityProperty numberProperty = entityType.findProperty("number");
                    IDataEntityProperty nameProperty = entityType.findProperty("name");
                    boolean isError = false;
                    if (null == numberProperty || null == nameProperty) {
                        isError = true;
                    } else if (ObjectUtils.isNotEmpty((Object)numberProperty) && StringUtil.isBlank((CharSequence)numberProperty.getAlias())) {
                        isError = true;
                    } else if (ObjectUtils.isNotEmpty((Object)nameProperty) && StringUtil.isBlank((CharSequence)nameProperty.getAlias())) {
                        isError = true;
                    }
                    if (!isError) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e\u4e0d\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6620\u5c04\u5bf9\u8c61\u3002", (String)"OrgMapEntitySaveOp_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
        });
    }
}

