/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.org.mapping;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class OrgMapRelationImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Map taxCategoryMap = OrgMapRelationBusiness.getTaxCategoryMap((String)"number", (boolean)false);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            JSONObject map = data.getData();
            JSONArray busObjectJSONArray = map.getJSONArray("entryentity");
            if (!(busObjectJSONArray instanceof JSONArray)) continue;
            HashSet<String> taxcategoryNumberSet = new HashSet<String>();
            busObjectJSONArray.stream().forEach(busObject -> {
                JSONObject busJson;
                String taxcategoryNumber;
                if (busObject instanceof JSONObject && StringUtil.isNotBlank((CharSequence)(taxcategoryNumber = (busJson = (JSONObject)busObject).getString("taxcategory")))) {
                    String[] taxcategoryNumbers = taxcategoryNumber.split(",");
                    Arrays.stream(taxcategoryNumbers).forEach(number -> {
                        if (StringUtil.isNotBlank((CharSequence)number)) {
                            taxcategoryNumberSet.add((String)number);
                        }
                    });
                }
            });
            Set taxcategorySet = taxcategoryNumberSet.stream().filter(o -> taxCategoryMap.containsKey(o)).collect(Collectors.toSet());
            if (taxcategoryNumberSet.size() > taxcategorySet.size()) {
                taxcategoryNumberSet.removeIf(o1 -> taxcategorySet.contains(o1));
                String number = StringUtil.join(taxcategoryNumberSet, (String)",");
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8be5\u7a0e\u79cd\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff1a%s", (String)"OrgMapRelationImportOp_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), number)).fail();
                if (!ObjectUtils.isNotEmpty(billdatas)) continue;
                it.remove();
                continue;
            }
            busObjectJSONArray.stream().forEach(busObject -> {
                JSONObject busJson;
                String taxcategoryNumber;
                if (busObject instanceof JSONObject && StringUtil.isNotBlank((CharSequence)(taxcategoryNumber = (busJson = (JSONObject)busObject).getString("taxcategory")))) {
                    String[] taxcategoryNumbers = taxcategoryNumber.split(",");
                    Set taxcategoryIds = Arrays.stream(taxcategoryNumbers).map(o -> String.valueOf(((DynamicObject)taxCategoryMap.get(o)).getLong("id"))).collect(Collectors.toSet());
                    busJson.put("taxcategory", (Object)StringUtil.join(taxcategoryIds, (String)","));
                }
            });
        }
        super.beforeSave(billdatas, logger);
    }

    protected boolean isForceBatch() {
        return true;
    }
}

