/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.org.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;

public class OrgMapRelationSaveValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, DynamicObject> orgMap = this.getOrgMap();
        DynamicObject currentObj = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            if (this.checkTaxOrgVoild(currentObj, dataEntity, orgMap) && this.checkEntryVolid(currentObj, dataEntity)) continue;
        }
    }

    protected Map<Long, DynamicObject> getOrgMap() {
        TaxResult taxResult;
        DynamicObject currentObj = null;
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        DynamicObject useOrg = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            useOrg = currentObj.getDynamicObject("useorg");
            if (useOrg == null) continue;
            orgIds.add(useOrg.getLong("id"));
        }
        Map<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(10);
        if (orgIds.size() > 0 && (taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIds(orgIds)) != null && taxResult.isSuccess()) {
            orgMap = ((List)taxResult.getData()).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        return orgMap;
    }

    protected boolean checkTaxOrgVoild(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> orgMap) {
        DynamicObject useOrg = currentObj.getDynamicObject("useorg");
        if (useOrg == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgMapRelationSaveValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        Long orgId = useOrg.getLong("id");
        String number = useOrg.getString("number");
        DynamicObject taxOrg = orgMap.get(orgId);
        if (taxOrg == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528\u3002", (String)"OrgMapRelationSaveValidator_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    protected boolean checkEntryVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection busObjectSubCol = currentObj.getDynamicObjectCollection("entryentity");
        if (busObjectSubCol.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6620\u5c04\u5173\u7cfb\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgMapRelationSaveValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return false;
        }
        int rowIndex = 0;
        for (DynamicObject entry : busObjectSubCol) {
            ++rowIndex;
            String taxcategory = entry.getString("taxcategory");
            if (!StringUtil.isEmpty((CharSequence)taxcategory)) continue;
            String erro = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6620\u5c04\u5173\u7cfb\u201d\u7b2c%s\u884c\uff1a\u201c\u9002\u7528\u7a0e\u79cd\u201d\u3002", (String)"OrgMapRelationSaveValidator_6", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(erro, rowIndex));
            return false;
        }
        Set businessNumberSet = busObjectSubCol.stream().map(o -> o.getString("businessnumber")).collect(Collectors.toSet());
        String mapObjectId = currentObj.getString("group.mapobject.id");
        QFilter busNumberFilter = new QFilter("number", "in", businessNumberSet);
        DynamicObjectCollection businessNumberCol = OrgMapRelationBusiness.queryBusinessObject((String)mapObjectId, (String)"id,number,name", (QFilter[])new QFilter[]{busNumberFilter});
        if (businessNumberSet.size() > businessNumberCol.size()) {
            Set set = businessNumberCol.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            businessNumberSet.removeIf(o -> set.contains(o));
            String businessNumber = StringUtil.join(businessNumberSet, (String)",");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\uff1a%s\u3002", (String)"OrgMapRelationSaveValidator_3", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), businessNumber));
            return false;
        }
        if (businessNumberSet.size() < busObjectSubCol.size()) {
            HashMap map = new HashMap();
            busObjectSubCol.stream().forEach(o -> {
                String businessNumber = o.getString("businessnumber");
                if (null != map.get(businessNumber)) {
                    map.put(businessNumber, (Integer)map.get(businessNumber) + 1);
                } else {
                    map.put(businessNumber, 1);
                }
            });
            ArrayList numbers = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                numbers.add(entry.getKey());
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u91cd\u590d\uff1a%s\u3002", (String)"OrgMapRelationSaveValidator_4", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), StringUtil.join(numbers, (String)",")));
            return false;
        }
        Map<String, DynamicObject> busObjectMap = businessNumberCol.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v1));
        DynamicObject dbBusObject = null;
        for (DynamicObject busObject : busObjectSubCol) {
            dbBusObject = busObjectMap.get(busObject.getString("businessnumber"));
            if (dbBusObject == null || StringUtil.isNotEmpty((CharSequence)busObject.getString("businessid"))) continue;
            busObject.set("businessid", dbBusObject.get("id"));
            busObject.set("businessname", dbBusObject.get("name"));
        }
        return true;
    }
}

