/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.org.mapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.business.changemodel.service.impl.BillTransferService;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;

public class OrgMapRelationUniqueValidator
extends AbstractValidator {
    public void validate() {
        List<DynamicObject> objects = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        Map<Long, DynamicObject> sourceBillMap = null;
        Map<Long, List<DynamicObject>> orgMapingMap = null;
        if (this.isChangeBill()) {
            BillTransferService billTransferService = new BillTransferService();
            Object[] srcBills = billTransferService.reserveSrcBill(objects.toArray(new DynamicObject[objects.size()]));
            sourceBillMap = Arrays.stream(srcBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            orgMapingMap = this.getOrgMapingMap(Lists.newArrayList((Object[])srcBills));
        } else {
            orgMapingMap = this.getOrgMapingMap(objects);
        }
        DynamicObject currentObj = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            if (this.isChangeBill() && sourceBillMap != null) {
                currentObj = sourceBillMap.get(currentObj.getLong("sourcebillid"));
            }
            this.checkTaxOrgBusObjectDuplicate(currentObj, dataEntity, orgMapingMap);
        }
    }

    protected Map<Long, List<DynamicObject>> getOrgMapingMap(List<DynamicObject> objects) {
        ArrayList<Long> groupIds = new ArrayList<Long>(10);
        DynamicObject group = null;
        ArrayList<Object> colls = new ArrayList<Object>(10);
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject currentObj : objects) {
            group = currentObj.getDynamicObject("group");
            if (group == null) continue;
            groupIds.add(group.getLong("id"));
            colls.add(currentObj);
            map.put(currentObj.getLong("id"), currentObj);
        }
        HashMap<Long, List<DynamicObject>> orgMapingMap = new HashMap<Long, List<DynamicObject>>(10);
        if (groupIds.size() > 0) {
            DynamicObject[] dbColls = OrgMapRelationBusiness.queryOrgMapRelationByGroupIds(groupIds);
            List uniqueDbColls = Stream.of(dbColls).filter(obj -> !map.containsKey(obj.getLong("id"))).collect(Collectors.toList());
            colls.addAll(uniqueDbColls);
            colls.forEach(v -> {
                Long groupId = v.getLong("group.id");
                if (!orgMapingMap.containsKey(groupId)) {
                    orgMapingMap.put(groupId, new ArrayList(10));
                }
                ((List)orgMapingMap.get(groupId)).add(v);
            });
        }
        return orgMapingMap;
    }

    protected void checkTaxOrgBusObjectDuplicate(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, List<DynamicObject>> orgMapingMap) {
        Long groupId = currentObj.getLong("group.id");
        List<DynamicObject> coll = orgMapingMap.get(groupId);
        if (coll == null || coll.size() == 0) {
            return;
        }
        List orgRelations = coll.stream().filter(obj -> currentObj.getLong("id") != obj.getLong("id")).collect(Collectors.toList());
        String orgName = currentObj.getDynamicObject("useorg").getString("name");
        DynamicObjectCollection busObjectSubCol = currentObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject currentBusObject : busObjectSubCol) {
            String businessNumber = currentBusObject.getString("businessnumber");
            String businessName = currentBusObject.getString("businessname");
            Date startDate = currentBusObject.getDate("startdate");
            Date endDate = currentBusObject.getDate("enddate");
            String taxType = currentBusObject.getString("taxcategory");
            for (DynamicObject relation : orgRelations) {
                for (DynamicObject busObject : relation.getDynamicObjectCollection("entryentity")) {
                    String oldBusinessNumber = busObject.getString("businessnumber");
                    Date oldStartDate = busObject.getDate("startdate");
                    Date oldEndDate = busObject.getDate("enddate");
                    String oldTaxType = busObject.getString("taxcategory");
                    if (!businessNumber.equals(oldBusinessNumber)) continue;
                    boolean dateDuplicate = this.hasDateDuplicate(startDate, endDate, oldStartDate, oldEndDate);
                    boolean taxTypeDuplicate = this.hasTaxTypeDuplicate(taxType, oldTaxType);
                    if (!dateDuplicate || !taxTypeDuplicate) continue;
                    String message = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\uff1a%3$s\u5728\u540c\u4e00\u4e2a\u6709\u6548\u671f\u5185\u4e14\u9002\u7528\u76f8\u540c\u7a0e\u79cd\u65f6\uff0c\u4e0d\u80fd\u5bf9\u5e94\u591a\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\uff1a%1$s,%2$s\u3002", (String)"OrgMapRelationSaveValidator_5", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), orgName, relation.getString("useorg.name"), businessName);
                    this.addFatalErrorMessage(dataEntity, message);
                }
            }
        }
    }

    protected boolean hasDateDuplicate(Date beginTime, Date endTime, Date startDate, Date endDate) {
        Date[] date;
        if (beginTime != null) {
            beginTime = DateUtils.getDayFirst((Date)beginTime);
        }
        if (endTime != null) {
            endTime = DateUtils.getDayFirst((Date)endTime);
        }
        if (startDate != null) {
            startDate = DateUtils.getDayFirst((Date)startDate);
        }
        if (endDate != null) {
            endDate = DateUtils.getDayFirst((Date)endDate);
        }
        return (date = DateUtils.getIntersectionDate((Date)beginTime, (Date)endTime, (Date)startDate, (Date)endDate)) != null && date.length > 0;
    }

    protected boolean hasTaxTypeDuplicate(String taxType, String oldTaxType) {
        if (StringUtil.isEmpty((CharSequence)taxType) || StringUtil.isEmpty((CharSequence)oldTaxType)) {
            return true;
        }
        String[] taxTypes = taxType.split(",");
        List<String> oldTaxTypes = Arrays.asList(oldTaxType.split(","));
        for (String value : taxTypes) {
            if (!oldTaxTypes.contains(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isChangeBill() {
        return "tctb_xorgmaprelation".equals(this.getEntityKey());
    }
}

