/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.packaudit;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.common.util.StringUtil;
import kd.taxc.enums.PackAuditCheckEnum;
import kd.taxc.tctb.business.packaudit.PackAuditTaskBusiness;

public class PackAuditCheckValidator
extends AbstractValidator {
    public void validate() {
        String sourceType;
        if (this.getOption().containsVariable("sourceType") && !StringUtil.isEmpty((CharSequence)(sourceType = this.getOption().getVariableValue("sourceType"))) && "tam".equals(sourceType)) {
            return;
        }
        boolean isPackAudit = PackAuditTaskBusiness.isPackAudit();
        if (!isPackAudit) {
            return;
        }
        List orgIds = Stream.of(this.dataEntities).map(v -> v.getDataEntity().getLong(this.getOrgField())).collect(Collectors.toList());
        DynamicObject[] objects = PackAuditTaskBusiness.queryPackAuditTaskByOrgIds(orgIds);
        List existTaskOrgIds = Stream.of(objects).map(v -> v.getLong("org.id")).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (!existTaskOrgIds.contains(dataEntity.getDataEntity().getLong(this.getOrgField()))) continue;
            this.addErrorMessage(dataEntity, this.getErrorMessage());
        }
    }

    protected String getOrgField() {
        return PackAuditCheckEnum.EntityOrgEnum.getEnum((String)this.getEntityKey()).getOrg();
    }

    protected String getErrorMessage() {
        return PackAuditCheckEnum.OperateMessageEnum.getEnum((String)this.getOperateKey()).getOpMessage();
    }
}

