/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.param;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.taxc.common.formula.utils.JsonUtils;
import kd.taxc.common.param.ParamUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;

public class TaxParamOp
extends AbstractOperationServicePlugIn {
    private static String PARAM_VALUE = "paramvalue";
    private static String AVALIBLE_VAL = "avalibleval";
    private static String PARAM_KEY = "paramkey";
    private static String MUL_VALUE = "mulvalue";
    private static String IS_MULTIPLE = "ismultiple";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String paramKey;
                    DynamicObject data = dataEntity.getDataEntity();
                    String formID = data.getString("pagekey");
                    if (!ParamUtil.isGroupControl((String)formID, (String)(paramKey = data.getString("paramkey"))).booleanValue() || OrgUnitServiceHelper.getRootOrgId() == data.getLong("org.id")) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u53c2\u6570\u4e3a\u96c6\u56e2\u7ba1\u63a7\u53c2\u6570\uff0c\u975e\u6839\u7ec4\u7ec7\u65e0\u6cd5\u66f4\u6539\u3002", (String)"TaxParamOp_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            if (this.getOption().containsVariable("batchimport")) continue;
            this.injectData(dataEntity);
        }
    }

    public void injectData(DynamicObject dataEntity) {
        Long orgid = dataEntity.getDynamicObject("org").getLong("id");
        String appid = dataEntity.getDynamicObject("group").getString("id");
        String paramKey = dataEntity.getString(PARAM_KEY);
        String paramValue = dataEntity.getString(PARAM_VALUE);
        String mulVal = dataEntity.getString(MUL_VALUE);
        String isMultiple = dataEntity.getString(IS_MULTIPLE);
        String avalibleVal = dataEntity.getString(AVALIBLE_VAL);
        if (StringUtil.equalsIgnoreCase((CharSequence)isMultiple, (CharSequence)"1")) {
            paramValue = mulVal;
        }
        HashMap<String, String> paramKeyAndValues = new HashMap<String, String>();
        paramKeyAndValues.put(paramKey, paramValue);
        String paramChineseValue = null;
        if (StringUtil.equalsIgnoreCase((CharSequence)isMultiple, (CharSequence)"1") && EmptyCheckUtils.isNotEmpty((Object)mulVal)) {
            String[] splitedVAl = mulVal.split(",", -1);
            paramChineseValue = this.convert(splitedVAl, JsonUtils.strToMap((String)avalibleVal));
        } else {
            paramChineseValue = (String)JsonUtils.strToMap((String)avalibleVal).get(paramValue);
        }
        SystemParamServiceHelper.saveAppParameter((String)appid, (String)ParamUtil.getViewType((String)appid), (Long)orgid, (Long)0L, paramKeyAndValues);
        dataEntity.set(PARAM_VALUE, (Object)paramChineseValue);
    }

    public String convert(String[] splitedVal, Map<String, String> avalibleVal) {
        StringBuilder vals = new StringBuilder();
        for (String val : splitedVal) {
            if (!EmptyCheckUtils.isNotEmpty((Object)val)) continue;
            vals.append(avalibleVal.get(val));
            vals.append('\uff1b');
        }
        return vals.toString();
    }
}

