/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.provision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.StringUtil;

public class TaxprovisionListDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TaxprovisionListDeleteOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        logger.info("start TaxprovisionListDeleteOp beginOperationTransaction " + operationKey);
        if (StringUtil.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"delete")) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List ids = Arrays.stream(dataEntities).map(o -> o.getPkValue()).collect(Collectors.toList());
            QFilter idQ = new QFilter("id", "in", ids);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"entitytype,entitynumber,id,sourcedrafttype", (QFilter[])new QFilter[]{idQ});
            ArrayList reverseList = new ArrayList(8);
            HashMap currentMap = new HashMap(12);
            if (!ObjectUtils.isEmpty((Object)collection)) {
                collection.stream().forEach(row -> {
                    String draftNumber = row.getString("entitynumber");
                    String entityId = row.getString("id");
                    if (currentMap.containsKey(draftNumber)) {
                        ((List)currentMap.get(draftNumber)).add(entityId);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(entityId);
                        currentMap.put(draftNumber, list);
                    }
                });
                List sourceDraftTypeList = collection.stream().map(o -> o.getString("sourcedrafttype")).collect(Collectors.toList());
                List entityNumberList = collection.stream().map(o -> o.getString("entitynumber")).collect(Collectors.toList());
                QFilter sourceDraftTypeQ = new QFilter("sourcedrafttype", "in", sourceDraftTypeList);
                QFilter entityNumberQ = new QFilter("entitynumber", "in", entityNumberList);
                DynamicObjectCollection oldCol = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"id,billno,entitytype,entitynumber,sourcedrafttype", (QFilter[])new QFilter[]{sourceDraftTypeQ, entityNumberQ});
                HashMap entityMap = new HashMap();
                oldCol.stream().forEach(row -> {
                    String draftNumber = row.getString("entitynumber");
                    String entityId = row.getString("id");
                    if (entityMap.containsKey(draftNumber)) {
                        ((List)entityMap.get(draftNumber)).add(entityId);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(entityId);
                        entityMap.put(draftNumber, list);
                    }
                });
                Set currentEntrySet = currentMap.entrySet();
                currentEntrySet.stream().forEach(coll -> {
                    String collkey = (String)coll.getKey();
                    List valueList = (List)coll.getValue();
                    if (!ObjectUtils.isEmpty(entityMap.get(collkey)) && valueList.containsAll((Collection)entityMap.get(collkey))) {
                        reverseList.add(collkey);
                    }
                });
            }
            logger.info("reverseList " + reverseList.size());
            if (!ObjectUtils.isEmpty(reverseList)) {
                logger.info("reverseList billnos" + (String)reverseList.get(0));
                QFilter billNoQ = new QFilter("billno", "in", reverseList);
                DynamicObject[] draftDeleteList = BusinessDataServiceHelper.load((String)"tpo_declare_main_tsd", (String)"billno,generatebusinessdoc,businessdocno", (QFilter[])new QFilter[]{billNoQ});
                Arrays.stream(draftDeleteList).forEach(dynamicObject -> {
                    dynamicObject.set("generatebusinessdoc", (Object)Boolean.FALSE);
                    dynamicObject.set("businessdocno", (Object)" ");
                });
                ArrayList successNumber = new ArrayList();
                Object[] save = SaveServiceHelper.save((DynamicObject[])draftDeleteList);
                Arrays.stream(save).forEach(o -> successNumber.add(((DynamicObject)o).getString("billno")));
                logger.info("reverseList successNumber billnos " + successNumber.size());
                ArrayList failIdList = new ArrayList();
                reverseList.removeAll(successNumber);
                if (!ObjectUtils.isEmpty(reverseList)) {
                    StringBuilder recordfailbillnos = new StringBuilder();
                    reverseList.stream().forEach(o -> {
                        if (currentMap.containsKey(o)) {
                            failIdList.addAll((Collection)currentMap.get(o));
                        }
                        recordfailbillnos.append((String)o).append(" ");
                    });
                    logger.info("reverseList fail billnos " + recordfailbillnos);
                }
                if (!ObjectUtils.isEmpty(failIdList)) {
                    ArrayList result = new ArrayList(8);
                    Arrays.stream(args.getDataEntities()).forEach(row -> {
                        if (!failIdList.contains(row.getString("id"))) {
                            result.add(row);
                        }
                    });
                    args.setDataEntities(result.toArray(new DynamicObject[result.size()]));
                    logger.info("sucess result" + result.size());
                }
            }
        }
    }
}

