/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.shareplan;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.provision.ProvisionPlanBusiness;
import kd.taxc.tctb.business.shareplan.JtjsShareDynamiciWrapper;
import kd.taxc.tctb.business.shareplan.ProvisionSharePlanBusiness;

public class ProvisionSharePlanValidator
extends AbstractValidator {
    public void validate() {
        List<DynamicObject> objs = Stream.of(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        Map<Long, DynamicObject> orgMap = this.getOrgMap(objs);
        Map<Long, DynamicObject> ruleMap = this.getRuleMap(objs);
        DynamicObject[] allShareInDb = this.getAllInDb();
        List<DynamicObject> allShareInCheck = Arrays.stream(this.getDataEntities()).map(item -> item.getDataEntity()).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            if (this.checkRuleEntityVolid(currentObj, dataEntity, ruleMap) && this.checkOrgEntityVolid(currentObj, dataEntity, orgMap) && this.checkShareWithSelf(dataEntity) && this.checkShareWithOher(dataEntity, allShareInCheck.toArray(new DynamicObject[0])) && this.checkShareWithOher(dataEntity, allShareInDb)) continue;
        }
    }

    private boolean checkShareWithSelf(ExtendedDataEntity checkEntity) {
        DynamicObject checkShare = checkEntity.getDataEntity();
        JtjsShareDynamiciWrapper checkWrapper = new JtjsShareDynamiciWrapper(checkShare);
        List existShareOrgIds = checkWrapper.getOrgIds();
        List existSharePlanIds = checkWrapper.getPlanIds();
        for (Long orgId : existShareOrgIds) {
            if (!checkWrapper.existMultiOrg(orgId)) continue;
            this.addFatalErrorMessage(checkEntity, this.getErro4(checkWrapper.getOrg(orgId)));
            return false;
        }
        for (Long planId : existSharePlanIds) {
            if (checkWrapper.existMultiPlan(planId)) {
                this.addFatalErrorMessage(checkEntity, this.getErro5(checkWrapper.getPlan(planId)));
                return false;
            }
            for (Long planId2 : existSharePlanIds) {
                if (planId.compareTo(planId2) == 0 || !ProvisionPlanBusiness.matchDimensionShare((DynamicObject)checkWrapper.getPlan(planId), (DynamicObject)checkWrapper.getPlan(planId2))) continue;
                String erro = this.getErro3();
                this.addFatalErrorMessage(checkEntity, erro);
                return false;
            }
        }
        return true;
    }

    private boolean checkShareWithOher(ExtendedDataEntity checkEntity, DynamicObject[] ohterShare) {
        DynamicObject checkShare = checkEntity.getDataEntity();
        JtjsShareDynamiciWrapper checkWrapper = new JtjsShareDynamiciWrapper(checkShare);
        for (DynamicObject existShare : ohterShare) {
            JtjsShareDynamiciWrapper existWrapper = new JtjsShareDynamiciWrapper(existShare);
            if (existWrapper.isSameId(checkWrapper) || existWrapper.isSameObj(checkWrapper)) continue;
            List existShareOrgIds = existWrapper.getOrgIds();
            for (Long existShareOrgId : existShareOrgIds) {
                if (!checkWrapper.existOrg(existShareOrgId)) continue;
                List existSharePlanIds = existWrapper.getPlanIds();
                for (Long existSharePlanId : existSharePlanIds) {
                    if (checkWrapper.existPlan(existSharePlanId)) {
                        String erro = this.getErro1(existWrapper.getOrg(existShareOrgId), existWrapper.getPlan(existSharePlanId));
                        this.addFatalErrorMessage(checkEntity, erro);
                        return false;
                    }
                    List checkSharePlanIds = checkWrapper.getPlanIds();
                    for (Long checkPlanId : checkSharePlanIds) {
                        if (!ProvisionPlanBusiness.matchDimensionShare((DynamicObject)checkWrapper.getPlan(checkPlanId), (DynamicObject)existWrapper.getPlan(existSharePlanId))) continue;
                        String erro = this.getErro2(existWrapper.getShareDyn(), existWrapper.getOrg(existShareOrgId), checkWrapper.getPlan(checkPlanId), existWrapper.getPlan(existSharePlanId));
                        this.addFatalErrorMessage(checkEntity, erro);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private String getErro1(DynamicObject org, DynamicObject plan) {
        String orgName = org.getString("name");
        String planNumber = plan.getString("number");
        String str = ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u201c%1s\u201d\u5df2\u5b58\u5728\u8ba1\u7a0e\u65b9\u6848\u201c%2s\u201d\uff0c\u4e0d\u80fd\u91cd\u590d\u5206\u914d\u3002", (String)"ProvisionSharePlanValidator_4", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        return String.format(str, orgName, planNumber);
    }

    private String getErro2(DynamicObject existShare, DynamicObject org, DynamicObject newPlan, DynamicObject exsitPlan) {
        String orgName = org.getString("name");
        String newPlanNumber = newPlan.getString("number");
        String existPlanNumber = exsitPlan.getString("number");
        String existShareName = existShare.getString("name");
        String str = ResManager.loadKDString((String)"\u8ba1\u7a0e\u65b9\u6848\u201c%1s\u201d\u5206\u914d\u5931\u8d25\uff0c\u7a0e\u52a1\u7ec4\u7ec7\u201c%2s\u201d\u5df2\u5206\u914d\u76f8\u540c\u7ef4\u5ea6\uff08\u65b9\u6848\u7528\u9014\u3001\u7a0e\u6536\u5236\u5ea6\u3001\u7a0e\u79cd\u3001\u7a0e\u6536\u8f96\u533a\u76f8\u540c\uff0c\u6709\u6548\u671f\u8d77\u6b62\u65f6\u95f4\u6bb5\u5b58\u5728\u4ea4\u96c6\uff09\u7684\u8ba1\u7a0e\u65b9\u6848\u201c%3s\u201d\uff0c\u8bf7\u524d\u5f80\u5171\u4eab\u65b9\u6848\u201c%4s\u201d\u68c0\u67e5\u3002", (String)"ProvisionSharePlanValidator_5", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        return String.format(str, newPlanNumber, orgName, existPlanNumber, existShareName);
    }

    private String getErro3() {
        return ResManager.loadKDString((String)"\u201c\u5171\u4eab\u65b9\u6848\u8303\u56f4\u201d\u4e2d\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6570\u636e\uff08\u65b9\u6848\u7528\u9014\u3001\u7a0e\u6536\u5236\u5ea6\u3001\u7a0e\u79cd\u3001\u7a0e\u6536\u8f96\u533a\u76f8\u540c\uff0c\u6709\u6548\u671f\u8d77\u6b62\u65f6\u95f4\u6bb5\u5b58\u5728\u4ea4\u96c6\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProvisionSharePlanValidator_6", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
    }

    private String getErro4(DynamicObject org) {
        String orgName = org.getString("name");
        String str = ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7\uff1a%1s\u3002", (String)"ProvisionSharePlanValidator_7", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        return String.format(str, orgName);
    }

    private String getErro5(DynamicObject plan) {
        String planNumber = plan.getString("number");
        String str = ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u65b9\u6848\uff1a%1s\u3002", (String)"ProvisionSharePlanValidator_8", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        return String.format(str, planNumber);
    }

    private DynamicObject[] getAllInDb() {
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tctb_jtfa_shareplan", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,ruleentity,orgentity,ruleentity.seq,ruleentity.rule,ruleentity.rule.taxsystem,ruleentity.rule.taxtype,ruleentity.rule.number,ruleentity.rule.cycle,ruleentity.rule.taxarea,ruleentity.rule.booktype,ruleentity.rule.isdimprovision,ruleentity.rule.enable,ruleentity.rule.provisiondimension,ruleentity.rule.businessdimension,ruleentity.rule.businessdimension.fbasedataid.id,ruleentity.rule.startdate,ruleentity.rule.enddate,ruleentity.rule.planuse,orgentity.seq,orgentity.org", (QFilter[])new QFilter[0]);
        return dyns;
    }

    protected boolean checkRuleEntityVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> ruleMap) {
        DynamicObjectCollection ruleEntity = currentObj.getDynamicObjectCollection("ruleentity");
        DynamicObject rule = null;
        DynamicObject dbRule = null;
        for (DynamicObject entry : ruleEntity) {
            rule = entry.getDynamicObject("rule");
            if (rule == null || (dbRule = ruleMap.get(rule.getLong("id"))) == null || StringUtil.equalsIgnoreCase((CharSequence)dbRule.getString("enable"), (CharSequence)"1")) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u8ba1\u7a0e\u65b9\u6848\uff1a%s\u3002", (String)"ProvisionSharePlanValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), dbRule.get("number")));
            return false;
        }
        return true;
    }

    protected boolean checkOrgEntityVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> orgMap) {
        DynamicObjectCollection orgEntity = currentObj.getDynamicObjectCollection("orgentity");
        DynamicObject dbOrg = null;
        DynamicObject org = null;
        for (DynamicObject orgEntry : orgEntity) {
            org = orgEntry.getDynamicObject("org");
            if (org == null || (dbOrg = orgMap.get(org.getLong("id"))) != null) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7ec4\u7ec7\uff1a%1s\u3002", (String)"ProvisionSharePlanValidator_9", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        return true;
    }

    protected Map<Long, DynamicObject> getRuleMap(List<DynamicObject> objs) {
        List ruleIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("ruleentity").stream()).filter(entry -> entry.getDynamicObject("rule") != null).map(entry -> entry.getLong("rule.id")).collect(Collectors.toList());
        DynamicObject[] rules = ProvisionPlanBusiness.queryProvisionPlanByIds(ruleIds);
        Map<Long, DynamicObject> ruleMap = Stream.of(rules).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        return ruleMap;
    }

    protected Map<Long, DynamicObject> getOrgMap(List<DynamicObject> objs) {
        List orgIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("orgentity").stream()).filter(entry -> entry.getDynamicObject("org") != null).map(entry -> entry.getLong("org.id")).collect(Collectors.toList());
        List orgs = ProvisionSharePlanBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer(orgIds);
        Map<Long, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        return orgMap;
    }
}

