/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.shareplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.shareplan.TaxSharePlanBusiness;
import kd.taxc.tctb.business.taxplan.TaxcPlanBusiness;
import org.apache.commons.collections4.CollectionUtils;

public class TaxSharePlanValidator
extends AbstractValidator {
    public void validate() {
        List<DynamicObject> objs = Stream.of(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        Map<Long, DynamicObject> orgMap = this.getOrgMap(objs);
        Map<Long, DynamicObject> ruleMap = this.getRuleMap(objs);
        List<DynamicObject> allObjs = this.getAllObjs(objs);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            if (this.checkRuleEntityVolid(currentObj, dataEntity, ruleMap) && this.checkOrgEntityVolid(currentObj, dataEntity, orgMap) && this.checkGroupFieldUnique(currentObj, dataEntity, allObjs)) continue;
        }
    }

    protected boolean checkRuleEntityVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> ruleMap) {
        DynamicObjectCollection ruleEntity = currentObj.getDynamicObjectCollection("ruleentity");
        DynamicObject rule = null;
        DynamicObject dbRule = null;
        for (DynamicObject entry : ruleEntity) {
            rule = entry.getDynamicObject("rule");
            if (rule == null || (dbRule = ruleMap.get(rule.getLong("id"))) == null || StringUtil.equalsIgnoreCase((CharSequence)dbRule.getString("enable"), (CharSequence)"1")) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u8ba1\u7a0e\u65b9\u6848\uff1a%s\u3002", (String)"TaxSharePlanValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), dbRule.get("number")));
            return false;
        }
        return true;
    }

    protected boolean checkOrgEntityVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> orgMap) {
        DynamicObjectCollection orgEntity = currentObj.getDynamicObjectCollection("orgentity");
        DynamicObject dbOrg = null;
        DynamicObject org = null;
        if (orgEntity.size() <= 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxSharePlanValidator_4", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject orgEntry : orgEntity) {
            org = orgEntry.getDynamicObject("org");
            if (org == null || (dbOrg = orgMap.get(org.getLong("id"))) != null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u53ef\u7528\u6216\u4e0d\u5b58\u5728\u3002", (String)"TaxSharePlanValidator_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean checkGroupFieldUnique(DynamicObject currentObj, ExtendedDataEntity dataEntity, List<DynamicObject> allObjs) {
        Map<String, List<DynamicObject>> currentRuleMap = currentObj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> TaxcPlanBusiness.getDimKey((DynamicObject)rule)));
        for (Map.Entry<String, List<DynamicObject>> entry : currentRuleMap.entrySet()) {
            List<DynamicObject> rules = currentRuleMap.get(entry.getKey());
            List list = rules.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(v -> v.getString("number")))), ArrayList::new));
            if (!CollectionUtils.isNotEmpty((Collection)list) || list.size() <= 1 || !TaxcPlanBusiness.hasDateDuplicate((List)list, (boolean)true)) continue;
            String ruleNumber = ((DynamicObject)list.get(0)).getString("number");
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5171\u4eab\u65b9\u6848\u8303\u56f4\u201d\u4e2d\u4e0d\u80fd\u5b58\u5728\u76f8\u540c\u7a0e\u79cd\u4e14\u6709\u6548\u671f\u5b58\u5728\u4ea4\u96c6\u7684\u8ba1\u7a0e\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxSharePlanValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject obj : allObjs) {
            String ruleNumber;
            List<DynamicObject> orgs;
            if (StringUtil.equalsIgnoreCase((CharSequence)obj.getString("id"), (CharSequence)currentObj.getString("id")) || (orgs = this.getSameOrgs(currentObj, obj)).size() <= 0) continue;
            List<DynamicObject> rules = this.getSameDimRules(currentObj, obj);
            Map<Long, List<DynamicObject>> ruleMap = rules.stream().collect(Collectors.groupingBy(rule -> rule.getLong("id")));
            List sameRules = rules.stream().filter(rule -> ruleMap.get(rule.getLong("id")) != null && ((List)ruleMap.get(rule.getLong("id"))).size() > 1 || TaxcPlanBusiness.hasDateDuplicate((DynamicObject)rule, (List)rules, (boolean)true)).collect(Collectors.toList());
            if (sameRules.size() <= 0) continue;
            String orgName = orgs.stream().map(v -> v.getString("name")).collect(Collectors.joining("\u3001"));
            String currentRuleNumber = ruleNumber = sameRules.stream().map(v -> v.getString("number")).distinct().collect(Collectors.joining("\u3001"));
            String destRuleNumber = ruleNumber;
            if (ruleNumber.split("\u3001").length > 1) {
                currentRuleNumber = ruleNumber.split("\u3001")[0];
                destRuleNumber = ruleNumber.split("\u3001")[1];
            }
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u7a0e\u65b9\u6848\u201c%1s\u201d\u5171\u4eab\u5931\u8d25\uff0c\u7a0e\u52a1\u7ec4\u7ec7\u201c%2s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff08\u7a0e\u79cd\u76f8\u540c\uff0c\u6709\u6548\u671f\u5b58\u5728\u4ea4\u96c6\uff09\u7684\u8ba1\u7a0e\u65b9\u6848\u201c%3s\u201d\uff0c\u8bf7\u524d\u5f80\u5171\u4eab\u65b9\u6848\u201c%4s\u201d\u68c0\u67e5\u3002", (String)"TaxSharePlanValidator_3", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), currentRuleNumber, orgName, destRuleNumber, obj.getString("number")));
            return false;
        }
        return true;
    }

    protected List<DynamicObject> getSameOrgs(DynamicObject currentObj, DynamicObject obj) {
        Map<Long, List<DynamicObject>> currentOrgMap = currentObj.getDynamicObjectCollection("orgentity").stream().filter(v -> v.getDynamicObject("org") != null).map(v -> v.getDynamicObject("org")).collect(Collectors.groupingBy(org -> org.getLong("id")));
        Map<Long, List<DynamicObject>> orgMap = obj.getDynamicObjectCollection("orgentity").stream().filter(v -> v.getDynamicObject("org") != null).map(v -> v.getDynamicObject("org")).collect(Collectors.groupingBy(org -> org.getLong("id")));
        ArrayList<DynamicObject> sameOrgs = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : currentOrgMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)currentOrgMap.get(entry.getKey())) || CollectionUtils.isEmpty((Collection)orgMap.get(entry.getKey()))) continue;
            sameOrgs.addAll((Collection<DynamicObject>)currentOrgMap.get(entry.getKey()));
        }
        return sameOrgs;
    }

    protected List<DynamicObject> getSameDimRules(DynamicObject currentObj, DynamicObject obj) {
        Map<String, List<DynamicObject>> ruleMap = obj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> TaxcPlanBusiness.getDimKey((DynamicObject)rule)));
        Map<String, List<DynamicObject>> currentRuleMap = currentObj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> TaxcPlanBusiness.getDimKey((DynamicObject)rule)));
        ArrayList<DynamicObject> sameDimObjs = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, List<DynamicObject>> entry : currentRuleMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)currentRuleMap.get(entry.getKey())) || CollectionUtils.isEmpty((Collection)ruleMap.get(entry.getKey()))) continue;
            sameDimObjs.addAll((Collection<DynamicObject>)currentRuleMap.get(entry.getKey()));
            sameDimObjs.addAll((Collection<DynamicObject>)ruleMap.get(entry.getKey()));
        }
        return sameDimObjs;
    }

    protected Map<Long, DynamicObject> getRuleMap(List<DynamicObject> objs) {
        List ruleIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("ruleentity").stream()).filter(entry -> entry.getDynamicObject("rule") != null).map(entry -> entry.getLong("rule.id")).collect(Collectors.toList());
        DynamicObject[] rules = TaxcPlanBusiness.loadByIds(ruleIds);
        Map<Long, DynamicObject> ruleMap = Stream.of(rules).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        return ruleMap;
    }

    protected Map<Long, DynamicObject> getOrgMap(List<DynamicObject> objs) {
        List orgIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("orgentity").stream()).filter(entry -> entry.getDynamicObject("org") != null).map(entry -> entry.getLong("org.id")).collect(Collectors.toList());
        List orgs = TaxSharePlanBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer(orgIds);
        Map<Long, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        return orgMap;
    }

    protected List<DynamicObject> getAllObjs(List<DynamicObject> objs) {
        List orgIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("orgentity").stream()).filter(entry -> entry.getDynamicObject("org") != null).map(entry -> entry.getLong("org.id")).collect(Collectors.toList());
        DynamicObject[] dbObjs = TaxSharePlanBusiness.queryTaxSharePlanByOrgIds(orgIds);
        ArrayList<DynamicObject> newObjs = new ArrayList<DynamicObject>(10);
        newObjs.addAll(objs);
        Map<Long, DynamicObject> objMap = objs.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        List newDbObjs = Stream.of(dbObjs).filter(obj -> !objMap.containsKey(obj.getLong("id"))).collect(Collectors.toList());
        newObjs.addAll(newDbObjs);
        return newObjs;
    }
}

