/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.shareplan.jtgz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.provision.ProvisionRuleBusiness;
import kd.taxc.tctb.business.shareplan.jtgz.ProvisionRuleSharePlanBusiness;
import org.apache.commons.collections4.CollectionUtils;

public class ProvisionRuleSharePlanValidator
extends AbstractValidator {
    public void validate() {
        List<DynamicObject> objs = Stream.of(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        Map<Long, DynamicObject> orgMap = this.getOrgMap(objs);
        Map<Long, DynamicObject> ruleMap = this.getRuleMap(objs);
        List<DynamicObject> allObjs = this.getAllObjs(objs);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            if (this.checkRuleEntityVolid(currentObj, dataEntity, ruleMap) && this.checkOrgEntityVolid(currentObj, dataEntity, orgMap) && this.checkGroupFieldUnique(currentObj, dataEntity, allObjs)) continue;
        }
    }

    protected boolean checkRuleEntityVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> ruleMap) {
        DynamicObjectCollection ruleEntity = currentObj.getDynamicObjectCollection("ruleentity");
        DynamicObject rule = null;
        DynamicObject dbRule = null;
        for (DynamicObject entry : ruleEntity) {
            rule = entry.getDynamicObject("rule");
            if (rule == null || (dbRule = ruleMap.get(rule.getLong("id"))) != null && (dbRule == null || StringUtil.equalsIgnoreCase((CharSequence)dbRule.getString("enable"), (CharSequence)"1"))) continue;
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u8ba1\u63d0\u89c4\u5219\uff1a%s\u3002", (String)"ProvisionRuleSharePlanValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), rule.get("number")));
            return false;
        }
        return true;
    }

    protected boolean checkOrgEntityVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, Map<Long, DynamicObject> orgMap) {
        DynamicObjectCollection orgEntity = currentObj.getDynamicObjectCollection("orgentity");
        DynamicObject dbOrg = null;
        DynamicObject org = null;
        for (DynamicObject orgEntry : orgEntity) {
            org = orgEntry.getDynamicObject("org");
            if (org == null || (dbOrg = orgMap.get(org.getLong("id"))) != null) continue;
            String msg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7ec4\u7ec7\uff1a%1s\u3002", (String)"ProvisionRuleSharePlanValidator_5", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, String.format(msg, org.getString("name")));
            return false;
        }
        return true;
    }

    protected boolean checkGroupFieldUnique(DynamicObject currentObj, ExtendedDataEntity dataEntity, List<DynamicObject> allObjs) {
        for (DynamicObject obj : allObjs) {
            List<DynamicObject> rules;
            List<DynamicObject> orgs;
            if (StringUtil.equalsIgnoreCase((CharSequence)obj.getString("id"), (CharSequence)currentObj.getString("id")) || (orgs = this.getSameOrgs(currentObj, obj)).size() <= 0 || (rules = this.getSameRules(currentObj, obj)).size() <= 0) continue;
            String orgName = orgs.stream().map(v -> v.getString("name")).distinct().collect(Collectors.joining("\u3001"));
            String ruleNumber = rules.stream().map(v -> v.getString("number")).distinct().collect(Collectors.joining("\u3001"));
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\"%1$s\"\u4e0d\u80fd\u540c\u65f6\u5206\u914d\u8ba1\u63d0\u89c4\u5219\"%2$s\"\u3002", (String)"ProvisionRuleSharePlanValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), orgName, ruleNumber));
            return false;
        }
        return true;
    }

    protected List<DynamicObject> getSameOrgs(DynamicObject currentObj, DynamicObject obj) {
        Map<Long, List<DynamicObject>> currentOrgMap = currentObj.getDynamicObjectCollection("orgentity").stream().filter(v -> v.getDynamicObject("org") != null).map(v -> v.getDynamicObject("org")).collect(Collectors.groupingBy(org -> org.getLong("id")));
        Map<Long, List<DynamicObject>> orgMap = obj.getDynamicObjectCollection("orgentity").stream().filter(v -> v.getDynamicObject("org") != null).map(v -> v.getDynamicObject("org")).collect(Collectors.groupingBy(org -> org.getLong("id")));
        ArrayList<DynamicObject> sameOrgs = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : currentOrgMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)currentOrgMap.get(entry.getKey())) || CollectionUtils.isEmpty((Collection)orgMap.get(entry.getKey()))) continue;
            sameOrgs.addAll((Collection<DynamicObject>)currentOrgMap.get(entry.getKey()));
        }
        return sameOrgs;
    }

    protected List<DynamicObject> getSameRules(DynamicObject currentObj, DynamicObject obj) {
        Map<Long, List<DynamicObject>> currentRuleMap = currentObj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> rule.getLong("id")));
        Map<Long, List<DynamicObject>> ruleMap = obj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> rule.getLong("id")));
        ArrayList<DynamicObject> sameDimObjs = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, List<DynamicObject>> entry : currentRuleMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)currentRuleMap.get(entry.getKey())) || CollectionUtils.isEmpty((Collection)ruleMap.get(entry.getKey()))) continue;
            sameDimObjs.addAll((Collection<DynamicObject>)currentRuleMap.get(entry.getKey()));
            sameDimObjs.addAll((Collection<DynamicObject>)ruleMap.get(entry.getKey()));
        }
        return sameDimObjs;
    }

    protected List<DynamicObject> getSameDimRules(DynamicObject currentObj, DynamicObject obj) {
        Map<String, List<DynamicObject>> currentRuleMap = currentObj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> ProvisionRuleBusiness.getDimKey((DynamicObject)rule)));
        Map<String, List<DynamicObject>> ruleMap = obj.getDynamicObjectCollection("ruleentity").stream().filter(v -> v.getDynamicObject("rule") != null).map(v -> v.getDynamicObject("rule")).collect(Collectors.groupingBy(rule -> ProvisionRuleBusiness.getDimKey((DynamicObject)rule)));
        ArrayList<DynamicObject> sameDimObjs = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, List<DynamicObject>> entry : currentRuleMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)currentRuleMap.get(entry.getKey())) || CollectionUtils.isEmpty((Collection)ruleMap.get(entry.getKey()))) continue;
            sameDimObjs.addAll((Collection<DynamicObject>)currentRuleMap.get(entry.getKey()));
            sameDimObjs.addAll((Collection<DynamicObject>)ruleMap.get(entry.getKey()));
        }
        return sameDimObjs;
    }

    protected Map<Long, DynamicObject> getRuleMap(List<DynamicObject> objs) {
        List ruleIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("ruleentity").stream()).filter(entry -> entry.getDynamicObject("rule") != null).map(entry -> entry.getLong("rule.id")).collect(Collectors.toList());
        DynamicObject[] rules = ProvisionRuleBusiness.queryProvisionRuleByIds(ruleIds);
        Map<Long, DynamicObject> ruleMap = Stream.of(rules).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        return ruleMap;
    }

    protected Map<Long, DynamicObject> getOrgMap(List<DynamicObject> objs) {
        List orgIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("orgentity").stream()).filter(entry -> entry.getDynamicObject("org") != null).map(entry -> entry.getLong("org.id")).collect(Collectors.toList());
        List orgs = ProvisionRuleSharePlanBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer(orgIds);
        Map<Long, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        return orgMap;
    }

    protected List<DynamicObject> getAllObjs(List<DynamicObject> objs) {
        List orgIds = objs.stream().flatMap(v -> v.getDynamicObjectCollection("orgentity").stream()).filter(entry -> entry.getDynamicObject("org") != null).map(entry -> entry.getLong("org.id")).collect(Collectors.toList());
        DynamicObject[] dbObjs = ProvisionRuleSharePlanBusiness.queryProvisionRuleSharePlanByOrgIds(orgIds);
        ArrayList<DynamicObject> newObjs = new ArrayList<DynamicObject>(10);
        newObjs.addAll(objs);
        Map<Long, DynamicObject> objMap = objs.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        List newDbObjs = Stream.of(dbObjs).filter(obj -> !objMap.containsKey(obj.getLong("id"))).collect(Collectors.toList());
        newObjs.addAll(newDbObjs);
        return newObjs;
    }
}

