/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.supplier;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.common.util.DateUtils;
import kd.taxc.tctb.business.supplier.TaxSupplierBusiness;

public class TaxSupplierValidator
extends AbstractValidator {
    public void validate() {
        String operationKey = this.getOperateKey();
        if (OperateCodeEnum.SAVE.getOperateCode().equalsIgnoreCase(operationKey)) {
            this.doSaveValidators();
        }
    }

    protected void doSaveValidators() {
        List objs = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        List supplierIds = objs.stream().filter(v -> v.getDynamicObject("supplier") != null).map(v -> v.getDynamicObject("supplier").getLong("id")).collect(Collectors.toList());
        DynamicObject[] objects = TaxSupplierBusiness.queryTaxSupplierBySupplierIds(supplierIds);
        List<DynamicObject> dbObjs = Arrays.stream(objects).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            if (this.checkSupplierVolid(currentObj, dataEntity, dbObjs) && this.checkGroupFieldUnique(currentObj, dataEntity)) continue;
        }
    }

    protected boolean checkSupplierVolid(DynamicObject currentObj, ExtendedDataEntity dataEntity, List<DynamicObject> dbObjs) {
        DynamicObject supplier = currentObj.getDynamicObject("supplier");
        if (!"1".equals(supplier.getString("enable"))) {
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff0c\u82e5\u60f3\u91cd\u65b0\u542f\u7528\uff0c\u8bf7\u524d\u5f80\u7cfb\u7edf\u670d\u52a1\u4e91\u57fa\u7840\u8d44\u6599\u4e2d\u8bbe\u7f6e", (String)"TaxSupplierValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), supplier.get("name")));
            return false;
        }
        if (!"C".equals(supplier.getString("status"))) {
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u201c%s\u201d\u672a\u5ba1\u6838\uff0c\u5355\u636e\u65e0\u6cd5\u4fdd\u5b58\u3002\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u6570\u636e>\u4e3b\u6570\u636e>\u4f9b\u5e94\u5546\u201d\u5b8c\u6210\u8be5\u4f9b\u5e94\u5546\u7684\u4fe1\u606f\u5ba1\u6838\u3002", (String)"TaxSupplierValidator_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), supplier.get("name")));
            return false;
        }
        List<DynamicObject> objs = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity()).collect(Collectors.toList());
        if (this.hasSupplierDuplicate(currentObj, objs) || this.hasSupplierDuplicate(currentObj, dbObjs)) {
            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728%s\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f\uff0c\u8bf7\u52ff\u91cd\u590d\u7ef4\u62a4\u3002", (String)"TaxSupplierValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), supplier.get("name")));
            return false;
        }
        return true;
    }

    protected boolean hasSupplierDuplicate(DynamicObject currentObj, List<DynamicObject> objs) {
        DynamicObject obj = null;
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            obj = objs.get(i);
            if (currentObj.getLong("id") == obj.getLong("id") || currentObj.getDynamicObject("supplier") == null || obj.getDynamicObject("supplier") == null || currentObj.getDynamicObject("supplier").getLong("id") != obj.getDynamicObject("supplier").getLong("id")) continue;
            return true;
        }
        return false;
    }

    protected boolean checkGroupFieldUnique(DynamicObject currentObj, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection supplierTreaty = currentObj.getDynamicObjectCollection("entry_treaty");
        int size = supplierTreaty.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (!this.hasSameDims((DynamicObject)supplierTreaty.get(i), (DynamicObject)supplierTreaty.get(j)) || !this.hasDateDuplicate((DynamicObject)supplierTreaty.get(i), (DynamicObject)supplierTreaty.get(j))) continue;
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u9002\u7528\u7684\u7a0e\u6536\u534f\u8bae\u3002\u534f\u8bae\u540d\u79f0\uff1a%1$s\uff0c\u534f\u8bae\u6761\u6b3e\uff1a%2$s", (String)"TaxSupplierValidator_3", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), ((DynamicObject)supplierTreaty.get(i)).getDynamicObject("treatyname").get("value"), ((DynamicObject)supplierTreaty.get(i)).getDynamicObject("treatyagreement").get("value")));
                return false;
            }
        }
        return true;
    }

    protected boolean hasSameDims(DynamicObject treaty, DynamicObject nextTreaty) {
        String treatyKey = TaxSupplierBusiness.getEntryDimKey((DynamicObject)treaty);
        String nextTreatyKey = TaxSupplierBusiness.getEntryDimKey((DynamicObject)nextTreaty);
        return treatyKey.equals(nextTreatyKey);
    }

    protected boolean hasDateDuplicate(DynamicObject treaty, DynamicObject nextTreaty) {
        Date endDate;
        Date startDate;
        Date endTime;
        Date beginTime = treaty.getDate("startdate");
        Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)(endTime = treaty.getDate("enddate")), (Date)(startDate = nextTreaty.getDate("startdate")), (Date)(endDate = nextTreaty.getDate("enddate")));
        return date != null && date.length > 0;
    }
}

