/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxcalendarlist;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.util.StringUtils;
import kd.taxc.enums.TaxCycleEnum;
import kd.taxc.tctb.opplugin.taxcalendarlist.TaxCalendarRuleValidator;

public class TaxCalendarRuleOp
extends AbstractOperationServicePlugIn {
    private static final String F7_GROUP = "group";
    private static final String F7_TAXAREAGROUP = "taxareagroup";
    private static final String F7_TAXCATEGORY = "taxcategory";
    private static final String ENUM_TAXCYCLE = "taxcycle";
    private static final String MULTILANG_NAME = "name";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        this.addKeys(fieldKeys);
    }

    private void addKeys(List<String> fieldKeys) {
        fieldKeys.add(F7_GROUP);
        fieldKeys.add(F7_TAXAREAGROUP);
        fieldKeys.add(F7_TAXCATEGORY);
        fieldKeys.add(ENUM_TAXCYCLE);
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new TaxCalendarRuleValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                this.generateName(dataEntity);
            }
        }
    }

    protected void generateName(DynamicObject taxCalendarRule) {
        OrmLocaleValue nameLocalValue = (OrmLocaleValue)taxCalendarRule.get(MULTILANG_NAME);
        if (nameLocalValue != null && StringUtils.isEmpty((String)nameLocalValue.getLocaleValue())) {
            DynamicObject taxationsys = taxCalendarRule.getDynamicObject(F7_GROUP);
            DynamicObject taxareagroup = taxCalendarRule.getDynamicObject(F7_TAXAREAGROUP);
            DynamicObject taxcategory = taxCalendarRule.getDynamicObject(F7_TAXCATEGORY);
            String taxcycle = taxCalendarRule.getString(ENUM_TAXCYCLE);
            TaxCycleEnum taxCycleEnum = TaxCycleEnum.getTaxCycleEnumByCode((String)taxcycle);
            String name = String.format("%1$s_%2$s_%3$s_%4$s", taxationsys.getString(MULTILANG_NAME), taxareagroup.getString(MULTILANG_NAME), taxcategory.getString(MULTILANG_NAME), taxCycleEnum == null ? "" : taxCycleEnum.getName().loadKDString());
            nameLocalValue.setLocaleValue(name);
            taxCalendarRule.set(MULTILANG_NAME, (Object)nameLocalValue);
        }
    }
}

