/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxcalendarlist;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.enums.TaxCalendarEndDayEnum;

public class TaxCalendarRuleValidator
extends AbstractValidator {
    private static final String ENUM_SBJZRNSSDLX = "sbjzrnssdlx";
    private static final String INT_SBJZRY = "sbjzry";
    private static final String INT_SBJZRT = "sbjzrt";
    private static final String ENUM_JKJZRNSSDLX = "jkjzrnssdlx";
    private static final String INT_JKJZRY = "jkjzry";
    private static final String INT_JKJZRT = "jkjzrt";

    public void validate() {
        if ("save".equalsIgnoreCase(this.getOperateKey())) {
            this.doSaveValidators();
        } else if ("enable".equalsIgnoreCase(this.getOperateKey())) {
            this.doEnableValidators();
        }
    }

    protected void doSaveValidators() {
        DynamicObject currentObj = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            if (this.isEndDayEmpty(currentObj, ENUM_SBJZRNSSDLX, INT_SBJZRY, INT_SBJZRT) && this.isEndDayEmpty(currentObj, ENUM_JKJZRNSSDLX, INT_JKJZRY, INT_JKJZRT)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7533\u62a5\u622a\u6b62\u65e5\u671f\u201d\u6216\u201c\u7f34\u6b3e\u622a\u6b62\u65e5\u671f\u201d\u3002", (String)"TaxCalendarRuleValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            }
            if (!this.checkDateTypeBeforeAfter(currentObj)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u7eb3\u7a0e\u65f6\u70b9\u4e3a\u201c\u7ec8\u4e86\u65e5\u524d\u201d\u6216\u201c\u7ec8\u4e86\u65e5\u540e\u201d\u65f6\uff0c\u622a\u6b62\u65e5\u671f\u7684\u201c\u6708\u201d\u4e0e\u201c\u5929\u201d\u503c\u4e0d\u80fd\u540c\u65f6\u4e3a\u201c0\u201d\u3002", (String)"TaxCalendarRuleValidator_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
            }
            if (this.checkDateTypeOnTheDayOrEmpty(currentObj)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u7eb3\u7a0e\u65f6\u70b9\u4e3a\u201c\u7ec8\u4e86\u65e5\u201d\u6216\u7a7a\u65f6\uff0c\u622a\u6b62\u65e5\u671f\u7684\u201c\u6708\u201d\u4e0e\u201c\u5929\u201d\u503c\u987b\u540c\u65f6\u4e3a\u201c0\u201d\u3002", (String)"TaxCalendarRuleValidator_3", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
        }
    }

    protected boolean isEndDayEmpty(DynamicObject ruleObject, String sdlxField, String monthField, String dayField) {
        String sdlx = ruleObject.getString(sdlxField);
        return StringUtils.isEmpty((String)sdlx);
    }

    protected boolean checkDateTypeBeforeAfter(DynamicObject ruleObject) {
        return this.doCheckDateTypeBeforeAfter(ruleObject, ENUM_SBJZRNSSDLX, INT_SBJZRY, INT_SBJZRT) && this.doCheckDateTypeBeforeAfter(ruleObject, ENUM_JKJZRNSSDLX, INT_JKJZRY, INT_JKJZRT);
    }

    protected boolean doCheckDateTypeBeforeAfter(DynamicObject ruleObject, String sdlxField, String monthField, String dayField) {
        String sdlx = ruleObject.getString(sdlxField);
        if (TaxCalendarEndDayEnum.BEFOREENDDAY.getCode().equals(sdlx) || TaxCalendarEndDayEnum.AFTERENDDAY.getCode().equals(sdlx)) {
            int month = ruleObject.getInt(monthField);
            int day = ruleObject.getInt(dayField);
            if (month == 0 && day == 0) {
                return false;
            }
        }
        return true;
    }

    protected boolean checkDateTypeOnTheDayOrEmpty(DynamicObject ruleObject) {
        return this.doCheckDateTypeOnTheDayOrEmpty(ruleObject, ENUM_SBJZRNSSDLX, INT_SBJZRY, INT_SBJZRT) && this.doCheckDateTypeOnTheDayOrEmpty(ruleObject, ENUM_JKJZRNSSDLX, INT_JKJZRY, INT_JKJZRT);
    }

    protected boolean doCheckDateTypeOnTheDayOrEmpty(DynamicObject ruleObject, String sdlxField, String monthField, String dayField) {
        String sdlx = ruleObject.getString(sdlxField);
        if (TaxCalendarEndDayEnum.ENDDAY.getCode().equals(sdlx) || StringUtils.isEmpty((String)sdlx)) {
            int month = ruleObject.getInt(monthField);
            int day = ruleObject.getInt(dayField);
            if (month != 0 || day != 0) {
                return false;
            }
        }
        return true;
    }

    protected void doEnableValidators() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            QFilter[] filters;
            boolean exists;
            DynamicObject taxCalendarRule = dataEntity.getDataEntity();
            if ("1".equals(taxCalendarRule.getString("enable")) || !(exists = QueryServiceHelper.exists((String)"tctb_taxcalendar_rule", (QFilter[])(filters = new QFilter[]{new QFilter("group.id", "=", (Object)taxCalendarRule.getLong("group.id")), new QFilter("taxareagroup.id", "=", (Object)taxCalendarRule.getLong("taxareagroup.id")), new QFilter("taxcategory.id", "=", (Object)taxCalendarRule.getLong("taxcategory.id")), new QFilter("taxcycle", "=", (Object)taxCalendarRule.getString("taxcycle")), new QFilter("enable", "=", (Object)"1")})))) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u53ef\u7528\u72b6\u6001\u7684\u7a0e\u52a1\u65e5\u5386\u89c4\u5219(\u7a0e\u5236\u3001\u7a0e\u6536\u8f96\u533a\u3001\u7a0e\u79cd\u3001\u7eb3\u7a0e\u5468\u671f\u90fd\u76f8\u540c)\u3002", (String)"TaxCalendarRuleValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
        }
    }
}

