/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxlicense;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseApplyService;
import kd.taxc.tctb.opplugin.taxlicense.LicenseApplyValidator;

public class LicenseApplyOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(LicenseApplyOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("entryentity.org");
        e.getFieldKeys().add("entryentity.group");
        e.getFieldKeys().add("entryentity.applystatus");
        e.getFieldKeys().add("entryentity.licenseid");
        e.getFieldKeys().add("entryentity.unifiedsocialcode");
        e.getFieldKeys().add("entryentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new LicenseApplyValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        Optional checkLicenseEnoughOpt;
        if (("submit".equalsIgnoreCase(e.getOperationKey()) || "audit".equalsIgnoreCase(e.getOperationKey())) && (checkLicenseEnoughOpt = TaxcLicenseApplyService.checkLicenseEnough((DynamicObject[])(objs = e.getDataEntities()))).isPresent()) {
            e.setCancel(true);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setErrorLevel(ErrorLevel.Error.name());
            errorInfo.setMessage((String)checkLicenseEnoughOpt.get());
            this.getOperationResult().addErrorInfo(errorInfo);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if ("audit".equalsIgnoreCase(e.getOperationKey())) {
            DynamicObject[] objs = e.getDataEntities();
            TaxcLicenseApplyService.syncUpdateTaxLicense((DynamicObject[])objs);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if ("audit".equalsIgnoreCase(e.getOperationKey())) {
            DynamicObject[] objs = e.getDataEntities();
            TaxcLicenseApplyService.syncUpdateTaxOrg((DynamicObject[])objs);
        }
    }
}

