/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxlicense;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseApplyService;

public class LicenseApplyValidator
extends AbstractValidator {
    public void validate() {
        if ("save".equalsIgnoreCase(this.getOperateKey())) {
            this.doSaveValidators();
        } else if ("submit".equalsIgnoreCase(this.getOperateKey())) {
            this.doSubmitValidators();
        } else if ("audit".equalsIgnoreCase(this.getOperateKey())) {
            this.doAuditValidators();
        }
    }

    protected void doSaveValidators() {
        ArrayList<DynamicObject> colls = new ArrayList<DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            colls.add(dataEntity.getDataEntity());
        }
        Map onTheWayMap = TaxcLicenseApplyService.checkOnTheWay(colls);
        DynamicObject currentObj = null;
        Long id = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            id = currentObj.getLong("id");
            if (!onTheWayMap.getOrDefault(id, Optional.empty()).isPresent()) continue;
            this.addErrorMessage(dataEntity, (String)((Optional)onTheWayMap.get(id)).get());
        }
    }

    protected void doSubmitValidators() {
        ArrayList<DynamicObject> colls = new ArrayList<DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            colls.add(dataEntity.getDataEntity());
        }
        Map onTheWayMap = TaxcLicenseApplyService.checkOnTheWay(colls);
        Map unifiedsocialcodeMap = TaxcLicenseApplyService.checkUnifiedsocialcode(colls);
        DynamicObject currentObj = null;
        Long id = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            id = currentObj.getLong("id");
            if (unifiedsocialcodeMap.getOrDefault(id, Optional.empty()).isPresent()) {
                this.addErrorMessage(dataEntity, (String)((Optional)unifiedsocialcodeMap.get(id)).get());
            }
            if (!onTheWayMap.getOrDefault(id, Optional.empty()).isPresent()) continue;
            this.addErrorMessage(dataEntity, (String)((Optional)onTheWayMap.get(id)).get());
        }
    }

    protected void doAuditValidators() {
        ArrayList<DynamicObject> colls = new ArrayList<DynamicObject>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            colls.add(dataEntity.getDataEntity());
        }
        Map unifiedsocialcodeMap = TaxcLicenseApplyService.checkUnifiedsocialcode(colls);
        DynamicObject currentObj = null;
        Long id = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            currentObj = dataEntity.getDataEntity();
            id = currentObj.getLong("id");
            if (!unifiedsocialcodeMap.getOrDefault(id, Optional.empty()).isPresent()) continue;
            this.addErrorMessage(dataEntity, (String)((Optional)unifiedsocialcodeMap.get(id)).get());
        }
    }
}

