/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxplan;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctb.business.taxplan.TaxcPlanBusiness;
import kd.taxc.tctb.opplugin.taxplan.TaxPlanUniqueValidator;

public class TaxPlanSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        List<DynamicObject> alreadyExistList = Arrays.asList(TaxcPlanBusiness.loadAllAvaliable());
        e.addValidator(this.getFieldValidate(alreadyExistList));
        e.addValidator((AbstractValidator)new TaxPlanUniqueValidator(alreadyExistList, "save"));
    }

    private AbstractValidator getFieldValidate(List<DynamicObject> alreadyExist) {
        return new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntitie : this.dataEntities) {
                    DynamicObject dyn = dataEntitie.getDataEntity();
                    Date startDate = dyn.getDate("startdate");
                    Date endDate = dyn.getDate("enddate");
                    if (startDate != null && !TaxPlanSaveOp.this.sameDay(startDate, DateUtils.getFirstDateOfMonth((Date)startDate))) {
                        this.addErrorMessage(dataEntitie, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"TaxPlanSaveOp_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    }
                    if (endDate == null) continue;
                    if (!TaxPlanSaveOp.this.sameDay(endDate, DateUtils.getLastDateOfMonth((Date)endDate))) {
                        this.addErrorMessage(dataEntitie, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"TaxPlanSaveOp_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (endDate.after(startDate)) continue;
                    this.addErrorMessage(dataEntitie, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u3002", (String)"TaxPlanSaveOp_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                }
            }
        };
    }

    private boolean sameDay(Date day1, Date day2) {
        if (day1 == null || day2 == null) {
            return false;
        }
        return DateUtils.format((Date)day1).equals(DateUtils.format((Date)day2));
    }
}

