/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxplan;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.entity.validate.ValidateResultCollection;

public class TaxPlanUniqueValidator
extends AbstractValidator {
    public static final String OP_SAVE = "save";
    public static final String OP_ENABLE = "enable";
    private List<DynamicObject> alreadyEnableList;
    private String opName;

    public TaxPlanUniqueValidator(List<DynamicObject> alreadyEnableList, String opName) {
        this.alreadyEnableList = alreadyEnableList;
        this.opName = opName;
        this.setValidatePriority(ValidatePriority.Last);
    }

    public void validate() {
        this.validateAlready(this.alreadyEnableList);
        this.validateTobeCheckList();
    }

    private void validateTobeCheckList() {
        String notifyMsg = this.opName.equals(OP_ENABLE) ? ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u5f85\u542f\u7528\u6570\u636e\uff08\u7a0e\u79cd\u3001\u8ba1\u7a0e\u7ef4\u5ea6\u3001\u4e1a\u52a1\u7ef4\u5ea6\u90fd\u76f8\u540c\uff09\u3002", (String)"TaxPlanUniqueValidator_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u5f85\u4fdd\u5b58\u6570\u636e\uff08\u7a0e\u79cd\u3001\u8ba1\u7a0e\u7ef4\u5ea6\u3001\u4e1a\u52a1\u7ef4\u5ea6\u90fd\u76f8\u540c\uff09\u3002", (String)"TaxPlanUniqueValidator_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]);
        List<DynamicObject> list = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity()).collect(Collectors.toList());
        this.check(list, notifyMsg);
    }

    private void validateAlready(List<DynamicObject> list) {
        this.check(list, ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u53ef\u7528\u6570\u636e\uff08\u7a0e\u79cd\u3001\u8ba1\u7a0e\u7ef4\u5ea6\u3001\u4e1a\u52a1\u7ef4\u5ea6\u90fd\u76f8\u540c\uff09\u3002", (String)"TaxPlanUniqueValidator_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
    }

    private void check(Collection<DynamicObject> compareTaxPlans, String msg) {
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject tobeCheck = dataEntity.getDataEntity();
            String numberTobeCheck = tobeCheck.getString("number");
            for (DynamicObject compare : compareTaxPlans) {
                String numberCompare;
                if (this.getFalseDataEntities().contains(dataEntity) || this.otherValidatorsCheckdErro(dataEntity) || numberTobeCheck.equals(numberCompare = compare.getString("number")) || !this.repetision(tobeCheck, compare)) continue;
                this.addFatalErrorMessage(dataEntity, msg);
                continue block0;
            }
        }
    }

    private boolean repetision(DynamicObject dyn1, DynamicObject dyn2) {
        String taxtype1 = dyn1.getString("taxtype.id");
        String taxDimesion1 = dyn1.getString("taxdimension");
        String businessDimesion1 = dyn1.getString("businessdimesion.number");
        Date startDate1 = dyn1.getDate("startdate");
        Date endDate1 = dyn1.getDate("enddate");
        String taxtype2 = dyn2.getString("taxtype.id");
        String taxDimesion2 = dyn2.getString("taxdimension");
        String businessDimesion2 = dyn2.getString("businessdimesion.number");
        Date startDate2 = dyn2.getDate("startdate");
        Date endDate2 = dyn2.getDate("enddate");
        if (!taxtype1.equals(taxtype2)) {
            return false;
        }
        if (!this.checkTaxDemesion(taxDimesion1, taxDimesion2)) {
            return false;
        }
        if (businessDimesion1 == null ? businessDimesion2 != null : !businessDimesion1.equals(businessDimesion2)) {
            return false;
        }
        return this.timeOverlapping(startDate1, endDate1, startDate2, endDate2);
    }

    private boolean timeOverlapping(Date start1, Date end1, Date start2, Date end2) {
        if (start1 == null || start2 == null) {
            return true;
        }
        if (end1 == null) {
            if (end2 == null) {
                return true;
            }
            return !end2.before(start1);
        }
        if (end2 == null) {
            return !end1.before(start2);
        }
        if (!start1.before(start2) && !start1.after(end2)) {
            return true;
        }
        if (!end1.before(start2) && !end1.after(end2)) {
            return true;
        }
        return start1.before(start2) && end1.after(end2);
    }

    private boolean otherValidatorsCheckdErro(ExtendedDataEntity dataEntity) {
        Integer dataIndex;
        ValidateResultCollection results = this.validateContext.getValidateResults();
        HashSet errIndex = results.getErrorDataIndexs();
        return errIndex.contains(dataIndex = Integer.valueOf(dataEntity.getDataEntityIndex()));
    }

    private boolean checkTaxDemesion(String taxDimesion1, String taxDimesion2) {
        return taxDimesion1.contains("1") == taxDimesion2.contains("1") && taxDimesion1.contains("2") == taxDimesion2.contains("2");
    }

    public Set<String> preparePropertys() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("number");
        set.add("name");
        set.add("taxtype");
        set.add("taxdimension");
        set.add("businessdimesion");
        set.add("startdate");
        set.add("enddate");
        return set;
    }
}

