/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.opplugin.taxyear;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tctb.business.taxcyear.TaxcYearBusiness;

public class TaxYearUniqueValidator
extends AbstractValidator {
    private static final String SYFW_QJ = "1";
    private static final String SYFW_JB = "2";
    private Map<Long, DynamicObject> taxyearFromDb = new HashMap<Long, DynamicObject>(8);

    public Map<Long, DynamicObject> getTaxyearFromDb(ExtendedDataEntity[] dataentitys) {
        return Collections.EMPTY_MAP;
    }

    public void validate() {
        Map<Long, DynamicObject> helperData = this.getTaxyearFromDb(this.dataEntities);
        if (helperData != null) {
            this.taxyearFromDb.putAll(helperData);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject[] result;
            Long billTaxyearId = (Long)this.getByDataEntity(dataEntity, "id");
            Long billTaxationsysId = (Long)this.getByDataEntity(dataEntity, "group.id");
            String billApplicationscope = (String)this.getByDataEntity(dataEntity, "applicationscope");
            Long billTaxcategoryId = (Long)this.getByDataEntity(dataEntity, "taxcategory.id");
            if (billTaxcategoryId == null) {
                billTaxcategoryId = 0L;
            }
            if (SYFW_JB.equalsIgnoreCase(billApplicationscope)) {
                DynamicObject[] result2;
                DynamicObjectCollection billOrgCollection = (DynamicObjectCollection)this.getByDataEntity(dataEntity, "orgentryentity");
                if (ObjectUtils.isEmpty((Object)billOrgCollection)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u81f3\u5c11\u5f55\u5165\u4e00\u884c\u6570\u636e\uff0c\u8bf7\u8865\u5145\u3002", (String)"TaxYearSaveOp_0", (String)"taxc-tctb-opplugin", (Object[])new Object[0]));
                    continue;
                }
                HashSet<Long> billOrgIds = new HashSet<Long>(8);
                for (DynamicObject billOrg : billOrgCollection) {
                    billOrgIds.add(billOrg.getLong("org.id"));
                }
                for (DynamicObject taxyearDyn : result2 = TaxcYearBusiness.loadTaxcYearBytaxationsysId((Long)billTaxationsysId, (Long)billTaxcategoryId, (String)billApplicationscope)) {
                    if (billTaxyearId.longValue() == taxyearDyn.getLong("id")) continue;
                    String taxyearNumber = taxyearDyn.getString("number");
                    DynamicObjectCollection orgDyns = taxyearDyn.getDynamicObjectCollection("orgentryentity");
                    for (DynamicObject orgDyn : orgDyns) {
                        Long orgId = orgDyn.getLong("org.id");
                        String orgName = orgDyn.getString("org.name");
                        String orgNumber = orgDyn.getString("org.number");
                        if (!billOrgIds.contains(orgId)) continue;
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0e\u540c\u4e00\u7a0e\u5236\u7a0e\u79cd\u4e0b\u53e6\u4e00\u5df2\u542f\u7528\u7684\u5c40\u90e8\u9002\u7528\u6570\u636e\uff1a%1$s\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u5b58\u5728\u4ea4\u96c6\uff1a%2$s\uff1a%3$s\u3002", (String)"TaxYearSaveOp_1", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), taxyearNumber, orgNumber, orgName));
                    }
                }
                continue;
            }
            if (!SYFW_QJ.equalsIgnoreCase(billApplicationscope)) continue;
            for (DynamicObject taxyearDyn : result = TaxcYearBusiness.loadTaxcYearBytaxationsysId((Long)billTaxationsysId, (Long)billTaxcategoryId, (String)billApplicationscope)) {
                if (billTaxyearId.longValue() == taxyearDyn.getLong("id")) continue;
                String taxyearNumber = taxyearDyn.getString("number");
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u540c\u4e00\u7a0e\u5236\u7a0e\u79cd\u4e0b\u5df2\u542f\u7528\u5168\u5c40\u9002\u7528\u5171\u4eab\u7684\u6570\u636e\uff1a%1$s\u3002", (String)"TaxYearSaveOp_2", (String)"taxc-tctb-opplugin", (Object[])new Object[0]), taxyearNumber));
            }
        }
    }

    private Object getByDataEntity(ExtendedDataEntity dataentity, String key) {
        String realKey = key;
        String[] keys = key.split("\\.");
        if (keys.length > 1) {
            realKey = keys[0];
        }
        if (dataentity.getDataEntity().containsProperty(realKey)) {
            return dataentity.getDataEntity().get(key);
        }
        Long id = dataentity.getDataEntity().getLong("id");
        DynamicObject taxyear = this.taxyearFromDb.get(id);
        if (taxyear != null) {
            return taxyear.get(key);
        }
        return null;
    }
}

