/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.servicehelper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ServiceFactory {
    private static Log logger = LogFactory.getLog(ServiceFactory.class);
    private static Map<String, String> serviceMap = new ConcurrentHashMap<String, String>();

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            String appName = Instance.getAppName();
            String clusterName = Instance.getClusterName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s: %3$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"taxc-tctb-servicehelper", (Object[])new Object[0]), serviceName, clusterName, appName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("TaxInfoUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxInfoUpgradeService");
        serviceMap.put("OrgViewUpgradeService", "kd.taxc.tctb.mservice.upgrade.OrgViewUpgradeService");
        serviceMap.put("NsrxxUpgradeService", "kd.taxc.tctb.mservice.upgrade.NsrxxUpgradeService");
        serviceMap.put("DataSourcePeekRuleUpgradeService", "kd.taxc.tctb.mservice.upgrade.DataSourcePeekRuleUpgradeService");
        serviceMap.put("TaxMainInfoOrgAttrUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxMainInfoOrgAttrUpgradeService");
        serviceMap.put("TaxinfoMainUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxinfoMainUpgradeService");
        serviceMap.put("TaxinfoIncInfoUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxinfoIncInfoUpgradeService");
        serviceMap.put("TaxinfoUniCodeUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxinfoUniCodeUpgradeService");
        serviceMap.put("TaxInfoIsEntityUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxInfoIsEntityUpgradeService");
        serviceMap.put("TaxinfoTaxOfficeUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxinfoTaxOfficeUpgradeService");
        serviceMap.put("TaxOfficeUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxOfficeUpgradeService");
        serviceMap.put("EleAutoUpdate", "kd.taxc.tctb.common.threadpools.ElementThreadTaskService");
        serviceMap.put("OrgTakeRelationUpgradeService", "kd.taxc.tctb.mservice.upgrade.OrgTakeRelationUpgradeService");
        serviceMap.put("DraftMainUpgradeService", "kd.taxc.tctb.mservice.upgrade.DraftMainUpgradeService");
        serviceMap.put("TcvatDraftMainUpgradeService", "kd.taxc.tctb.mservice.upgrade.TcvatDraftMainUpgradeService");
        serviceMap.put("TaxCategoryUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxCategoryUpgradeService");
        serviceMap.put("LicenseCheckService", "kd.taxc.tctb.mservice.license.LicenseCheckServiceImpl");
        serviceMap.put("OrgChangeRecordService", "kd.taxc.tctb.mservice.org.OrgChangeRecordServiceImpl");
        serviceMap.put("TaxOrgTakeRelationService", "kd.taxc.tctb.mservice.org.TaxOrgTakeRelationServiceImpl");
        serviceMap.put("RegisterAddressService", "kd.taxc.tctb.mservice.register.RegisterAddressServiceImpl");
        serviceMap.put("OrgCheckService", "kd.taxc.tctb.mservice.org.OrgCheckServiceImpl");
        serviceMap.put("OrgService", "kd.taxc.tctb.mservice.org.OrgServiceImpl");
        serviceMap.put("YhsEntityUpgradeService", "kd.taxc.tctb.mservice.upgrade.YhsEntityUpgradeService");
        serviceMap.put("TaxOrgMappingService", "kd.taxc.tctb.mservice.org.TaxOrgMappingServiceImpl");
        serviceMap.put("TaskMonistorService", "kd.taxc.tctb.mservice.taskmonistor.TaskMonistorServiceImpl");
        serviceMap.put("TaxtypeCardService", "kd.taxc.tctb.mservice.taxinfo.TaxtypeCardServiceImpl");
        serviceMap.put("CalcReceiverService", "kd.taxc.tctb.mservice.message.CalcReceiverService");
        serviceMap.put("ProvistonPlanService", "kd.taxc.tctb.mservice.provision.ProvistonPlanServiceImpl");
        serviceMap.put("TaxcMainMService", "kd.taxc.tctb.mservice.taxcmain.TaxcMainMServiceImpl");
        serviceMap.put("TaxprovisionService", "kd.taxc.tctb.mservice.provision.TaxprovisionServiceImpl");
        serviceMap.put("TaxProvisionUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxProvisionUpgradeServiceImpl");
        serviceMap.put("TaxcLicenseCheckMService", "kd.taxc.tctb.mservice.license.TaxcLicenseCheckMServiceImpl");
        serviceMap.put("FarmDeductUpgradeMService", "kd.taxc.tctb.mservice.upgrade.FarmDeductUpgradeMServiceImpl");
        serviceMap.put("TaxcYearMService", "kd.taxc.tctb.mservice.taxcyear.TaxcYearMServiceImpl");
        serviceMap.put("TaxcOrgGroupMService", "kd.taxc.tctb.mservice.taxcorggroup.TaxcOrgGroupMServiceImpl");
        serviceMap.put("OrgMapRelationUpgradeMService", "kd.taxc.tctb.mservice.upgrade.OrgMapRelationUpgradeMServiceImpl");
        serviceMap.put("TaxcTaskMonitorMService", "kd.taxc.tctb.mservice.taskmonitor.TaxcTaskMonitorMServiceImpl");
        serviceMap.put("ProvisionPlanMService", "kd.taxc.tctb.mservice.provision.ProvisionPlanMServiceImpl");
        serviceMap.put("ProvisionSharePlanMService", "kd.taxc.tctb.mservice.provision.ProvisionSharePlanMServiceImpl");
        serviceMap.put("TaxcSjfbTctbService", "kd.taxc.tctb.mservice.sjfb.TaxcSjfbServiceImpl");
        serviceMap.put("PackAuditTaskMService", "kd.taxc.tctb.mservice.packaudit.PackAuditTaskMServiceImpl");
        serviceMap.put("TaxcParamApplyService", "kd.taxc.tctb.mservice.param.TaxcParamApplyServiceImpl");
        serviceMap.put("TaxSupplierMService", "kd.taxc.tctb.mservice.taxsupplier.TaxSupplierMServiceImpl");
        serviceMap.put("DataSourceEntryBizsubNameUpgradeService", "kd.taxc.tctb.mservice.upgrade.DataSourceEntryBizsubNameUpgradeService");
        serviceMap.put("ProvisionRuleMService", "kd.taxc.tctb.mservice.provision.ProvisionRuleMServiceImpl");
        serviceMap.put("ProvisionRuleSharePlanUpgrade4ZzsMService", "kd.taxc.tctb.mservice.upgrade.ProvisionRuleSharePlanUpgrade4ZzsMServiceImpl");
        serviceMap.put("TaxcMainCreditMService", "kd.taxc.tctb.mservice.taxcmain.TaxcMainCreditMserviceImpl");
        serviceMap.put("TaxInfo2CategoryEntryUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxInfo2CategoryEntryUpgradeService");
        serviceMap.put("TaxcTaxPlanMService", "kd.taxc.tctb.mservice.taxplan.TaxPlanMServiceImpl");
        serviceMap.put("TcvatIncomeRuleDataSourceUpgradeService", "kd.taxc.tctb.upgradeservice.TcvatIncomeRuleDataSourceUpgradeService");
        serviceMap.put("TaxMainTaxOrgEntryFieldUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxMainTaxOrgEntryFieldUpgradeService");
        serviceMap.put("TaxMainPermItemUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxMainPermItemUpgradeService");
        serviceMap.put("TaxMainResidenttypeFieldUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxMainResidenttypeFieldUpgradeService");
        serviceMap.put("TaxPlanUpgradeMService", "kd.taxc.tctb.mservice.upgrade.TaxPlanUpgradeMServiceImpl");
        serviceMap.put("TaxPlanPermItemUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxPlanPermItemUpgradeService");
        serviceMap.put("TaxCalendarListMService", "kd.taxc.tctb.mservice.taxcalendarlist.TaxCalendarListMServiceImpl");
        serviceMap.put("TaxPlanImportPermItemUpgradeService", "kd.taxc.tctb.mservice.upgrade.TaxPlanImportPermItemUpgradeService");
    }
}

