/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.license;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.constant.LicenseCheckConstant;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.license.LicenseDataSyn;
import kd.taxc.license.LicenseGroupUtil;
import kd.taxc.tctb.mservice.abstractService.AbstractService;
import kd.taxc.tctb.mservice.api.license.LicenseCheckService;
import org.apache.commons.lang3.ObjectUtils;

public class LicenseCheckServiceImpl
extends AbstractService
implements LicenseCheckService {
    private static final String STATUS_A = "A";
    private static final String STATUS_B = "B";
    private static final String STATUS_C = "C";

    private static String getMsgA() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u6fc0\u6d3b\u201c%s\u201d\u7ec4\u7ec7\u7684\u8bb8\u53ef\u3002", (String)"LicenseCheckServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
    }

    private static String getMsgB() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u8bb8\u53ef\u5df2\u6ce8\u9500\uff0c\u4e0d\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)"LicenseCheckServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
    }

    private static String getMsgC() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6388\u6743\u7684\u4e0d\u4e00\u81f4\u3002", (String)"LicenseCheckServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
    }

    private static String getMsgD() {
        return ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u8be5\u7ec4\u7ec7\u4e0d\u662f\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"LicenseCheckServiceImpl_3", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
    }

    public String checkTxftPerformGroup(String appid) {
        LicenseCheckResult licenseCheckResult = null;
        licenseCheckResult = StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)"tcdrs") ? ("4.0".equals(LicenseGroupUtil.getVersion()) || "5.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkTxftPerformGroup() : new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u8ba1\u63d0\u5e95\u7a3f\u670d\u52a1\u7279\u6027\u8bb8\u53ef", (String)"LicenseCheckServiceImpl_4", (String)"taxc-tctb-mservice", (Object[])new Object[0]))) : (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)"tsdcs") ? ("5.0".equals(LicenseGroupUtil.getVersion()) ? LicenseGroupUtil.checkTxcdPerformGroup() : new LicenseCheckResult(Boolean.FALSE, ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u7a0e\u4f01\u76f4\u8fde\u7279\u6027\u8bb8\u53ef", (String)"LicenseCheckServiceImpl_5", (String)"taxc-tctb-mservice", (Object[])new Object[0]))) : LicenseGroupUtil.checkTAXBPerformGroup((String)appid));
        return SerializationUtils.toJsonString((Object)licenseCheckResult);
    }

    public List<Long> getOrgByAppId(String appid, String licensestatus) {
        QFilter qFilter = new QFilter("licensestatus", "=", (Object)licensestatus);
        QFilter groupQf = null;
        String group = "";
        if (LicenseGroupUtil.getVersion().startsWith("5")) {
            group = LicenseCheckConstant.getV5LicenseByAppid((String)appid);
        } else if (LicenseGroupUtil.getVersion().startsWith("4")) {
            group = LicenseCheckConstant.getV4LicenseByAppid((String)appid);
        }
        if (LicenseGroupUtil.getVersion().startsWith("3")) {
            group = LicenseCheckConstant.getV3LicenseByAppid((String)appid);
        }
        if (!"".equals(group)) {
            groupQf = new QFilter("group", "=", (Object)Long.valueOf(group));
        }
        List<Long> orgids = new ArrayList<Long>();
        if (null != groupQf) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_license_from", (String)"orgid", (QFilter[])new QFilter[]{qFilter, groupQf});
            orgids = dynamicObjects.stream().map(v -> v.getLong("orgid")).collect(Collectors.toList());
        }
        return orgids;
    }

    public Map<String, String> check(Object orgid, String appid) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (LicenseGroupUtil.getVersion().startsWith("4")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)"tcdrs")) {
                return this.result(resultMap, "false", "");
            }
            return this.check4(orgid, resultMap, appid, "4.0");
        }
        if (LicenseGroupUtil.getVersion().startsWith("5")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)"tcdrs")) {
                return this.result(resultMap, "false", "");
            }
            return this.check5(orgid, resultMap, appid, "5.0");
        }
        return this.check3(orgid, resultMap, appid, "3.0");
    }

    public Map<Long, Boolean> checkBatch(List<Long> orgids, String appid) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        if (ObjectUtils.isEmpty(orgids)) {
            return map;
        }
        List partition = Lists.partition(orgids, (int)500);
        partition.forEach(org -> map.putAll(this.checkLicenseBatch((List<Long>)org, appid)));
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<Long, Boolean> checkLicenseBatch(List<Long> orgids, String appid) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (LicenseGroupUtil.getVersion().startsWith("4")) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)"tcdrs")) return this.checkBatch(orgids, appid, "4.0");
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
            return resultMap;
        } else {
            if (!LicenseGroupUtil.getVersion().startsWith("5")) return this.checkBatch(orgids, appid, "3.0");
            if (!StringUtils.equalsIgnoreCase((CharSequence)appid, (CharSequence)"tcdrs")) return this.checkBatch(orgids, appid, "5.0");
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
        }
        return resultMap;
    }

    private Map<Long, Boolean> checkBatch(List<Long> orgids, String appid, String version) {
        Map<Object, Object> resultMap = new HashMap();
        resultMap = StringUtils.equals((CharSequence)"4.0", (CharSequence)version) ? this.check4Batch(orgids, appid, version) : (StringUtils.equals((CharSequence)"5.0", (CharSequence)version) ? this.check5Batch(orgids, appid, version) : this.check3Batch(orgids, appid, "3.0"));
        return resultMap;
    }

    private Map<String, String> check3(Object orgid, Map<String, String> resultMap, String appid, String ver) {
        resultMap.put("code", "false");
        resultMap.put("failInfo", "");
        if (null == appid || "".equals(appid)) {
            return resultMap;
        }
        String group = LicenseCheckConstant.getV3LicenseByAppid((String)appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup((String)appid);
            if (!result.getHasLicense().booleanValue()) {
                return this.result(resultMap, "true", result.getMsg());
            }
            return this.check(orgid, resultMap, group, true, ver);
        }
        return resultMap;
    }

    private Map<Long, Boolean> check3Batch(List<Long> orgids, String appid, String ver) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (null == appid || "".equals(appid)) {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
            return resultMap;
        }
        String group = LicenseCheckConstant.getV3LicenseByAppid((String)appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup((String)appid);
            if (!result.getHasLicense().booleanValue()) {
                orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                return resultMap;
            }
            return this.checkLicenseBatch(orgids, group, true, ver);
        }
        return resultMap;
    }

    private Map<String, String> check5(Object orgid, Map<String, String> resultMap, String appid, String ver) {
        resultMap.put("code", "false");
        resultMap.put("failInfo", "");
        if (null == appid || "".equals(appid)) {
            return resultMap;
        }
        String group = LicenseCheckConstant.getV5LicenseByAppid((String)appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup((String)appid);
            if (!result.getHasLicense().booleanValue()) {
                return this.result(resultMap, "true", result.getMsg());
            }
            this.syncData(ver, group);
            return this.check(orgid, resultMap, group, true, ver);
        }
        return resultMap;
    }

    private Map<Long, Boolean> check5Batch(List<Long> orgids, String appid, String ver) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (null == appid || "".equals(appid)) {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
            return resultMap;
        }
        String group = LicenseCheckConstant.getV5LicenseByAppid((String)appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup((String)appid);
            if (!result.getHasLicense().booleanValue()) {
                orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                return resultMap;
            }
            this.syncData(ver, group);
            return this.checkLicenseBatch(orgids, group, true, ver);
        }
        return resultMap;
    }

    private void syncData(String ver, String group) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(group)), new QFilter("ver", "=", (Object)ver)});
        if (doc.isEmpty()) {
            DynamicObjectCollection doc1 = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,unifiedsocialcode", null);
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
            for (DynamicObject d : doc1) {
                map.put(d.getString("id"), d);
            }
            DynamicObjectCollection tctb = QueryServiceHelper.query((String)"tctb_license", (String)"orgfield,licensestatus,activeuserid,canceluserid,activedate,canceldate", (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"1")});
            DynamicObjectCollection dos = TreeUtils.getOrgLists();
            LicenseDataSyn.sysData((Object)group, map, (DynamicObjectCollection)tctb, (DynamicObjectCollection)dos);
        }
    }

    private Map<String, String> check4(Object orgid, Map<String, String> resultMap, String appid, String ver) {
        resultMap.put("code", "false");
        resultMap.put("failInfo", "");
        if (null == appid || "".equals(appid)) {
            return resultMap;
        }
        String group = LicenseCheckConstant.getV4LicenseByAppid((String)appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup((String)appid);
            if (!result.getHasLicense().booleanValue()) {
                return this.result(resultMap, "true", result.getMsg());
            }
            this.syncData(ver, group);
            return this.check(orgid, resultMap, group, true, ver);
        }
        return resultMap;
    }

    private Map<Long, Boolean> check4Batch(List<Long> orgids, String appid, String ver) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (null == appid || "".equals(appid)) {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
            return resultMap;
        }
        String group = LicenseCheckConstant.getV4LicenseByAppid((String)appid);
        if (!"".equals(group)) {
            LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup((String)appid);
            if (!result.getHasLicense().booleanValue()) {
                orgids.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
                return resultMap;
            }
            this.syncData(ver, group);
            return this.checkLicenseBatch(orgids, group, true, ver);
        }
        return resultMap;
    }

    private Map<String, String> result(Map<String, String> resultMap, String code, String failInfo) {
        return this.result(resultMap, code, failInfo, null);
    }

    private Map<String, String> result(Map<String, String> resultMap, String code, String failInfo, String status) {
        resultMap.put("code", code);
        resultMap.put("failInfo", failInfo);
        if (kd.bos.util.StringUtils.isNotEmpty((String)status)) {
            resultMap.put("status", status);
        } else {
            resultMap.put("status", "");
        }
        return resultMap;
    }

    private Map<String, String> check(Object orgid, Map<String, String> resultMap, String taxb, boolean isCheck, String ver) {
        if (isCheck) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgid.toString())), new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("ver", "=", (Object)ver)});
            if (doc.size() > 0) {
                if (((DynamicObject)doc.get(0)).getString("licensestatus").equals(STATUS_A)) {
                    return this.result(resultMap, "true", String.format(LicenseCheckServiceImpl.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), STATUS_A);
                }
                if (((DynamicObject)doc.get(0)).getString("licensestatus").equals(STATUS_C)) {
                    return this.result(resultMap, "true", String.format(LicenseCheckServiceImpl.getMsgB(), ((DynamicObject)doc.get(0)).getString("orgid.name")), STATUS_C);
                }
                if (((DynamicObject)doc.get(0)).getString("licensestatus").equals(STATUS_B)) {
                    DynamicObjectCollection unifiedsocialcode = QueryServiceHelper.query((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()))});
                    if (unifiedsocialcode.size() > 0) {
                        DynamicObjectCollection org = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode,orgid,licensestatus,group,password", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("orgid", "=", (Object)Long.parseLong(orgid.toString())), new QFilter("unifiedsocialcode", "=", ((DynamicObject)unifiedsocialcode.get(0)).get("unifiedsocialcode"))});
                        if (org.size() > 0) {
                            return this.result(resultMap, "false", "");
                        }
                        return this.result(resultMap, "true", String.format(LicenseCheckServiceImpl.getMsgC(), ((DynamicObject)doc.get(0)).getString("orgid.name")), STATUS_B);
                    }
                    return this.result(resultMap, "true", String.format(LicenseCheckServiceImpl.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), STATUS_B);
                }
                String status = ((DynamicObject)doc.get(0)).getString("licensestatus");
                return this.result(resultMap, "true", String.format(LicenseCheckServiceImpl.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), status);
            }
            DynamicObjectCollection dcs = TreeUtils.getOrgLists();
            DynamicObject orgId = null;
            for (DynamicObject temp : dcs) {
                if (temp.getLong("id") != Long.parseLong(orgid.toString())) continue;
                orgId = temp;
                break;
            }
            if (null != orgId) {
                return this.result(resultMap, "true", String.format(LicenseCheckServiceImpl.getMsgA(), orgId.get("name")));
            }
            return this.result(resultMap, "true", LicenseCheckServiceImpl.getMsgD());
        }
        return this.result(resultMap, "false", "");
    }

    private Map<Long, Boolean> checkLicenseBatch(List<Long> orgids, String taxb, boolean isCheck, String ver) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        if (isCheck) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("orgid", "in", orgids), new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("ver", "=", (Object)ver)});
            if (doc.size() > 0) {
                Map<Long, String> collect = doc.stream().collect(Collectors.toMap(k -> k.getLong("orgid"), v -> v.getString("licensestatus"), (k1, k2) -> k1));
                DynamicObjectCollection unifiedsocialcode = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "in", orgids)});
                if (EmptyCheckUtils.isEmpty((Object)unifiedsocialcode)) {
                    orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
                } else {
                    Map<Long, String> mappingOrgLicense = unifiedsocialcode.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("unifiedsocialcode"), (k1, k2) -> k1));
                    List list = unifiedsocialcode.stream().map(e -> e.getString("unifiedsocialcode")).collect(Collectors.toList());
                    if (EmptyCheckUtils.isEmpty(list)) {
                        orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
                    } else {
                        DynamicObjectCollection license = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode,orgid,licensestatus,group,password", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("orgid", "in", orgids), new QFilter("unifiedsocialcode", "in", list)});
                        if (EmptyCheckUtils.isEmpty((Object)license)) {
                            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
                        } else {
                            Map<Long, String> mappingLicenseOrg = license.stream().collect(Collectors.toMap(k -> k.getLong("orgid"), v -> v.getString("unifiedsocialcode"), (k1, k2) -> k1));
                            collect.forEach((key, licenseStatus) -> {
                                if (StringUtils.equals((CharSequence)STATUS_A, (CharSequence)licenseStatus) || StringUtils.equals((CharSequence)STATUS_C, (CharSequence)licenseStatus)) {
                                    resultMap.put((Long)key, Boolean.TRUE);
                                } else if (StringUtils.equals((CharSequence)STATUS_B, (CharSequence)licenseStatus)) {
                                    String licenseOrgTaxNo;
                                    String orgLicenseTaxNo = (String)mappingOrgLicense.get(key);
                                    if (!StringUtils.equals((CharSequence)orgLicenseTaxNo, (CharSequence)(licenseOrgTaxNo = (String)mappingLicenseOrg.get(key)))) {
                                        resultMap.put((Long)key, Boolean.TRUE);
                                    } else {
                                        resultMap.put((Long)key, Boolean.FALSE);
                                    }
                                } else {
                                    resultMap.put((Long)key, Boolean.TRUE);
                                }
                            });
                        }
                    }
                }
            } else {
                DynamicObjectCollection dcs = TreeUtils.getOrgLists();
                List<Long> orgList = dcs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                orgList.retainAll(orgids);
                orgList.forEach(v -> resultMap.put((Long)v, Boolean.TRUE));
            }
        } else {
            orgids.forEach(v -> resultMap.put((Long)v, Boolean.FALSE));
        }
        return resultMap;
    }
}

