/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.license;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseBusiness;
import kd.taxc.tctb.mservice.api.license.TaxcLicenseCheckMService;

public class TaxcLicenseCheckMServiceImpl
implements TaxcLicenseCheckMService {
    public Map<String, Object> check(Long orgId, String appId) {
        Map result = null;
        try {
            if (null == orgId) {
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_ORG_ID_IS_NULL_CODE.getCode(), TaxcErrorCode.TAXC_ORG_ID_IS_NULL_CODE.getMessage()), new Object[0]);
            }
            if (null == appId) {
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getCode(), TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getMessage()), new Object[0]);
            }
            result = TaxcLicenseBusiness.check((Object)orgId, (String)appId);
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (Object)result);
        }
        return result;
    }

    public Map<String, Object> checkBatch(List<Long> orgIds, String appId) {
        Map result = null;
        try {
            if (CollectionUtils.isEmpty(orgIds)) {
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_ORG_ID_IS_NULL_CODE.getCode(), TaxcErrorCode.TAXC_ORG_ID_IS_NULL_CODE.getMessage()), new Object[0]);
            }
            if (null == appId) {
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getCode(), TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getMessage()), new Object[0]);
            }
            result = TaxcLicenseBusiness.checkBatch(orgIds, (String)appId);
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (Object)result);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    public Map<String, Object> getOrgByAppId(String appId, String licensestatus) {
        List result = null;
        try {
            if (null == appId) {
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getCode(), TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getMessage()), new Object[0]);
            }
            result = TaxcLicenseBusiness.getOrgByAppId((String)appId, (String)licensestatus);
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (Object)result);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    public Map<String, Object> checkTxftPerformGroup(String appId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (null == appId) {
                throw new KDBizException(new ErrorCode(TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getCode(), TaxcErrorCode.TAXC_APP_ID_IS_NULL_CODE.getMessage()), new Object[0]);
            }
            LicenseCheckResult result = TaxcLicenseBusiness.checkTxftPerformGroup((String)appId);
            map.put("groupIDs", result.getGroupIDs());
            map.put("hasLicense", result.getHasLicense());
            map.put("msg", result.getMsg());
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), map);
        }
        return ServiceResultUtils.returnResultHandler(map);
    }

    public Map<String, Object> getTaxcLicenseInfo() {
        HashMap map = new HashMap();
        try {
            map.putAll(TaxcLicenseBusiness.getTaxcLicenseInfo());
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), map);
        }
        return ServiceResultUtils.returnResultHandler(map);
    }
}

