/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.message;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.message.IMessageFilterDataSource;
import kd.taxc.tctb.business.message.MessageFilterDataSourceFactory;
import kd.taxc.tctb.business.message.RemindTaskCacheUtil;

public class EventMessageService {
    private static final Log logger = LogFactory.getLog(EventMessageService.class);

    public void PushMessageToEventCenter(DynamicObject task) {
        long taskId = task.getLong("id");
        String remindType = task.getString("remindtype");
        String eventNumber = Optional.ofNullable(task.getDynamicObject("subscribe")).map(s -> s.getDynamicObject("event")).map(s -> s.getString("number")).orElseGet(() -> null);
        if (StringUtil.isBlank((CharSequence)eventNumber)) {
            logger.error("event number is empty!");
            return;
        }
        IMessageFilterDataSource messageDataSourceHandler = MessageFilterDataSourceFactory.createHandler((String)remindType);
        Map dataSource = messageDataSourceHandler.filterDataSource(task);
        List orgRange = task.getDynamicObjectCollection("orgrangeentryentity").stream().filter(s -> s.getDynamicObject("org") != null).map(s -> s.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        dataSource.entrySet().stream().filter(s -> orgRange.contains(s.getKey())).forEach(s -> {
            Long orgId = (Long)s.getKey();
            Map values = (Map)s.getValue();
            List lists = messageDataSourceHandler.buildRemindTaskDto(orgId, task, values);
            for (Object dto : lists) {
                if (this.isStopExcute(taskId)) continue;
                EventServiceHelper.triggerEventSubscribe((String)eventNumber, (String)SerializationUtils.toJsonString(EventMessageService.beanToMap(dto), (boolean)true));
            }
        });
    }

    private boolean isStopExcute(Long taskId) {
        return "stop".equals(RemindTaskCacheUtil.getSchemaFlag((long)taskId));
    }

    public static Map<String, Object> beanToMap(Object object) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Class<?> currentClass = object.getClass();
        EventMessageService.InvokeField(object, map, currentClass);
        if (currentClass.getGenericSuperclass() != null) {
            Class<?> superclass = currentClass.getSuperclass();
            EventMessageService.InvokeField(object, map, superclass);
        }
        return map;
    }

    public static void InvokeField(Object object, Map<String, Object> map, Class<?> currentClass) {
        AccessibleObject[] fields = currentClass.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            try {
                map.put(((Field)field).getName(), ((Field)field).get(object));
            }
            catch (IllegalAccessException e) {
                logger.error("=======IllegalAccessException=========" + e.getMessage());
            }
        }
    }
}

