/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.org;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.org.OrgCheckUtil;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.license.LicenseTaxEnum;
import kd.taxc.tctb.mservice.abstractService.AbstractService;
import kd.taxc.tctb.mservice.api.org.OrgCheckService;
import kd.taxc.tctb.mservice.license.LicenseCheckServiceImpl;
import kd.taxc.tctb.mservice.org.OrgServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class OrgCheckServiceImpl
extends AbstractService
implements OrgCheckService {
    public boolean checkRelation(Long accountOrg, Date startDate, Date endDate) {
        return OrgCheckUtil.checkRelation((Long)accountOrg, (Date)startDate, null);
    }

    public Map<String, String> orgEnable(Long orgId, boolean needErrorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "false");
        map.put("failInfo", "");
        if (ObjectUtils.isNotEmpty((Object)orgId) && orgId != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            List orgIdList = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList(orgId), (String)"40");
            if (ObjectUtils.isEmpty((Object)orgIdList)) {
                map.put("code", "true");
                map.put("failInfo", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u4e0d\u662f\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]), org.getString("name")));
                return map;
            }
            String status = OrgUtils.getOrgStatusById((String)String.valueOf(orgId));
            if (StringUtil.isBlank((CharSequence)status)) {
                map.put("code", "true");
                map.put("failInfo", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u672a\u540c\u6b65\u5230\u7a0e\u52a1\u4e91\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"OrgCheckServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]), org.getString("name")));
                return map;
            }
            if (!"1".equals(status) && needErrorMsg) {
                map.put("code", "true");
                map.put("failInfo", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), org.getString("name")));
                return map;
            }
        }
        return map;
    }

    public Map<Long, Boolean> orgEnableBatch(List<Long> orgIds) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        if (ObjectUtils.isEmpty(orgIds)) {
            return map;
        }
        List partition = Lists.partition(orgIds, (int)500);
        partition.forEach(org -> map.putAll(this.getBatchMap((List<Long>)org)));
        return map;
    }

    private Map<Long, Boolean> getBatchMap(List<Long> orgIds) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        collection.stream().forEach(row -> {
            Long orgid = row.getLong("id");
            String status = row.getString("status");
            map.put(orgid, StringUtil.equalsIgnoreCase((CharSequence)status, (CharSequence)"1") ? Boolean.FALSE : Boolean.TRUE);
        });
        orgIds.stream().forEach(orgid -> {
            if (!map.containsKey(orgid)) {
                map.put((Long)orgid, Boolean.TRUE);
            }
        });
        return map;
    }

    public Map<String, String> isTaxPayerAuth(String orgId, String entityName, boolean needErrorMsg) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("code", "false");
        map.put("failInfo", "");
        DynamicObjectCollection orgs = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgId));
        boolean contains = OrgUtils.MUST_IS_TAXPAYER.contains(entityName);
        if (contains) {
            OrgServiceImpl orgService = new OrgServiceImpl();
            map = orgService.validationTaxOrgMustInput(((DynamicObject)orgs.get(0)).getLong("id"), ((DynamicObject)orgs.get(0)).getString("name"), needErrorMsg);
        }
        return map;
    }

    public boolean licenseCheckByAppid(String orgId, String appid) {
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid((String)appid);
        if (null == taxEnum) {
            return true;
        }
        LicenseCheckServiceImpl licenseCheckService = new LicenseCheckServiceImpl();
        Map<String, String> licenseMap = licenseCheckService.check(orgId, taxEnum.getAppid());
        if (StringUtil.equalsIgnoreCase((CharSequence)licenseMap.get("code"), (CharSequence)"true")) {
            return false;
        }
        Map<String, String> enableMap = this.orgEnable(Long.valueOf(orgId), false);
        if (StringUtil.equalsIgnoreCase((CharSequence)enableMap.get("code"), (CharSequence)"true")) {
            return false;
        }
        if (null != taxEnum.getCategoryCode()) {
            QFilter qFilter = null;
            if (!LicenseTaxEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)taxEnum.getCategoryCode());
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.name,maincompany,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public Map<String, Object> setDefaultOrg(Long orgid, List<Long> orgList) {
        QFilter orgFilter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgid", null);
        map.put("failInfo", null);
        if (ObjectUtils.isNotEmpty(orgList) && orgList.contains(orgid) && QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter = new QFilter("org", "=", (Object)orgid)})) {
            map.put("orgid", orgid);
            return map;
        }
        if (ObjectUtils.isEmpty(orgList)) {
            map.put("failInfo", ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckServiceImpl_3", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
            return map;
        }
        DynamicObject[] taxOrg = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)}, (String)"org desc", (int)1);
        if (taxOrg.length < 1 || taxOrg[0].getDynamicObject("org") == null) {
            map.put("failInfo", ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckServiceImpl_3", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
            return map;
        }
        map.put("orgid", taxOrg[0].getDynamicObject("org").getLong("id"));
        return map;
    }
}

