/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.org;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.tctb.mservice.abstractService.AbstractService;
import kd.taxc.tctb.mservice.api.org.OrgService;
import org.apache.commons.lang3.ObjectUtils;

public class OrgServiceImpl
extends AbstractService
implements OrgService {
    private static final String[] ORG_MUSTFIELDS = new String[]{"accountingstandards", "registertype", "registertime", "codeandname", "registeraddress", "actualaddress", "taxoffice"};

    public List<Map<String, Object>> getOrgLists() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection collection = TreeUtils.getOrgLists();
        if (collection.size() > 0) {
            DataEntityPropertyCollection propertiesCol = collection.getDynamicObjectType().getProperties();
            collection.stream().forEach(o -> {
                HashMap map = new HashMap();
                propertiesCol.stream().forEach(properties -> map.put(properties.getName(), o.get(properties.getName())));
                list.add(map);
            });
        }
        return list;
    }

    public List<Map<String, Object>> queryOrgListByCondition(Map<String, List<Object>> condition) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        if (ObjectUtils.isNotEmpty(condition)) {
            DynamicObjectCollection collection = TreeUtils.queryOrgListByCondition(condition);
            DataEntityPropertyCollection propertiesCol = collection.getDynamicObjectType().getProperties();
            collection.stream().forEach(o -> {
                HashMap map = new HashMap();
                propertiesCol.stream().forEach(properties -> map.put(properties.getName(), o.get(properties.getName())));
                list.add(map);
            });
        }
        return list;
    }

    public String queryOrgGroupDetailForAggregator(String type, String shareid, String orgid, Date startdate, Date enddate) {
        return OrgUtils.queryOrgGroupDetailForAggregator((String)type, (String)shareid, (String)orgid, (Date)startdate, (Date)enddate);
    }

    public String getOrgNameById(String orgid) {
        return OrgUtils.getOrgNameById((String)orgid);
    }

    public String getOrgStatusById(String orgid) {
        return OrgUtils.getOrgStatusById((String)orgid);
    }

    public Long getDefaultViewSchemaInfoId() {
        return OrgUtils.getDefaultViewSchemaInfoId();
    }

    public Long getLocalDefaultViewId() {
        return OrgUtils.getLocalDefaultViewId();
    }

    public List<Long> mergeOrgIds(List<Long> idList, String status) {
        return OrgUtils.mergeOrgIds(idList, (String)status);
    }

    public String getAllPermNodes(String appNumber, String entityId, String type) {
        List list = OrgUtils.getAllPermNodes((String)appNumber, (String)entityId, (String)type);
        return this.result(list);
    }

    public String getAllOrgByViewId(Long orgViewSchemaId, String qFilterJson) {
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)qFilterJson)) {
            qFilter = (QFilter)SerializationUtils.fromJsonString((String)qFilterJson, QFilter.class);
        }
        return this.result(OrgUtils.getAllOrgByViewId((Long)orgViewSchemaId, qFilter));
    }

    public List<Long> getAllOrgByView(Long orgViewSchemaId, String qFilterJson) {
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)qFilterJson)) {
            qFilter = (QFilter)SerializationUtils.fromJsonString((String)qFilterJson, QFilter.class);
        }
        Map orgMap = OrgUtils.getAllOrgByView((Long)orgViewSchemaId, qFilter);
        for (Map.Entry entry : orgMap.entrySet()) {
            orgIds.add(Long.valueOf((String)entry.getKey()));
        }
        return orgIds;
    }

    public Map<String, String> validationTaxOrgMustInput(Long orgId, String name, boolean needErrorMsg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", "false");
        map.put("failInfo", "");
        String info = name;
        QFilter istaxpayerQ = new QFilter("istaxpayer", "=", (Object)"1");
        QFilter orgQ = new QFilter("org", "=", (Object)orgId);
        if (!QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{istaxpayerQ, orgQ})) {
            map.put("code", "true");
            if (needErrorMsg) {
                map.put("failInfo", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u4e3a\u975e\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u4e0d\u80fd\u8fdb\u884c\u8ba1\u7a0e\u548c\u7533\u62a5\uff0c\u5982\u9700\u64cd\u4f5c\u8bf7\u5c06\u7a0e\u52a1\u7ec4\u7ec7\u8c03\u6574\u4e3a\u7eb3\u7a0e\u4e3b\u4f53\u3002", (String)"OrgServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]), info));
            }
            return map;
        }
        QFilter taxorgQ = new QFilter("taxorg", "=", (Object)orgId);
        QFilter taxationsysQfilter = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)StringUtil.join((Object[])ORG_MUSTFIELDS, (String)","), (QFilter[])new QFilter[]{taxorgQ, taxationsysQfilter});
        if (null == org) {
            map.put("code", "true");
            if (needErrorMsg) {
                map.put("failInfo", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]), info));
            }
            return map;
        }
        for (String orgMustfield : ORG_MUSTFIELDS) {
            if (!StringUtil.isBlank((CharSequence)org.getString(orgMustfield))) continue;
            map.put("code", "true");
            if (needErrorMsg) {
                map.put("failInfo", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), info));
            }
            return map;
        }
        return map;
    }

    public List<Map<String, Object>> queryEnableOrgs(String selectFields, String filterJson) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        QFilter filter = null;
        if (StringUtil.isNotBlank((CharSequence)filterJson)) {
            filter = (QFilter)SerializationUtils.fromJsonString((String)filterJson, QFilter.class);
        }
        DynamicObjectCollection collection = OrgUtils.queryEnableOrgs((String)selectFields, filter);
        DataEntityPropertyCollection propertiesCol = collection.getDynamicObjectType().getProperties();
        collection.stream().forEach(o -> {
            HashMap map = new HashMap();
            propertiesCol.stream().forEach(properties -> map.put(properties.getName(), o.get(properties.getName())));
            list.add(map);
        });
        return list;
    }
}

