/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.org;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.utils.DyoToDtoUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tctb.business.orgmap.OrgMapBusiness;
import kd.taxc.tctb.business.orgmap.OrgMapRelationBusiness;
import kd.taxc.tctb.mservice.api.org.TaxOrgMappingService;
import org.apache.commons.collections.CollectionUtils;

public class TaxOrgMappingServiceImpl
implements TaxOrgMappingService {
    private static final String key_isMapping = "isMapping";
    private static final String key_fieldkey = "fieldkey";
    private static final String key_mappingList = "mappingList";
    private static final String key_mappingList_business = "business";
    private static final String key_mappingList_business_name = "businessname";
    private static final String key_mappingList_businessid = "businessid";
    private static final String key_mappingList_taxcategory = "taxcategory";

    public Map<String, Object> getDataSourceMappingListByTaxorg(Long dataSourceId, List<Long> taxorgs, Date startDate, Date endDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(key_isMapping, Boolean.FALSE);
        QFilter idQ = new QFilter("id", "=", (Object)dataSourceId);
        QFilter accessmapQ = new QFilter("entryentity.accessmap", "!=", (Object)0L);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.fieldname,entryentity.accessmap", (QFilter[])new QFilter[]{idQ, accessmapQ});
        if (null != dynamicObject) {
            resultMap.put(key_isMapping, Boolean.TRUE);
            HashMap taxOrgMapObjectMap = new HashMap();
            String fieldName = dynamicObject.getString("entryentity.fieldname");
            Long accessmapId = dynamicObject.getLong("entryentity.accessmap");
            DynamicObject[] objects = OrgMapRelationBusiness.queryOrgMapRelations((Long)accessmapId, taxorgs, (Date)startDate, (Date)endDate);
            Stream.of(objects).forEach(row -> {
                Long taxorg = row.getLong("useorg.id");
                String business = row.getString("group.mapobject.number");
                DynamicObjectCollection entryColl = row.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryColl) {
                    String businessId = entry.getString(key_mappingList_businessid);
                    String taxcategoryId = entry.getString(key_mappingList_taxcategory);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(key_mappingList_business, business);
                    map.put(key_mappingList_businessid, businessId);
                    map.put(key_mappingList_taxcategory, taxcategoryId);
                    if (null == taxOrgMapObjectMap.get(taxorg)) {
                        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
                        list.add(map);
                        taxOrgMapObjectMap.put(taxorg, list);
                        continue;
                    }
                    ((List)taxOrgMapObjectMap.get(taxorg)).add(map);
                }
            });
            resultMap.put(key_fieldkey, fieldName);
            resultMap.put(key_mappingList, taxOrgMapObjectMap);
        }
        return resultMap;
    }

    public Map<Long, Map<String, Object>> getDataSourceMappingList(List<Long> dataSourceIds, Long taxOrg, Date startDate, Date endDate, Long categoryId) {
        HashMap<Long, Map<String, Object>> returnMap = new HashMap<Long, Map<String, Object>>();
        QFilter idQ = new QFilter("id", "in", dataSourceIds);
        QFilter accessmapQ = new QFilter("entryentity.accessmap", "!=", (Object)0L);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"id,entryentity.fieldname,entryentity.accessmap", (QFilter[])new QFilter[]{idQ, accessmapQ});
        if (CollectionUtils.isNotEmpty((Collection)objs)) {
            objs.stream().forEach(o -> {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put(key_isMapping, Boolean.TRUE);
                HashMap taxOrgMapObjectMap = new HashMap();
                String fieldName = o.getString("entryentity.fieldname");
                Long accessmapId = o.getLong("entryentity.accessmap");
                DynamicObject[] objects = OrgMapRelationBusiness.queryOrgMapRelations((Long)accessmapId, Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
                Stream.of(objects).forEach(row -> {
                    Long taxorg = row.getLong("useorg.id");
                    String business = row.getString("group.mapobject.number");
                    String businessName = row.getString("group.mapobject.name");
                    DynamicObjectCollection entryColl = row.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryColl) {
                        String taxcategoryId = entry.getString(key_mappingList_taxcategory);
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        String businessId = entry.getString(key_mappingList_businessid);
                        map.put(key_mappingList_business, business);
                        map.put(key_mappingList_business_name, businessName);
                        map.put(key_mappingList_businessid, businessId != null && TaxOrgMappingServiceImpl.isLongPk(business) ? Long.valueOf(businessId) : businessId);
                        if (StringUtils.isNotBlank((String)taxcategoryId)) {
                            List<String> taxcategoryIds = Arrays.asList(taxcategoryId.split(","));
                            if (categoryId == null || categoryId == 0L || !taxcategoryIds.contains(String.valueOf(categoryId))) continue;
                            map.put(key_mappingList_taxcategory, categoryId);
                            if (null == taxOrgMapObjectMap.get(taxorg)) {
                                ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                                list.add(map);
                                taxOrgMapObjectMap.put(taxorg, list);
                                continue;
                            }
                            ((List)taxOrgMapObjectMap.get(taxorg)).add(map);
                            continue;
                        }
                        if (null == taxOrgMapObjectMap.get(taxorg)) {
                            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
                            list.add(map);
                            taxOrgMapObjectMap.put(taxorg, list);
                            continue;
                        }
                        ((List)taxOrgMapObjectMap.get(taxorg)).add(map);
                    }
                });
                resultMap.put(key_fieldkey, fieldName);
                resultMap.put(key_mappingList, taxOrgMapObjectMap);
                returnMap.put(o.getLong("id"), resultMap);
            });
        }
        return returnMap;
    }

    public Map<String, Object> getOrgMappingByOrgIds(List<Long> orgIds) {
        List result = null;
        try {
            result = DyoToDtoUtils.dyoToLong((DynamicObject[])OrgMapRelationBusiness.queryOrgMappingByOrgIds(orgIds), (String)"id");
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (Object)result);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    public Map<String, Object> getOrgMappingByOrgIdAndCategoryId(Long orgId, Long categoryId, Date startDate, Date endDate) {
        HashMap returnMap = new HashMap();
        try {
            DynamicObjectCollection objects = OrgMapRelationBusiness.queryOrgMapRelations((Long)orgId, (Long)categoryId, (Date)startDate, (Date)endDate);
            objects.stream().forEach(obj -> {
                String mappingObjNumber = obj.getString("group.mapobject.number");
                boolean longPk = TaxOrgMappingServiceImpl.isLongPk(mappingObjNumber);
                if (!returnMap.containsKey(mappingObjNumber)) {
                    returnMap.put(mappingObjNumber, new ArrayList());
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                String id = obj.getString("entryentity.businessid");
                dataMap.put(key_mappingList_business_name, obj.getString("entryentity.businessname"));
                dataMap.put("businessnumber", obj.getString("entryentity.businessnumber"));
                dataMap.put(key_mappingList_businessid, longPk ? Long.valueOf(Long.parseLong(id)) : id);
                ((List)returnMap.get(mappingObjNumber)).add(dataMap);
            });
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), returnMap);
        }
        return ServiceResultUtils.returnResultHandler(returnMap);
    }

    public Map<String, Object> getOrgMappingByOrgIdAndCategoryIdAndGroup(Long orgId, Long categoryId, Long groupId, Date startDate, Date endDate) {
        Map result = null;
        try {
            result = DyoToDtoUtils.dyoToIdMap((DynamicObjectCollection)OrgMapRelationBusiness.queryOrgMapRelations((Long)orgId, (Long)categoryId, (Long)groupId, (Date)startDate, (Date)endDate), (String)"id", (String)"entryentity");
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (Object)result);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    public Map<String, Object> getOrgMappingPlanByIds(List<Long> ids) {
        List result = null;
        try {
            result = DyoToDtoUtils.dyoToLong((DynamicObject[])OrgMapBusiness.queryOrgMapByIds(ids), (String)"id");
        }
        catch (KDBizException e) {
            return ServiceResultUtils.returnResultHandler((boolean)Boolean.FALSE, (String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (Object)result);
        }
        return ServiceResultUtils.returnResultHandler((Object)result);
    }

    private static boolean isLongPk(String entityName) {
        ISimpleProperty prop = MetadataServiceHelper.getDataEntityType((String)entityName).getPrimaryKey();
        return prop instanceof LongProp;
    }
}

