/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.provision;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctb.business.shareplan.ProvisionSharePlanBusiness;
import kd.taxc.tctb.mservice.api.provision.TaxprovisionService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TaxprovisionServiceImpl
implements TaxprovisionService {
    private static final Log logger = LogFactory.getLog(TaxprovisionServiceImpl.class);

    public String createTaxprovision(String paramsJson) {
        logger.info("\u521b\u5efa\u7a0e\u91d1\u8ba1\u63d0\u5355\u53c2\u6570\uff1a" + paramsJson);
        List listparams = (List)SerializationUtils.fromJsonString((String)paramsJson, List.class);
        if (listparams == null) {
            return SerializationUtils.toJsonString((Object)BaseResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxprovisionServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0])));
        }
        List<Map<String, String>> message = this.doCreateTaxprovision(listparams);
        if (CollectionUtils.isNotEmpty(message)) {
            String result = SerializationUtils.toJsonString((Object)BaseResult.ok(message));
            logger.info("\u521b\u5efa\u7a0e\u91d1\u8ba1\u63d0\u5355\u51fa\u53c2\uff1a" + result);
            return result;
        }
        return SerializationUtils.toJsonString((Object)BaseResult.fail((String)ResManager.loadKDString((String)"\u8ba1\u63d0\u5355\u751f\u6210\u5931\u8d25", (String)"TaxprovisionServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0])));
    }

    /*
     * Unable to fully structure code
     */
    public List<Map<String, String>> doCreateTaxprovision(List listparams) {
        saveObjects = new ArrayList<DynamicObject>();
        message = new ArrayList<Map<String, String>>(listparams.size());
lbl3:
        // 2 sources

        try {
            for (i = 0; i < listparams.size(); ++i) {
                block6: {
                    block7: {
                        params = (LinkedHashMap)listparams.get(i);
                        noExtraProps = new HashSet<String>(16);
                        taxorg = params.get("taxorg");
                        accountorg = params.get("accountorg");
                        details = params.get("details");
                        noExtraProps.add("details");
                        taxtype = params.get("taxtype");
                        if (details == null || taxorg == null || taxtype == null || !TaxprovisionServiceImpl.isDimprovision(Long.valueOf(String.valueOf(taxorg)), Long.valueOf(String.valueOf(taxtype))).booleanValue()) break block6;
                        detailDatas = (List)details;
                        if (!CollectionUtils.isNotEmpty((Collection)detailDatas)) break block7;
                        collect = detailDatas.stream().collect(Collectors.groupingBy((Function<Map, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$doCreateTaxprovision$0(java.util.Map ), (Ljava/util/Map;)Ljava/lang/Object;)()));
                        for (Map.Entry<Object, List<Map>> dateListEntry : collect.entrySet()) {
                            this.dealData(saveObjects, params, noExtraProps, dateListEntry.getValue(), dateListEntry.getKey(), Boolean.TRUE);
                        }
                        ** GOTO lbl3
                    }
                    this.dealData(saveObjects, params, noExtraProps, details, accountorg, Boolean.FALSE);
                    continue;
                }
                this.dealData(saveObjects, params, noExtraProps, details, accountorg, Boolean.FALSE);
            }
            if (CollectionUtils.isNotEmpty(saveObjects) && ObjectUtils.isNotEmpty((Object)(successResult = SaveServiceHelper.save((DynamicObject[])saveObjects.toArray(new DynamicObject[saveObjects.size()]))))) {
                for (Object result : successResult) {
                    map = new HashMap<String, String>(1);
                    dynamicObject = (DynamicObject)result;
                    map.put(dynamicObject.getString("entitynumber"), dynamicObject.getString("billno"));
                    message.add(map);
                }
            }
        }
        catch (Exception e) {
            TaxprovisionServiceImpl.logger.info("\u751f\u6210\u7a0e\u91d1\u8ba1\u63d0\u5355\u63a5\u53e3 \u5f02\u5e38\u62a5\u9519" + e.getMessage());
        }
        return message;
    }

    private void dealData(List<DynamicObject> saveObjects, Map<String, Object> params, Set<String> noExtraProps, Object details, Object accountorg, boolean needSplit) {
        Object taxsystem = params.get("taxsystem");
        noExtraProps.add("taxsystem");
        Object taxtype = params.get("taxtype");
        noExtraProps.add("taxtype");
        Object taxarea = params.get("taxarea");
        noExtraProps.add("taxarea");
        Object taxorg = params.get("taxorg");
        noExtraProps.add("taxorg");
        noExtraProps.add("accountorg");
        Object item = params.get("provistonitem");
        noExtraProps.add("provistonitem");
        Object startdate = params.get("startdate");
        noExtraProps.add("startdate");
        Object enddate = params.get("enddate");
        noExtraProps.add("enddate");
        Object entrydate = params.get("entrydate");
        noExtraProps.add("entrydate");
        Object coins = params.get("coins");
        noExtraProps.add("coins");
        Object total = params.get("total");
        noExtraProps.add("total");
        Object entitytype = params.get("entitytype");
        noExtraProps.add("entitytype");
        Object entitynumber = params.get("entitynumber");
        noExtraProps.add("entitynumber");
        Object creator = params.get("creator");
        noExtraProps.add("creator");
        Object modifier = params.get("modifier");
        noExtraProps.add("modifier");
        Object accountsettype = params.get("accountsettype");
        noExtraProps.add("accountsettype");
        Object sourcedrafttype = params.get("sourcedrafttype");
        noExtraProps.add("sourcedrafttype");
        Date date = new Date();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_proviston_taxes");
        dynamicObject.set("taxorg", taxorg);
        dynamicObject.set("accountorg", accountorg);
        dynamicObject.set("taxsystem", taxsystem);
        dynamicObject.set("taxtype", taxtype);
        dynamicObject.set("taxarea", taxarea);
        dynamicObject.set("provistonitem", item);
        dynamicObject.set("startdate", null != startdate ? DateUtils.stringToDate((String)((String)startdate), (String)"yyyy-MM-dd") : null);
        dynamicObject.set("enddate", null != enddate ? DateUtils.stringToDate((String)((String)enddate), (String)"yyyy-MM-dd") : null);
        dynamicObject.set("entrydate", null != entrydate ? DateUtils.stringToDate((String)((String)entrydate), (String)"yyyy-MM-dd") : null);
        dynamicObject.set("coins", coins);
        dynamicObject.set("total", total);
        dynamicObject.set("isvoucher", (Object)"0");
        dynamicObject.set("billstatus", (Object)"A");
        dynamicObject.set("entitytype", entitytype);
        dynamicObject.set("entitynumber", entitynumber);
        dynamicObject.set("creator", creator);
        dynamicObject.set("createtime", (Object)date);
        dynamicObject.set("modifier", modifier);
        dynamicObject.set("modifytime", (Object)date);
        dynamicObject.set("accountsettype", accountsettype);
        if (details != null) {
            TaxprovisionServiceImpl.buildEntry((List)details, dynamicObject, needSplit);
        }
        if (ObjectUtils.isNotEmpty((Object)sourcedrafttype)) {
            dynamicObject.set("sourcedrafttype", sourcedrafttype);
        } else if (ObjectUtils.isNotEmpty((Object)entitytype)) {
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)entitytype, (String)"bos_entityobject", (String)"name");
            dynamicObject.set("sourcedrafttype", (Object)object.getString("name"));
        }
        ArrayList<String> propertyNames = new ArrayList<String>(16);
        for (IDataEntityProperty property : dynamicObject.getDataEntityType().getProperties()) {
            propertyNames.add(property.getName());
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (noExtraProps.contains(entry.getKey()) || !propertyNames.contains(entry.getKey())) continue;
            dynamicObject.set(entry.getKey(), entry.getValue());
        }
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.getNumber("itp_proviston_taxes", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        saveObjects.add(dynamicObject);
    }

    private static void buildEntry(List<Map<String, Object>> details, DynamicObject obj, boolean needSplit) {
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        if (needSplit) {
            Map<String, List<Map>> detailGroupMap = details.stream().collect(Collectors.groupingBy(o -> TaxprovisionServiceImpl.getDetailGroupKey(o)));
            BigDecimal total = BigDecimal.ZERO;
            DynamicObjectCollection entry = obj.getDynamicObjectCollection("taxesentryentity");
            for (Map.Entry<String, List<Map>> detailListEntry : detailGroupMap.entrySet()) {
                if (detailListEntry.getValue() == null || detailListEntry.getValue().size() == 0) continue;
                Map detail = detailListEntry.getValue().get(0);
                DynamicObject entryObj = entry.addNew();
                entryObj.set("taxitem", detail.get("taxitem"));
                entryObj.set("bizdimensiontype", detail.get("bizdimensiontype"));
                entryObj.set("bizdimensionname", detail.get("bizdimensionname"));
                entryObj.set("bizdimensionid", detail.get("bizdimensionid"));
                BigDecimal jtsl = TaxprovisionServiceImpl.getSumJtsj(detailListEntry.getValue());
                entryObj.set("jtsj", (Object)jtsl);
                total = total.add(jtsl);
            }
            obj.set("total", (Object)total);
        } else {
            DynamicObjectCollection entry = obj.getDynamicObjectCollection("taxesentryentity");
            details.stream().forEach(o -> {
                DynamicObject entryObj = entry.addNew();
                entryObj.set("bizdimensiontype", o.get("bizdimensiontype"));
                entryObj.set("bizdimensionname", o.get("bizdimensionname"));
                entryObj.set("bizdimensionid", o.get("bizdimensionid"));
                entryObj.set("taxitem", o.get("taxitem"));
                entryObj.set("jtsj", o.get("sjjt"));
            });
        }
    }

    private static String getDetailGroupKey(Map<String, Object> o) {
        String dim = "%s_%s_%s";
        String taxitem = String.valueOf(o.get("taxitem"));
        String bizdimensiontype = String.valueOf(o.get("bizdimensiontype"));
        String bizdimensionid = String.valueOf(o.get("bizdimensionid"));
        return String.format(dim, taxitem, bizdimensiontype, bizdimensionid);
    }

    private static BigDecimal getSumJtsj(List<Map<String, Object>> values) {
        if (values == null || values.size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = BigDecimal.ZERO;
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> value = values.get(i);
            BigDecimal jtsl = value.get("sjjt") == null ? BigDecimal.ZERO : (BigDecimal)value.get("sjjt");
            total = total.add(jtsl);
        }
        return total;
    }

    private static Boolean isDimprovision(Long orgId, Long categoryId) {
        DynamicObjectCollection objects = ProvisionSharePlanBusiness.queryProvisionSharePlanByOrgIdsAndCategoryId(Collections.singletonList(orgId), (Long)categoryId, (Long)TaxationsysMappingEnum.CHN.getId());
        Boolean isDimprovision = false;
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            Optional<DynamicObject> first = objects.stream().filter(o -> o.getBoolean("ruleentity.rule.isdimprovision") && o.getString("ruleentity.rule.provisiondimension").contains("accountorg")).findFirst();
            isDimprovision = first.isPresent();
        }
        return isDimprovision;
    }

    private static /* synthetic */ Object lambda$doCreateTaxprovision$0(Map d) {
        return d.get("accountorg");
    }
}

