/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.taskmonistor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.business.task.TaskUpdateService;
import kd.taxc.tctb.mservice.api.taskmonistor.TaskMonistorService;
import org.apache.commons.lang3.StringUtils;

public class TaskMonistorServiceImpl
implements TaskMonistorService {
    private static final Log logger = LogFactory.getLog(TaskMonistorServiceImpl.class);
    private static final String DEFAULT_EXECUTE_TYPE = "1";
    private static final String TASK_MONITOR_DETAIL = "tctb_task_monitor_detail";
    private static final TaskUpdateService taskUpdateService = new TaskUpdateService();

    public Map<String, Object> branchCreateTask(Map<String, Object> params) {
        String executeType;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (this.validateCreatTaskParams(params, resultMap)) {
            return resultMap;
        }
        List subTasks = Objects.isNull(params.get("subTasks")) ? new ArrayList() : (List)params.get("subTasks");
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(subTasks.size());
        ArrayList<Long> subIds = new ArrayList<Long>(subTasks.size());
        String parentId = Objects.isNull(params.get("taskId")) ? UUID.randomUUID().toString() : (String)params.get("taskId");
        String string = executeType = Objects.isNull(params.get("executeType")) ? DEFAULT_EXECUTE_TYPE : (String)params.get("executeType");
        if (EmptyCheckUtils.isNotEmpty(subTasks)) {
            long[] ids = DB.genLongIds((String)"t_tctb_task_detail", (int)subTasks.size());
            for (int i = 0; i < subTasks.size(); ++i) {
                Map subTask = (Map)subTasks.get(i);
                long subTaskSerinoNumber = ids[i];
                DynamicObject task = taskUpdateService.saveSubTask(subTask, parentId, subTaskSerinoNumber);
                subIds.add(subTaskSerinoNumber);
                detailList.add(task);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                taskUpdateService.saveParentTask(params, parentId, executeType);
                if (EmptyCheckUtils.isNotEmpty(detailList)) {
                    SaveServiceHelper.save((DynamicObject[])detailList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("TaskMonistorServiceImpl branchCreateTask cause exception\uff1a", (Throwable)e);
            }
        }
        resultMap.put("success", "true");
        resultMap.put("taskId", parentId);
        resultMap.put("subIds", subIds);
        resultMap.put("msg", ResManager.loadKDString((String)"\u4efb\u52a1\u521b\u5efa\u6210\u529f\u3002", (String)"TaskMonistorServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
        return resultMap;
    }

    public Map<String, Object> updateTaskInfo(Map<String, Object> params) {
        Long taskSerialNumber;
        String success;
        String taskId;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        String errorMsg = "";
        if (Objects.isNull(params)) {
            errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
            resultMap.put("success", "false");
            resultMap.put("Msg", errorMsg);
            return resultMap;
        }
        String string = taskId = Objects.isNull(params.get("taskId")) ? null : (String)params.get("taskId");
        if (StringUtils.isBlank((CharSequence)taskId)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), "taskId");
        }
        String string2 = success = Objects.isNull(params.get("success")) ? null : (String)params.get("success");
        if (StringUtils.isBlank((CharSequence)success)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), "success");
        }
        Long l = taskSerialNumber = Objects.isNull(params.get("taskSerialNumber")) ? null : (Long)params.get("taskSerialNumber");
        if (Objects.isNull(taskSerialNumber)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), "taskSerialNumber");
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            resultMap.put("success", "false");
            resultMap.put("Msg", errorMsg);
            return resultMap;
        }
        taskUpdateService.handlerTaskDetailInfo(params, taskId, taskSerialNumber);
        resultMap.put("success", "true");
        resultMap.put("taskId", taskId);
        resultMap.put("msg", ResManager.loadKDString((String)"\u66f4\u65b0\u8c03\u5ea6\u4efb\u52a1\u65e5\u5fd7\u6210\u529f\u3002", (String)"TaskMonistorServiceImpl_3", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
        return resultMap;
    }

    public DynamicObject[] querySubTaskDetail(String selectProperties, QFilter[] qFilters) {
        if (StringUtils.isBlank((CharSequence)selectProperties) || EmptyCheckUtils.isEmpty((Object)qFilters)) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)TASK_MONITOR_DETAIL, (String)selectProperties, (QFilter[])qFilters);
    }

    private boolean validateCreatTaskParams(Map<String, Object> params, Map<String, Object> resultMap) {
        List subTasks;
        String taskName;
        String taskClassName;
        String errorMsg = "";
        if (Objects.isNull(params)) {
            errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
            resultMap.put("success", "false");
            resultMap.put("msg", errorMsg);
            return true;
        }
        String string = taskClassName = Objects.isNull(params.get("taskClassName")) ? null : (String)params.get("taskClassName");
        if (StringUtils.isBlank((CharSequence)taskClassName)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), "taskClassName");
        }
        String string2 = taskName = Objects.isNull(params.get("taskName")) ? null : (String)params.get("taskName");
        if (StringUtils.isBlank((CharSequence)taskName)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), "taskName");
        }
        List list = subTasks = Objects.isNull(params.get("subTasks")) ? new ArrayList() : (List)params.get("subTasks");
        if (CollectionUtils.isEmpty(subTasks)) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskMonistorServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), "subTasks");
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            resultMap.put("success", "false");
            resultMap.put("msg", errorMsg);
            return true;
        }
        return false;
    }
}

