/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.taxinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.common.constant.RequestResult;
import kd.taxc.common.json.JsonUtil;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.mq.MQSender;
import kd.taxc.tctb.mservice.api.taxinfo.TaxtypeCardService;
import org.apache.commons.lang.StringUtils;

public class TaxtypeCardServiceImpl
implements TaxtypeCardService {
    private static final String COMPARE_QUEUE = "taxc.tctb.sfzhd.compare";
    private static final String CONVERT_QUEUE = "taxc.tctb.sfzhd.convert";

    public String compare(String json, String extensionJson) {
        RequestResult result;
        List ids = JsonUtil.fromJsonList((String)json, Long.class);
        DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_taxtype_verify"));
        try {
            Arrays.stream(datas).forEach(o -> o.set("comparestatus", (Object)"comparing"));
            Map<String, List> dataMap = Arrays.stream(datas).collect(Collectors.toMap(a -> a.getDynamicObject("org").getString("id"), a -> {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(a.getLong("id"));
                return list;
            }, (value1, value2) -> {
                value1.addAll(value2);
                return value1;
            }));
            for (Map.Entry<String, List> entry : dataMap.entrySet()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("orgId", entry.getKey());
                data.put("pkIds", entry.getValue());
                if (EmptyCheckUtils.isNotEmpty((Object)extensionJson)) {
                    Map extensionMap = (Map)JsonUtil.fromJson((String)extensionJson, Map.class);
                    data.putAll(extensionMap);
                }
                MQSender.send((String)COMPARE_QUEUE, (String)JsonUtil.toJson(data));
            }
            SaveServiceHelper.save((DynamicObject[])datas);
            result = RequestResult.success(null);
        }
        catch (Exception e) {
            Arrays.stream(datas).forEach(o -> o.set("comparestatus", (Object)"fail"));
            result = RequestResult.ex((Throwable)e);
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    public String convert(String json) {
        RequestResult result;
        List ids = JsonUtil.fromJsonList((String)json, Long.class);
        DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_taxtype_verify"));
        try {
            Arrays.stream(datas).forEach(o -> o.set("updatestatus", (Object)"updating"));
            Map<String, List> dataMap = Arrays.stream(datas).collect(Collectors.toMap(a -> a.getDynamicObject("org").getString("id"), a -> {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(a.getLong("id"));
                return list;
            }, (value1, value2) -> {
                value1.addAll(value2);
                return value1;
            }));
            for (Map.Entry<String, List> entry : dataMap.entrySet()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("orgId", entry.getKey());
                data.put("pkIds", entry.getValue());
                MQSender.send((String)CONVERT_QUEUE, (String)JsonUtil.toJson(data));
            }
            SaveServiceHelper.save((DynamicObject[])datas);
            result = RequestResult.success(null);
        }
        catch (Exception e) {
            Arrays.stream(datas).forEach(o -> o.set("updatestatus", (Object)"fail"));
            result = RequestResult.ex((Throwable)e);
        }
        return SerializationUtils.toJsonString((Object)result);
    }

    public String save(String json, String extensionJson) {
        try {
            Map sfzhdMap;
            Object data;
            ArrayList<DynamicObject> sfzhdxxs = new ArrayList<DynamicObject>();
            if (EmptyCheckUtils.isNotEmpty((Object)json) && (data = (sfzhdMap = (Map)JsonUtil.fromJson((String)json, Map.class)).get("tctb_taxtype_verify")) != null && EmptyCheckUtils.isNotEmpty((Object)extensionJson)) {
                Map extensionMap = (Map)JsonUtil.fromJson((String)extensionJson, Map.class);
                if (!extensionMap.containsKey("orgId")) {
                    return SerializationUtils.toJsonString((Object)RequestResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxtypeCardServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0])));
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                List dataMaps = (List)data;
                DynamicObject[] verifyObjs = BusinessDataServiceHelper.load((String)"tctb_taxtype_verify", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", extensionMap.get("orgId"))});
                List<Object> pkIds = new ArrayList();
                if (verifyObjs != null && verifyObjs.length > 0) {
                    pkIds = Arrays.stream(verifyObjs).map(o -> o.getLong("id")).collect(Collectors.toList());
                }
                for (Map map : dataMaps) {
                    String levytype;
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"tctb_taxtype_verify");
                    boolean isexpiry = false;
                    if (EmptyCheckUtils.isNotEmpty(map.get("expirydate"))) {
                        Date expirydate = DateUtils.stringToDate((String)String.valueOf(map.get("expirydate")), (String)"yyyy-MM-dd");
                        obj.set("expirydate", (Object)expirydate);
                        isexpiry = new Date().after(expirydate);
                    }
                    Long id = DBUtils.getLongId((String)"tctb_taxtype_verify");
                    obj.set("id", (Object)id);
                    if (extensionMap.containsKey("orgId")) {
                        obj.set("taxorg", extensionMap.get("orgId"));
                        obj.set("org", extensionMap.get("orgId"));
                    }
                    obj.set("createtime", (Object)new Date());
                    obj.set("creator", (Object)RequestContext.get().getUserId());
                    obj.set("billstatus", (Object)"C");
                    obj.set("zsxm", map.get("zsxm"));
                    obj.set("zspm", map.get("zspm"));
                    obj.set("levytype", map.get("levytype"));
                    obj.set("taxlimit", map.get("taxlimit"));
                    obj.set("taxrate", map.get("taxrate"));
                    if (EmptyCheckUtils.isNotEmpty(map.get("effectivedate"))) {
                        Date effectiveDate = DateUtils.stringToDate((String)String.valueOf(map.get("effectivedate")), (String)"yyyy-MM-dd");
                        obj.set("effectivedate", (Object)effectiveDate);
                    }
                    if (StringUtils.isBlank((String)(levytype = String.valueOf(map.get("levytype")))) || !StringUtils.equals((String)"zxsb", (String)levytype) || "1".equals(map.get("infotype")) || isexpiry || "0".equals(map.get("zsxm")) && "0".equals(map.get("zspm"))) {
                        obj.set("updatestatus", (Object)"without");
                        obj.set("comparestatus", (Object)"nodata");
                    } else {
                        obj.set("updatestatus", (Object)"undo");
                        obj.set("comparestatus", (Object)"comparing");
                        ids.add(id);
                    }
                    obj.set("tbbmc", map.get("tbbmc"));
                    obj.set("tkjzd", map.get("tkjzd"));
                    obj.set("infotype", map.get("infotype"));
                    sfzhdxxs.add(obj);
                }
                SaveServiceHelper.save((DynamicObject[])sfzhdxxs.toArray(new DynamicObject[0]));
                if (!CollectionUtils.isEmpty(pkIds)) {
                    DeleteServiceHelper.delete((String)"tctb_taxtype_verify", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
                }
                return SerializationUtils.toJsonString((Object)RequestResult.success(ids));
            }
        }
        catch (Exception e) {
            return SerializationUtils.toJsonString((Object)RequestResult.fail((String)e.getMessage()));
        }
        return SerializationUtils.toJsonString((Object)RequestResult.success(null));
    }
}

