/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import org.apache.commons.lang3.StringUtils;

public class DataSourceEntryBizsubNameUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(DataSourceEntryBizsubNameUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        DataSourceEntryBizsubNameUpgradeService.update();
        result.setLog(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"DataSourceEntryBizsubNameUpgradeService_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
        return result;
    }

    private static void update() {
        try {
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"tctb_custom_datasource", (String)MetadataUtil.getAllSubFieldString((String)"tctb_custom_datasource"), (QFilter[])new QFilter[]{new QFilter("subname", "is not null", null).and("subname", "!=", (Object)"").and(new QFilter("subname", "!=", (Object)" ")).and("ischild", "=", (Object)"1")});
            if (loads != null && loads.length > 0) {
                logger.info("\u603b\u5171\u67e5\u8be2\u5230\u6570\u636e\u6761\u6570==============" + loads.length);
                Arrays.stream(loads).forEach(o -> {
                    try {
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)o.getString("entityname"));
                        String subName = o.getString("subname");
                        DynamicProperty property = mainEntityType.getProperty(subName);
                        DynamicObjectCollection entryentity = o.getDynamicObjectCollection("entryentity");
                        if (!CollectionUtils.isEmpty((Collection)entryentity) && StringUtils.isNotBlank((CharSequence)subName)) {
                            entryentity.stream().forEach(e -> {
                                String bizsubname = e.getString("bizsubname");
                                if (property != null && subName.equals(e.getString("fieldsubname")) && StringUtils.isNotBlank((CharSequence)bizsubname) && !bizsubname.startsWith(property.getDisplayName().getLocaleValue())) {
                                    e.set("bizsubname", (Object)(property.getDisplayName().getLocaleValue() + "." + e.getString("bizsubname")));
                                }
                            });
                        }
                    }
                    catch (Exception e2) {
                        logger.error("\u5347\u7ea7\u6570\u636e\u51fa\u95191==============", (Throwable)e2);
                        logger.error("\u5347\u7ea7\u6570\u636e\u51fa\u95191==============", (Object)e2.getMessage());
                    }
                });
                SaveServiceHelper.update((DynamicObject[])loads);
            }
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u6570\u636e\u51fa\u95192==============", (Throwable)e);
            logger.error("\u5347\u7ea7\u6570\u636e\u51fa\u95192==============", (Object)e.getMessage());
        }
    }
}

