/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.tctb.common.util.ComboUpgradeBaseEditUtil;
import kd.taxc.tctb.mservice.upgrade.enums.DataSourcePeekRuleEnum;

public class DataSourcePeekRuleUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        return DataSourcePeekRuleUpgradeService.doGetUpgradeResult();
    }

    public static UpgradeResult doGetUpgradeResult() {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6267\u884c\u81ea\u5b9a\u4e49\u6570\u636e\u6e90\u53d6\u6570\u89c4\u5219\u811a\u672c\u8fc7\u7a0b:", (String)"DataSourcePeekRuleUpgradeService_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
        List newBaseDataList = DBUtils.query((String)" SELECT FID,FNUMBER FROM t_tctb_datasource_pekrule ");
        if (EmptyCheckUtils.isEmpty((Object)newBaseDataList)) {
            message.append(ResManager.loadKDString((String)"================ tctb_datasource_peek_rule \u6570\u636e\u4e0d\u5b58\u5728\u3002\u505c\u6b62\u5347\u7ea7 =========", (String)"DataSourcePeekRuleUpgradeService_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
            result.setLog(message.toString());
            return result;
        }
        Map<String, Long> code2idMap = newBaseDataList.stream().collect(Collectors.toMap(k -> String.valueOf(k.get("FNUMBER")), v -> Long.parseLong(String.valueOf(v.get("FID")))));
        if (EmptyCheckUtils.isNotEmpty(code2idMap)) {
            HashMap<String, Object> paramterMap = new HashMap<String, Object>(2);
            paramterMap.put("message", message);
            paramterMap.put("code2idMap", code2idMap);
            String oldField = "FTAXTYPE";
            ComboUpgradeBaseEditUtil.upgrade(DataSourcePeekRuleUpgradeService::getHistoryDataSupplier, v -> EmptyCheckUtils.isEmpty(v.get(oldField)) ? null : String.valueOf(v.get(oldField)), DataSourcePeekRuleUpgradeService::clearNewConsumer, DataSourcePeekRuleUpgradeService::clearOldConsumer, DataSourcePeekRuleUpgradeService::setNewValConsumer, paramterMap);
        }
        result.setLog(message.toString());
        return result;
    }

    private static void clearOldConsumer(Map<String, Object> oldBeanMap) {
        DBUtils.execute((String)("update t_tctb_datasource_configs set ftaxtype = '  '  where fid = " + oldBeanMap.get("FID")));
    }

    private static void clearNewConsumer(Map<String, Object> oldBeanMap) {
        DBUtils.execute((String)("delete from  t_tctb_datasource_pkrules where fid = " + oldBeanMap.get("FID")));
    }

    private static List<Map<String, Object>> getHistoryDataSupplier() {
        return DBUtils.query((String)"select FID,FTAXTYPE  FROM  t_tctb_datasource_configs");
    }

    private static void setNewValConsumer(Map<String, Object> pkDataMap, List<String> oldDatas, Object obj) {
        if (EmptyCheckUtils.isEmpty((Object)obj)) {
            return;
        }
        Map paramterMap = (Map)obj;
        StringBuilder message = (StringBuilder)paramterMap.get("message");
        Map code2idMap = (Map)paramterMap.get("code2idMap");
        Long fid = Long.parseLong(String.valueOf(pkDataMap.get("FID")));
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (String oldData : oldDatas) {
            DataSourcePeekRuleEnum taxTypeEnum = DataSourcePeekRuleEnum.getEnumByType(oldData);
            if (null == taxTypeEnum) {
                message.append(String.format(ResManager.loadKDString((String)"\u6839\u636eoldkey=[%1$s],\u672a\u627e\u5230\u6620\u5c04\u5173\u7cfb;", (String)"DataSourcePeekRuleUpgradeService_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]), oldData));
                return;
            }
            for (String newkey : taxTypeEnum.getNewKeys()) {
                if (null == code2idMap.get(newkey)) {
                    message.append(String.format(ResManager.loadKDString((String)"\u6839\u636enewkey=[%1$s],\u672a\u67e5\u8be2\u5230\u8bb0\u5f55;", (String)"DataSourcePeekRuleUpgradeService_3", (String)"taxc-tctb-mservice", (Object[])new Object[0]), newkey));
                }
                Long pkid = DBUtils.getLongId((String)"t_tctb_datasource_pkrules");
                paramList.add(new Object[]{fid, pkid, code2idMap.get(newkey)});
            }
        }
        if (EmptyCheckUtils.isNotEmpty(paramList)) {
            DBUtils.executeBatch((String)" insert into t_tctb_datasource_pkrules(FID,FPKID,FBASEDATAID) values (?,?,?) ", paramList);
        }
    }
}

