/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.common.metadata.MetadataUtil;
import kd.taxc.common.util.StringUtil;

public class OrgMapRelationUpgradeMServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(OrgMapRelationUpgradeMServiceImpl.class);
    private UpgradeResult result = new UpgradeResult();
    private boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    protected String doUpgrade() {
        try {
            logger.info("\u5347\u7ea7\u7a0e\u52a1\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\uff0c\u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            SqlBuilder selectSql = new SqlBuilder();
            selectSql.append(" select a.fid as fid,a.fentryid as fentryid,", new Object[0]);
            selectSql.append(" b.fcreatorid as fcreatorid,b.fmodifierid as fmodifierid,b.fcreatetime as fcreatetime,b.fmodifytime as fmodifytime,b.fnumber as fgroupnumber", new Object[0]);
            selectSql.append(" from t_tctb_orgmap_taxorg a inner join t_tctb_orgmapentity b on a.fid = b.fid", new Object[0]);
            selectSql.append(" where a.fmasterid=0 or a.fmasterid is null", new Object[0]);
            HashMap<Long, List<RowDataInfo>> rowDataMap = new HashMap<Long, List<RowDataInfo>>(64);
            Long id = null;
            int count = 0;
            try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)selectSql);){
                for (Row row : dataSet) {
                    id = row.getLong("fid");
                    if (!rowDataMap.containsKey(id)) {
                        rowDataMap.put(id, new ArrayList());
                    }
                    ((List)rowDataMap.get(id)).add(new RowDataInfo(row));
                    if (rowDataMap.size() == 300) {
                        this.executeUpdate(rowDataMap);
                        rowDataMap.clear();
                    }
                    ++count;
                }
                if (!rowDataMap.isEmpty()) {
                    this.executeUpdate(rowDataMap);
                }
            }
            logger.info("\u5347\u7ea7\u7a0e\u52a1\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\uff0c\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a%s", (String)"OrgMapRelationUpgradeMServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]), count);
        }
        catch (Throwable e) {
            logger.error("\u5347\u7ea7\u7a0e\u52a1\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\uff0c\u5f02\u5e38\u62a5\u9519" + e.getMessage());
            throw e;
        }
    }

    protected void executeUpdate(Map<Long, List<RowDataInfo>> rowDataMap) {
        List<RowDataInfo> rowDataInfoList = null;
        String[] numbers = null;
        Long groupId = null;
        RowDataInfo rowDataInfo = null;
        String number = null;
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(64);
        boolean isBatchRuleNumber = false;
        for (Map.Entry<Long, List<RowDataInfo>> entry : rowDataMap.entrySet()) {
            groupId = entry.getKey();
            rowDataInfoList = entry.getValue();
            if (rowDataInfoList.size() == 0) continue;
            numbers = this.getBatchNumber(rowDataInfoList.get(0), rowDataInfoList.size());
            if (numbers != null && numbers.length == rowDataInfoList.size()) {
                isBatchRuleNumber = true;
            } else {
                logger.error(String.format("\u6279\u91cf\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u5931\u8d25\uff1a%s", String.valueOf(groupId)));
            }
            int size = rowDataInfoList.size();
            for (int i = 0; i < size; ++i) {
                rowDataInfo = rowDataInfoList.get(i);
                if (numbers != null && isBatchRuleNumber) {
                    rowDataInfo.setNumber(numbers[i]);
                } else {
                    number = this.getNumber(rowDataInfo);
                    if (StringUtil.isEmpty((CharSequence)number)) {
                        logger.error(String.format("\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u5931\u8d25\uff1a%s", String.valueOf(groupId)));
                        continue;
                    }
                    rowDataInfo.setNumber(number);
                }
                updateParams.add(rowDataInfo.toArray());
            }
        }
        if (updateParams.size() > 0) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append(" update t_tctb_orgmap_taxorg ");
            updateSql.append(" set fnumber = ?,fstatus = 'C',fcreatorid = ?,fmodifierid = ?,fcreatetime=?,fmodifytime=?,fmasterid=fentryid,fenable='1'");
            updateSql.append(" where fentryid = ?");
            DB.executeBatch((DBRoute)new DBRoute("taxc"), (String)updateSql.toString(), updateParams);
        }
    }

    protected String getNumber(RowDataInfo info) {
        if (!this.metaIsExist("tctb_orgmaprelation").booleanValue()) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctb_orgmaprelation");
        DynamicObject group = BusinessDataServiceHelper.newDynamicObject((String)"tctb_orgmapentity");
        group.set("id", (Object)info.getId());
        group.set("number", (Object)info.getGroupNumber());
        dynamicObject.set("group", (Object)group);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
    }

    protected String[] getBatchNumber(RowDataInfo info, int count) {
        if (!this.metaIsExist("tctb_orgmaprelation").booleanValue()) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctb_orgmaprelation");
        DynamicObject group = BusinessDataServiceHelper.newDynamicObject((String)"tctb_orgmapentity");
        group.set("id", (Object)info.getId());
        group.set("number", (Object)info.getGroupNumber());
        dynamicObject.set("group", (Object)group);
        return CodeRuleServiceHelper.getBatchNumber((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null, (int)count);
    }

    protected Boolean metaIsExist(String entityName) {
        try {
            MetadataUtil.getEntityById((String)entityName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static class RowDataInfo {
        private Long id;
        private Long entryID;
        private Long creatorID;
        private Long modifierID;
        private Date createTime;
        private Date modifyTime;
        private String number;
        private String groupNumber;

        public RowDataInfo(Row row) {
            this.id = row.getLong("fid");
            this.entryID = row.getLong("fentryid");
            this.creatorID = row.getLong("fcreatorid");
            this.modifierID = row.getLong("fmodifierid");
            this.createTime = row.getDate("fcreatetime");
            this.modifyTime = row.getDate("fmodifytime");
            this.groupNumber = row.getString("fgroupnumber");
        }

        public Object[] toArray() {
            Object[] objects = new Object[]{this.number, this.creatorID, this.modifierID, this.createTime, this.modifyTime, this.entryID};
            return objects;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public Long getId() {
            return this.id;
        }

        public String getGroupNumber() {
            return this.groupNumber;
        }
    }
}

