/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.db.DBRoute;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.EmptyCheckUtils;

public class OrgTakeRelationUpgradeService
implements IUpgradeService {
    private static final String ORGRELATION_SELECTSQL = "select fid  from T_ORG_OrgRelation where ftyperelationid = 1234103052718327808 ";
    private static final String ORG_TAKEDATA_SELECTSQL = "SELECT FID, FTAXORG, FACCOUNTORG FROM t_tctb_org_takedata  where ( fenddate is null and fstartdate <= ? ) or ( fenddate is not null and fstartdate <= ? and fenddate >= ? )";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(this.update());
        return result;
    }

    private String update() {
        try {
            List list = DBUtils.query((String)DBRoute.basedata.getRouteKey(), (String)ORGRELATION_SELECTSQL);
            if (CollectionUtils.isEmpty((Collection)list)) {
                Object[] params = new Object[]{new Date(), new Date(), new Date()};
                List rows = DBUtils.query((String)ORG_TAKEDATA_SELECTSQL, (Object[])params);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                if (!CollectionUtils.isEmpty((Collection)rows)) {
                    for (Map row : rows) {
                        Object fid = row.get("FID");
                        Object ftaxOrg = row.get("FTAXORG");
                        Object faccountOrg = row.get("FACCOUNTORG");
                        paramList.add(new Object[]{fid, faccountOrg, ftaxOrg});
                    }
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)DBRoute.basedata.getRouteKey(), (String)" INSERT INTO t_org_orgrelation (fid, ffromorgid, ftoorgid,ftyperelationid,fisincludesuborg, fconddeleenabled, fisincludesubtoorg, fisincludesubfromorg, fisdefaultfromorg, fisdefaulttoorg) VALUES (?, ?, ?,1234103052718327808, '', '0', '0', '0', '0', '0')", paramList);
                    }
                    return "OrgTakeRelationUpgradeService update success";
                }
            }
            return "not OrgTakeRelation date update";
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }
}

