/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.ThrowableHelper;

public class OrgViewUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(OrgViewUpgradeService.class);
    private static final String NUMBER = "10_taxc";
    private static final long VIEWID = 947076820862300160L;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6267\u884c\u7ec4\u7ec7\u89c6\u56fe\u811a\u672c\u8fc7\u7a0b", (String)"OrgViewUpgradeService_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
        this.create(message);
        result.setLog(ResManager.loadKDString((String)message.toString(), (String)"OrgViewUpgradeService_0", (String)"OrgViewUpgradeService_1", (Object[])new Object[0]));
        return result;
    }

    public void create(StringBuilder message) {
        QFilter viewFilter;
        QFilter[] orgfilters;
        String orgFields;
        DynamicObjectCollection orgIds;
        QFilter orgViewSchemafilter = new QFilter("id", "=", (Object)947076820862300160L);
        DynamicObjectCollection orgViewSchema = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id,number,name", (QFilter[])new QFilter[]{orgViewSchemafilter});
        if (Objects.isNull(orgViewSchema) || orgViewSchema.isEmpty()) {
            this.addViewSchema();
        }
        if (Objects.nonNull(orgIds = QueryServiceHelper.query((String)"bos_org_structure", (String)(orgFields = "id,org"), (QFilter[])(orgfilters = new QFilter[]{viewFilter = new QFilter("view", "=", (Object)947076820862300160L)}))) && orgIds.isEmpty()) {
            try {
                try {
                    this.saveRoot();
                    message.append(ResManager.loadKDString((String)"1\u3001\u4fdd\u5b58\u6839\u8282\u70b9\u6210\u529f \u3002", (String)"OrgViewUpgradeService_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    message.append(ResManager.loadKDString((String)"1\u3001\u4fdd\u5b58\u6839\u8282\u70b9\u5931\u8d25 \u3002", (String)"OrgViewUpgradeService_3", (String)"taxc-tctb-mservice", (Object[])new Object[0])).append(e.getMessage());
                }
                this.addViewOrg(message);
                this.updateOther(OrgUnitServiceHelper.getRootOrgId());
            }
            catch (Exception e) {
                LOGGER.error(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private void addViewSchema() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_viewschema");
        dynamicObject.set("id", (Object)947076820862300160L);
        dynamicObject.set("number", (Object)NUMBER);
        dynamicObject.set("treetype", (Object)"10");
        dynamicObject.set("isdefault", (Object)"0");
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("name", (Object)OrgViewUpgradeService.getName());
        dynamicObject.set("treetypeid", (Object)"10");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void addViewOrg(StringBuilder message) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_org_entity", (String)"id,name,number,parentid,orgfield", (QFilter[])new QFilter[0], (String)" parentid asc ");
        for (DynamicObject orgObject : dynamicObjects) {
            DynamicObject taxcOrgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_structure");
            long id = orgObject.getLong("id");
            String name = orgObject.getString("name");
            String number = orgObject.getString("number");
            Long parentid = "-1".equalsIgnoreCase(orgObject.getString("parentid")) ? 100000L : orgObject.getLong("parentid");
            taxcOrgObj.set("longnumber", (Object)number);
            taxcOrgObj.set("fullname", (Object)name);
            taxcOrgObj.set("level", (Object)1);
            taxcOrgObj.set("id", (Object)id);
            taxcOrgObj.set("masterid", (Object)id);
            taxcOrgObj.set("view", (Object)947076820862300160L);
            taxcOrgObj.set("org", (Object)orgObject.getString("id"));
            taxcOrgObj.set("yzjorgid", (Object)"");
            taxcOrgObj.set("sortcode", (Object)0);
            taxcOrgObj.set("isctrlunit", (Object)1);
            taxcOrgObj.set("startdate", (Object)Utils.getDate((int)0));
            taxcOrgObj.set("enddate", (Object)Utils.getEndDate());
            taxcOrgObj.set("isleaf", (Object)Boolean.FALSE);
            taxcOrgObj.set("isbizunit", (Object)Boolean.FALSE);
            taxcOrgObj.set("isstatsum", (Object)Boolean.TRUE);
            taxcOrgObj.set("parent", (Object)parentid);
            taxcOrgObj.set("status", (Object)"C");
            taxcOrgObj.set("enable", (Object)"1");
            taxcOrgObj.set("sortcode", (Object)0);
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taxcOrgObj});
                message.append(ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"OrgViewUpgradeService_4", (String)"taxc-tctb-mservice", (Object[])new Object[0])).append(id).append(taxcOrgObj.get("fullname")).append(ResManager.loadKDString((String)"\u63d2\u5165\u6210\u529f", (String)"OrgViewUpgradeService_5", (String)"taxc-tctb-mservice", (Object[])new Object[0]));
            }
            catch (Exception e) {
                message.append(ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"OrgViewUpgradeService_4", (String)"taxc-tctb-mservice", (Object[])new Object[0])).append(id).append(taxcOrgObj.get("fullname")).append(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25", (String)"OrgViewUpgradeService_6", (String)"taxc-tctb-mservice", (Object[])new Object[0])).append(e.getMessage());
            }
        }
    }

    private void updateOther(long parent) {
        String selectFields = "id,number,org,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,isleaf,isbizunit,isstatsum,modifier,modifytime,sortcode";
        QFilter viewFilter = new QFilter("view", "=", (Object)947076820862300160L);
        QFilter noIdFilter = new QFilter("parent", "=", (Object)parent);
        QFilter[] filters = new QFilter[]{viewFilter, noIdFilter};
        DynamicObject[] orgCol = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        String parentFields = "id,org,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,isleaf,isbizunit,isstatsum,modifier,modifytime,sortcode";
        QFilter parentFilter = new QFilter("org", "=", (Object)parent);
        QFilter[] parentfilters = new QFilter[]{viewFilter, parentFilter};
        DynamicObjectCollection parentidObj = QueryServiceHelper.query((String)"bos_org_structure", (String)parentFields, (QFilter[])parentfilters);
        DynamicObject parentObject = (DynamicObject)parentidObj.get(0);
        String parentFullName = parentObject.getString("fullname");
        String parentLongnumber = parentObject.getString("longnumber");
        int parentLevel = parentObject.getInt("level");
        if (Objects.nonNull(orgCol) && orgCol.length > 0) {
            for (DynamicObject currentObj : orgCol) {
                currentObj.getDataEntityType();
                Long org = currentObj.getDynamicObject("org").getLong("id");
                String currentName = currentObj.getString("fullname");
                String currentLongnumber = currentObj.getString("longnumber");
                currentObj.set("fullname", (Object)(parentFullName + "_" + currentName));
                currentObj.set("longnumber", (Object)(parentLongnumber + "!" + currentLongnumber));
                currentObj.set("level", (Object)(parentLevel + 1));
                currentObj.set("sortcode", (Object)this.getOrgSortCode(parentLevel + 1));
                currentObj.set("modifytime", (Object)new Date());
                QFilter filter = new QFilter("parent", "=", (Object)org);
                QFilter[] qFilters = new QFilter[]{viewFilter, filter};
                if (!QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])qFilters)) {
                    currentObj.set("isleaf", (Object)Boolean.TRUE);
                    currentObj.set("isstatsum", (Object)Boolean.FALSE);
                    currentObj.set("isbizunit", (Object)Boolean.TRUE);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentObj});
                this.updateOther(org);
            }
        }
    }

    private long getOrgSortCode(int level) {
        return level * 1000000 + 1;
    }

    private void saveRoot() throws Exception {
        QFilter filter = new QFilter("id", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        DynamicObject orgStrucObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_structure");
        long id = DBUtils.getLongId((String)"bos_org_structure");
        orgStrucObj.set("id", (Object)id);
        orgStrucObj.set("masterid", (Object)id);
        orgStrucObj.set("view", (Object)947076820862300160L);
        orgStrucObj.set("org", (Object)100000L);
        orgStrucObj.set("longnumber", (Object)((DynamicObject)dynamicObjects.get(0)).getString("number"));
        orgStrucObj.set("fullname", (Object)((DynamicObject)dynamicObjects.get(0)).getString("name"));
        orgStrucObj.set("yzjorgid", (Object)"");
        orgStrucObj.set("level", (Object)1);
        orgStrucObj.set("sortcode", (Object)0);
        orgStrucObj.set("isctrlunit", (Object)1);
        orgStrucObj.set("isstatsum", (Object)Boolean.TRUE);
        orgStrucObj.set("isbizunit", (Object)Boolean.FALSE);
        orgStrucObj.set("startdate", (Object)Utils.getDate((int)0));
        orgStrucObj.set("enddate", (Object)Utils.getEndDate());
        orgStrucObj.set("status", (Object)"C");
        orgStrucObj.set("enable", (Object)"1");
        orgStrucObj.set("isleaf", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orgStrucObj});
    }

    private static String getName() {
        return ResManager.loadKDString((String)"\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u9ed8\u8ba4\u65b9\u6848", (String)"OrgViewUpgradeService_7", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
    }
}

