/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tctb.mservice.upgrade.OrgMapRelationUpgradeMServiceImpl;

public abstract class ProvisionRuleSharePlanUpgradeMServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(OrgMapRelationUpgradeMServiceImpl.class);
    private static String SHAREPLAN_INSERTSQL = "INSERT INTO t_tctb_jtgz_shareplan (fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static String SHAREPLANLANGAGE_INSERTSQL = "INSERT INTO t_tctb_jtgz_shareplan_l (fpkid,fid,flocaleid,fname) VALUES (?,?,?,?)";
    private static String RULES_INSERTSQL = "INSERT INTO t_tctb_jtgzshare_rules (fid,fentryid,fseq,frule) VALUES (?,?,?,?)";
    private static String ORGS_INSERTSQL = "INSERT INTO t_tctb_jtgzshare_orgs (fid,fentryid,fseq,forg) VALUES (?,?,?,?)";
    private UpgradeResult result = new UpgradeResult();
    private boolean success = true;
    private List<ProvisionRuleUpgradeCondition> upgradeConditions = null;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    protected String doUpgrade() {
        try {
            logger.info("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            this.upgradeConditions = this.getUpgradeConditions();
            if (this.upgradeConditions == null || this.upgradeConditions.size() == 0) {
                logger.info("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5347\u7ea7\u6761\u4ef6\u4e3a\u7a7a");
                return ResManager.loadKDString((String)"\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5347\u7ea7\u6761\u4ef6\u4e3a\u7a7a", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
            }
            for (ProvisionRuleUpgradeCondition upgradeCondition : this.upgradeConditions) {
                boolean stopCondition = this.getStopCondition(upgradeCondition);
                if (stopCondition) {
                    logger.info("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ee1\u8db3\u7ec8\u6b62\u6761\u4ef6");
                    return ResManager.loadKDString((String)"\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ee1\u8db3\u7ec8\u6b62\u6761\u4ef6", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
                }
                List<Long> ruleIds = this.getPresetRuleIds(upgradeCondition);
                if (ruleIds.size() == 0) {
                    logger.info("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230\u9884\u8bbe\u8ba1\u63d0\u89c4\u5219");
                    return ResManager.loadKDString((String)"\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230\u9884\u8bbe\u8ba1\u63d0\u89c4\u5219", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_2", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
                }
                List<Long> orgIds = this.getSharePlanOrgIds(upgradeCondition);
                if (orgIds.size() == 0) {
                    logger.info("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230\u8ba1\u63d0\u5171\u4eab\u7ec4\u7ec7");
                    return ResManager.loadKDString((String)"\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5347\u7ea7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230\u8ba1\u63d0\u5171\u4eab\u7ec4\u7ec7", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_3", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
                }
                this.generateProvisionRuleSharePlan(orgIds, ruleIds, upgradeCondition);
            }
            logger.info("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_4", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            logger.error("\u5171\u4eab\u8ba1\u63d0\u89c4\u5219\u6570\u636e\u5347\u7ea7\uff0c\u5f02\u5e38\u62a5\u9519" + e.getMessage());
            throw e;
        }
    }

    protected abstract List<ProvisionRuleUpgradeCondition> getUpgradeConditions();

    protected boolean getStopCondition(ProvisionRuleUpgradeCondition upgradeCondition) {
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append(" select 1 from t_tctb_jtgzshare_rules sharerules", new Object[0]);
        selectSql.append(" inner join t_tctb_jtgz_rules rules on sharerules.frule = rules.fid  ", new Object[0]);
        selectSql.append(" inner join t_itp_proviston_item items on rules.fprovistonitem = items.fid", new Object[0]);
        selectSql.append(" where rules.fissystem = '1'", new Object[0]);
        selectSql.append(" and ", new Object[0]);
        selectSql.appendIn("items.ftaxtype", upgradeCondition.getTaxtype().toArray());
        if (upgradeCondition.getTaxsystem().size() > 0) {
            selectSql.append(" and ", new Object[0]);
            selectSql.appendIn("items.ftaxsystem", upgradeCondition.getTaxsystem().toArray());
        }
        boolean stopCondition = (Boolean)DB.query((DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)selectSql, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return true;
                }
                return false;
            }
        });
        return stopCondition;
    }

    protected List<Long> getPresetRuleIds(ProvisionRuleUpgradeCondition upgradeCondition) {
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append(" select rules.fid as ruleid from t_tctb_jtgz_rules rules ", new Object[0]);
        selectSql.append(" inner join t_itp_proviston_item items on rules.fprovistonitem = items.fid", new Object[0]);
        selectSql.append(" where rules.fissystem = '1'", new Object[0]);
        selectSql.append(" and ", new Object[0]);
        selectSql.appendIn("items.ftaxtype", upgradeCondition.getTaxtype().toArray());
        if (upgradeCondition.getTaxsystem().size() > 0) {
            selectSql.append(" and ", new Object[0]);
            selectSql.appendIn("items.ftaxsystem", upgradeCondition.getTaxsystem().toArray());
        }
        List presetRuleIds = (List)DB.query((DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)selectSql, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet resultSet) throws Exception {
                ArrayList<Long> ruleIds = new ArrayList<Long>(10);
                while (resultSet.next()) {
                    ruleIds.add(resultSet.getLong("ruleid"));
                }
                return ruleIds;
            }
        });
        return presetRuleIds;
    }

    protected List<Long> getSharePlanOrgIds(ProvisionRuleUpgradeCondition upgradeCondition) {
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append(" select shareorgs.forg as orgid  from t_tctb_jtfashare shareplan ", new Object[0]);
        selectSql.append(" inner join t_tctb_jtfashare_rules sharerules on shareplan.fid = sharerules.fid ", new Object[0]);
        selectSql.append(" inner join t_tctb_jtfashare_orgs shareorgs on shareplan.fid = shareorgs.fid", new Object[0]);
        selectSql.append(" inner join t_itp_proviston_plan rules on sharerules.frule = rules.fid", new Object[0]);
        selectSql.append(" where ", new Object[0]);
        selectSql.appendIn("rules.ftaxtype", upgradeCondition.getTaxtype().toArray());
        if (upgradeCondition.getTaxsystem().size() > 0) {
            selectSql.append(" and ", new Object[0]);
            selectSql.appendIn("rules.ftaxsystem", upgradeCondition.getTaxsystem().toArray());
        }
        if (upgradeCondition.getTaxarea().size() > 0) {
            selectSql.append(" and ", new Object[0]);
            selectSql.appendIn("rules.ftaxarea", upgradeCondition.getTaxarea().toArray());
        }
        Set sharePlanOrgIds = (Set)DB.query((DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)selectSql, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet resultSet) throws Exception {
                HashSet<Long> orgIds = new HashSet<Long>(10);
                while (resultSet.next()) {
                    orgIds.add(resultSet.getLong("orgid"));
                }
                return orgIds;
            }
        });
        return new ArrayList<Long>(sharePlanOrgIds);
    }

    protected void generateProvisionRuleSharePlan(List<Long> orgIds, List<Long> ruleIds, ProvisionRuleUpgradeCondition upgradeCondition) {
        Long id = DB.genLongId((String)"t_tctb_jtgz_shareplan");
        String number = upgradeCondition.getNumber();
        String name = upgradeCondition.getName();
        String status = "C";
        String enable = "1";
        Long createId = RequestContext.get().getCurrUserId();
        Object[] shareplanInsertParams = new Object[]{id, number, name, status, createId, createId, enable, new Date(), null, id};
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)SHAREPLAN_INSERTSQL, (Object[])shareplanInsertParams);
        String pkid = DB.genStringId((String)"t_tctb_jtgz_shareplan_l");
        Object[] shanplanLanguageInsertParams = new Object[]{pkid, id, "zh_CN", upgradeCondition.getName()};
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)SHAREPLANLANGAGE_INSERTSQL, (Object[])shanplanLanguageInsertParams);
        long[] shareRuleIds = DB.genLongIds((String)"t_tctb_jtgzshare_rules", (int)ruleIds.size());
        ArrayList<Object[]> rulesInsertParamsList = new ArrayList<Object[]>(ruleIds.size());
        Object[] rulesInsertParams = null;
        int size = ruleIds.size();
        for (int i = 0; i < size; ++i) {
            rulesInsertParams = new Object[]{id, shareRuleIds[i], i, ruleIds.get(i)};
            rulesInsertParamsList.add(rulesInsertParams);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)RULES_INSERTSQL, rulesInsertParamsList);
        long[] shareOrgIds = DB.genLongIds((String)"t_tctb_jtgzshare_orgs", (int)orgIds.size());
        ArrayList<Object[]> orgsInsertParamsList = new ArrayList<Object[]>(orgIds.size());
        Object[] orgsInsertParams = null;
        int size2 = orgIds.size();
        for (int i = 0; i < size2; ++i) {
            orgsInsertParams = new Object[]{id, shareOrgIds[i], i, orgIds.get(i)};
            orgsInsertParamsList.add(orgsInsertParams);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)ORGS_INSERTSQL, orgsInsertParamsList);
    }

    public static class ProvisionRuleUpgradeCondition {
        String number;
        String name;
        List<Long> taxtype = new ArrayList<Long>(10);
        List<Long> taxsystem = new ArrayList<Long>(10);
        List<Long> taxarea = new ArrayList<Long>(10);

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Long> getTaxtype() {
            return this.taxtype;
        }

        public void setTaxtype(List<Long> taxtype) {
            this.taxtype = taxtype;
        }

        public List<Long> getTaxsystem() {
            return this.taxsystem;
        }

        public void setTaxsystem(List<Long> taxsystem) {
            this.taxsystem = taxsystem;
        }

        public List<Long> getTaxarea() {
            return this.taxarea;
        }

        public void setTaxarea(List<Long> taxarea) {
            this.taxarea = taxarea;
        }
    }
}

