/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.EmptyCheckUtils;

public class TaxCategoryUpgradeService
implements IUpgradeService {
    private static final int EXECUTE_LIMIT_SIZE = 500;
    private static final String ENABLE = "enable";
    private static final String T_TCTB_TAX_VER_QTSF = "t_tctb_tax_ver_qtsf";
    private static final String T_TCTB_TAX_VER_HJBHS = "t_tctb_tax_ver_hjbhs";
    private static final String DEFAULT_DATE = "2018-01-01 00:00:00";
    private static final String QTSF = "qtsf";
    private static final String HJBHS = "hjbhs";
    private static final Log logger = LogFactory.getLog(TaxCategoryUpgradeService.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(TaxCategoryUpgradeService.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade() {
        logger.info("TaxCategoryUpgradeService doUpgrade start\uff01");
        String selectMainSql = "SELECT FID,FORGID FROM T_TCTB_TAX_MAIN";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(selectMainSql, new Object[0]);
        DataSet data = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)sqlBuilder);
        ArrayList<Map<String, Object>> taxMainInfos = new ArrayList<Map<String, Object>>(500);
        while (data.hasNext()) {
            HashMap<String, Long> map = new HashMap<String, Long>(8);
            Row row = data.next();
            map.put("FID", row.getLong("FID"));
            map.put("FORGID", row.getLong("FORGID"));
            taxMainInfos.add(map);
        }
        if (EmptyCheckUtils.isEmpty(taxMainInfos)) {
            return "handler data is empty";
        }
        int count = taxMainInfos.size();
        if (count > 500) {
            int round = count / 500 + 1;
            for (int i = 0; i < round; ++i) {
                int start = 500 * i;
                int end = 500 * (i + 1);
                if (500 * (i + 1) >= count) {
                    end = count;
                }
                List<Map<String, Object>> subList = taxMainInfos.subList(start, end);
                List<Object> idList = subList.stream().map(x -> x.get("FID")).collect(Collectors.toList());
                TaxCategoryUpgradeService.handlerData(idList, subList);
            }
        } else {
            List<Object> idList = taxMainInfos.stream().map(x -> x.get("FID")).collect(Collectors.toList());
            TaxCategoryUpgradeService.handlerData(idList, taxMainInfos);
        }
        return "handler data success";
    }

    /*
     * WARNING - void declaration
     */
    private static void handlerData(List<Object> idList, List<Map<String, Object>> taxMainInfos) {
        String taxMainSql = "SELECT T1.FID FID,T1.FORGID FORGID, T2.FTAXTYPE FTAXTYPE,T2.FLEVYTYPE FLEVYTYPE,T2.FDEADLINE FDEADLINE,T2.FENABLE FENABLE FROM T_TCTB_TAX_MAIN T1 LEFT JOIN T_TCTB_CATEGORYINFO T2 ON T1.FID = T2.FID WHERE T2.FTAXTYPE IN ('qtsf','hjbhs')";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(taxMainSql, new Object[0]);
        sqlBuilder.append(" AND ", new Object[0]);
        sqlBuilder.appendIn("T1.FID", idList);
        DataSet data = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)sqlBuilder);
        ArrayList mainlist = new ArrayList(idList.size() * 3);
        while (data.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            Row row = data.next();
            map.put("id", row.getLong("FID"));
            map.put("orgid", row.getLong("FORGID"));
            map.put(ENABLE, row.getString("FENABLE"));
            map.put("taxtype", row.getString("FTAXTYPE"));
            mainlist.add(map);
        }
        ArrayList<Long> qtsfIdList = new ArrayList<Long>(idList.size());
        ArrayList<Long> hjbhsIdList = new ArrayList<Long>(idList.size());
        List<Map<String, Object>> qtsfEntryList = TaxCategoryUpgradeService.getQtsfMaps(idList, qtsfIdList);
        List<Map<String, Object>> hjbhsEntryList = TaxCategoryUpgradeService.getHjbhsMaps(idList, hjbhsIdList);
        HashMap<Object, Object> qtsfOrgVerMap = new HashMap<Object, Object>(idList.size());
        HashMap<Object, Object> hjbhsOrgVerMap = new HashMap<Object, Object>(idList.size());
        Set<Object> qtsfExistOrgids = TaxCategoryUpgradeService.getQtsfExistOrgids(qtsfOrgVerMap);
        Set<Object> hjbhsExistOrgids = TaxCategoryUpgradeService.getHjbhsExistOrgids(hjbhsOrgVerMap);
        ArrayList<Object[]> qtsfSaveList = new ArrayList<Object[]>(idList.size());
        ArrayList<Object[]> hjbhsSaveList = new ArrayList<Object[]>(idList.size());
        ArrayList<Object[]> qtsfEntrySaveList = new ArrayList<Object[]>(idList.size() * 5);
        ArrayList<Object[]> hjbhsEntrySaveList = new ArrayList<Object[]>(idList.size() * 5);
        List<Map<String, Object>> recordlist = TaxCategoryUpgradeService.getChangeRecordList(idList);
        Map<Object, List<Map>> qtsfEntryGroupList = qtsfEntryList.stream().collect(Collectors.groupingBy(x -> x.get("id")));
        Map<Object, List<Map>> hjbhsEntryGroupList = hjbhsEntryList.stream().collect(Collectors.groupingBy(x -> x.get("id")));
        long[] qtsfVerIds = DBUtils.getLongIds((String)T_TCTB_TAX_VER_QTSF, (int)taxMainInfos.size());
        long[] hjbhsVerIds = DBUtils.getLongIds((String)T_TCTB_TAX_VER_HJBHS, (int)taxMainInfos.size());
        for (int i = 0; i < taxMainInfos.size(); ++i) {
            Map<String, Object> taxMainInfo = taxMainInfos.get(i);
            long id = (Long)taxMainInfo.get("FID");
            long orgid = (Long)taxMainInfo.get("FORGID");
            String qtsfEnable = "1";
            String hjbhsEnable = "0";
            for (Map map : mainlist) {
                long mainId = (Long)map.get("id");
                if (id == mainId && Objects.equals(QTSF, map.get("taxtype"))) {
                    qtsfEnable = Objects.isNull(map.get(ENABLE)) ? "1" : (String)map.get(ENABLE);
                    continue;
                }
                if (id != mainId || !Objects.equals(HJBHS, map.get("taxtype"))) continue;
                hjbhsEnable = Objects.isNull(map.get(ENABLE)) ? "0" : (String)map.get(ENABLE);
            }
            Long qtsfModifier = 0L;
            Object var32_33 = null;
            Long hjbhsModifier = 0L;
            Date hjbhsModifyDate = null;
            for (Map<String, Object> recordMap : recordlist) {
                String mainTableid = (String)recordMap.get("mainTableid");
                if (id == Long.parseLong(mainTableid) && Objects.equals(QTSF, recordMap.get("type"))) {
                    qtsfModifier = (Long)recordMap.get("modifier");
                    Date date = (Date)recordMap.get("modifydate");
                    continue;
                }
                if (id != Long.parseLong(mainTableid) || !Objects.equals(HJBHS, recordMap.get("type"))) continue;
                hjbhsModifier = (Long)recordMap.get("modifier");
                hjbhsModifyDate = (Date)recordMap.get("modifydate");
            }
            long qtsfPkid = qtsfVerIds[i];
            if (qtsfIdList.contains(id)) {
                for (Map.Entry entry : qtsfEntryGroupList.entrySet()) {
                    List entryList = (List)entry.getValue();
                    if (!Objects.equals(id, entry.getKey())) continue;
                    boolean flag = false;
                    if (qtsfExistOrgids.add(orgid)) {
                        void var32_30;
                        qtsfSaveList.add(new Object[]{qtsfPkid, var32_30, orgid, QTSF, qtsfModifier, 1, qtsfEnable});
                        qtsfOrgVerMap.put(orgid, qtsfPkid);
                        flag = true;
                    }
                    if (!flag) continue;
                    for (int j = 0; j < entryList.size(); ++j) {
                        Map qtsfMap = (Map)entryList.get(j);
                        qtsfEntrySaveList.add(new Object[]{qtsfOrgVerMap.get(orgid), DBUtils.getLongId((String)"t_tctb_tax_ver_qtsf_e"), j + 1, qtsfMap.get("collectrate"), qtsfMap.get("collectitem"), qtsfMap.get("taxperiod"), qtsfMap.get("amountrate"), qtsfMap.get("effectivestart"), qtsfMap.get("effectiveend"), qtsfMap.get("collectsubrate")});
                    }
                }
            }
            long hjbhsPkid = hjbhsVerIds[i];
            if (!hjbhsIdList.contains(id)) continue;
            for (Map.Entry<Object, List<Map>> entry : hjbhsEntryGroupList.entrySet()) {
                List<Map> entryList = entry.getValue();
                if (!Objects.equals(id, entry.getKey())) continue;
                boolean flag = false;
                for (Map hjbhsMap : entryList) {
                    if (!hjbhsExistOrgids.add(orgid)) continue;
                    hjbhsSaveList.add(new Object[]{hjbhsPkid, hjbhsModifyDate, orgid, HJBHS, hjbhsModifier, 1, hjbhsEnable, hjbhsMap.get("cshygc"), hjbhsMap.get("acsb"), hjbhsMap.get("cxwsjzclcs"), hjbhsMap.get("shljjzclcs"), hjbhsMap.get("pollutanttype")});
                    hjbhsOrgVerMap.put(orgid, hjbhsPkid);
                    flag = true;
                }
                if (!flag) continue;
                for (int j = 0; j < entryList.size(); ++j) {
                    Map hjbhsMap;
                    hjbhsMap = entryList.get(j);
                    hjbhsEntrySaveList.add(new Object[]{hjbhsOrgVerMap.get(orgid), DBUtils.getLongId((String)"t_tctb_tax_ver_hjbhs_e"), j + 1, hjbhsMap.get("number"), hjbhsMap.get("startdate"), hjbhsMap.get("enddate"), hjbhsMap.get("remark")});
                }
            }
        }
        TaxCategoryUpgradeService.saveEntryInfo(qtsfSaveList, hjbhsSaveList, qtsfEntrySaveList, hjbhsEntrySaveList);
    }

    private static List<Map<String, Object>> getChangeRecordList(List<Object> idList) {
        String changeRecordQuery = "SELECT FENABLE,FTYPE,FMODIFIER,FMODIFYDATE,FMAINTABLEID,FTAXTYPE,FSEQ FROM T_TCTB_TAX_CHANGE_RECORD WHERE FTYPE IN('qtsf','hjbhs')";
        ArrayList<String> mainTableIds = new ArrayList<String>(idList.size());
        for (Object id : idList) {
            mainTableIds.add(String.valueOf(id));
        }
        SqlBuilder recordBuilder = new SqlBuilder();
        recordBuilder.append(changeRecordQuery, new Object[0]);
        recordBuilder.append(" AND ", new Object[0]);
        recordBuilder.appendIn("FMAINTABLEID", mainTableIds);
        ArrayList<Map<String, Object>> recordlist = new ArrayList<Map<String, Object>>(idList.size() * 3);
        try (DataSet recordData = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)recordBuilder);){
            while (recordData.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                Row row = recordData.next();
                String mainTableid = row.getString("FMAINTABLEID");
                map.put("mainTableid", mainTableid);
                map.put("modifier", row.getLong("FMODIFIER"));
                map.put("modifydate", row.getDate("FMODIFYDATE"));
                map.put("type", row.getString("FTYPE"));
                recordlist.add(map);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return recordlist;
    }

    private static void saveEntryInfo(List<Object[]> qtsfSaveList, List<Object[]> hjbhsSaveList, List<Object[]> qtsfEntrySaveList, List<Object[]> hjbhsEntrySaveList) {
        if (EmptyCheckUtils.isNotEmpty(qtsfSaveList)) {
            DBUtils.executeBatch((String)" INSERT INTO t_tctb_tax_ver_qtsf (fid,fmodifydate,forg,ftaxtype,fmodifier,fver,fenable) VALUES (?,?,?,?,?,?,?) ", qtsfSaveList);
        }
        if (EmptyCheckUtils.isNotEmpty(qtsfEntrySaveList)) {
            DBUtils.executeBatch((String)" INSERT INTO t_tctb_tax_ver_qtsf_e (fid,fentryid,fseq,fcollectrate,fcollectitem,ftaxperiod,famountrate,feffectivestart,feffectiveend,fcollectsubrate) VALUES (?,?,?,?,?,?,?,?,?,?) ", qtsfEntrySaveList);
        }
        if (EmptyCheckUtils.isNotEmpty(hjbhsSaveList)) {
            DBUtils.executeBatch((String)" INSERT INTO t_tctb_tax_ver_hjbhs (fid,fmodifydate,forg,ftaxtype,fmodifier,fver,fenable,fcshygc,facsb,fcxwsjzclcs,fshljjzclcs,fpollutanttype) VALUES (?,?,?,?,?,?,?,?,?,?,?,?) ", hjbhsSaveList);
        }
        if (EmptyCheckUtils.isNotEmpty(hjbhsEntrySaveList)) {
            DBUtils.executeBatch((String)" INSERT INTO t_tctb_tax_ver_hjbhs_e (fid,fentryid,fseq,fnumber,fstartdate,fenddate,fremark) VALUES (?,?,?,?,?,?,?) ", hjbhsEntrySaveList);
        }
    }

    private static Set<Object> getQtsfExistOrgids(Map<Object, Object> qtsfOrgVerMap) {
        String qtsfOrgQuery = "SELECT FID, FORG FROM T_TCTB_TAX_VER_QTSF";
        List qtsfOrgs = DBUtils.query((String)"taxc", (String)qtsfOrgQuery);
        for (Map qtsfOrg : qtsfOrgs) {
            qtsfOrgVerMap.put(qtsfOrg.get("FORG"), qtsfOrg.get("FID"));
        }
        return qtsfOrgs.stream().map(x -> x.get("FORG")).collect(Collectors.toSet());
    }

    private static Set<Object> getHjbhsExistOrgids(Map<Object, Object> hjbhsOrgVerMap) {
        String hjbhsOrgQuery = "SELECT FID, FORG FROM T_TCTB_TAX_VER_HJBHS";
        List hjbhsOrgs = DBUtils.query((String)"taxc", (String)hjbhsOrgQuery);
        for (Map hjbhsOrg : hjbhsOrgs) {
            hjbhsOrgVerMap.put(hjbhsOrg.get("FORG"), hjbhsOrg.get("FID"));
        }
        return hjbhsOrgs.stream().map(x -> x.get("FORG")).collect(Collectors.toSet());
    }

    private static List<Map<String, Object>> getHjbhsMaps(List<Object> idList, List<Long> hjbhsIdList) {
        String hjbhsQuery = "SELECT FID,FENTRYID,FSEQ,FSTARTDATE,FENDDATE,FSHLJJZCLCS,FACSB,FCSHYGC,FCXWSJZCLCS,FPOLLUTANTTYPE,FNUMBER,FREMARK FROM T_TCTB_HJBHS_ENTRY WHERE ";
        ArrayList<Map<String, Object>> hjbhsEntryList = new ArrayList<Map<String, Object>>(idList.size());
        SqlBuilder hjbhsBuilder = new SqlBuilder();
        hjbhsBuilder.append(hjbhsQuery, new Object[0]);
        hjbhsBuilder.appendIn("FID", idList);
        DataSet hjbhsData = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)hjbhsBuilder);
        while (hjbhsData.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            Row row = hjbhsData.next();
            hjbhsIdList.add(row.getLong("FID"));
            map.put("id", row.getLong("FID"));
            map.put("entryid", row.getLong("FENTRYID"));
            map.put("startdate", row.getDate("FSTARTDATE"));
            map.put("enddate", row.getDate("FENDDATE"));
            map.put("shljjzclcs", Objects.isNull(row.getString("FSHLJJZCLCS")) ? "0" : row.getString("FSHLJJZCLCS"));
            map.put("acsb", Objects.isNull(row.getString("FACSB")) ? "0" : row.getString("FACSB"));
            map.put("cshygc", Objects.isNull(row.getString("FCSHYGC")) ? "0" : row.getString("FCSHYGC"));
            map.put("cxwsjzclcs", Objects.isNull(row.getString("FCXWSJZCLCS")) ? "0" : row.getString("FCXWSJZCLCS"));
            map.put("pollutanttype", Objects.isNull(row.getString("FPOLLUTANTTYPE")) ? Character.valueOf(' ') : row.getString("FPOLLUTANTTYPE"));
            map.put("number", row.getString("FNUMBER"));
            map.put("remark", row.getString("FREMARK"));
            hjbhsEntryList.add(map);
        }
        return hjbhsEntryList;
    }

    private static List<Map<String, Object>> getQtsfMaps(List<Object> idList, List<Long> qtsfIdList) {
        String qtsfQuery = "SELECT FID,FENTRYID,FSEQ,FCOLLECTRATE,FTAXPERIOD,FAMOUNTRATE,FEFFECTIVESTART,FEFFECTIVEEND,FCOLLECTSUBRATE,FCOLLECTITEM FROM T_TCTB_QTSF_ENTRY WHERE ";
        ArrayList<Map<String, Object>> qtsfEntryList = new ArrayList<Map<String, Object>>(idList.size());
        SqlBuilder qtsfBuilder = new SqlBuilder();
        qtsfBuilder.append(qtsfQuery, new Object[0]);
        qtsfBuilder.appendIn("FID", idList);
        DataSet qtsfData = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)qtsfBuilder);
        while (qtsfData.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            Row row = qtsfData.next();
            qtsfIdList.add(row.getLong("FID"));
            map.put("id", row.getLong("FID"));
            map.put("entryid", row.getLong("FENTRYID"));
            map.put("collectrate", row.getLong("FCOLLECTRATE"));
            map.put("taxperiod", row.getString("FTAXPERIOD"));
            map.put("amountrate", row.getDouble("FAMOUNTRATE"));
            map.put("effectivestart", row.getDate("FEFFECTIVESTART"));
            map.put("effectiveend", row.getDate("FEFFECTIVEEND"));
            map.put("collectsubrate", row.getString("FCOLLECTSUBRATE"));
            map.put("collectitem", row.getLong("FCOLLECTITEM"));
            qtsfEntryList.add(map);
        }
        return qtsfEntryList;
    }
}

