/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class TaxInfo2CategoryEntryUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxInfo2CategoryEntryUpgradeService.class);
    private static final String INSERT_CATEGORY_SQL = "insert into t_tctb_categoryinfo(fid,fentryid,fseq,ftaxtype,fenable,fdeclareperiod) values (?,?,?,?,?,?)";
    private UpgradeResult result = new UpgradeResult();
    private boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    protected String doUpgrade() {
        logger.info("\u5347\u7ea7\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8d22\u52a1\u62a5\u8868\u62a5\u9001\u5b57\u6bb5\u79fb\u52a8\u5230\u7a0e\u79cd\u5206\u5f55\uff0c\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        this.upgradeCWBB();
        this.upgradeQHJT();
        this.upgradeZDSY();
        logger.info("\u5347\u7ea7\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8d22\u52a1\u62a5\u8868\u62a5\u9001\u5b57\u6bb5\u79fb\u52a8\u5230\u7a0e\u79cd\u5206\u5f55\uff0c\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"TaxInfo2CategoryEntryUpgradeService_0", (String)"taxc-tctb-mservice", (Object[])new Object[0]), new Object[0]);
    }

    private void upgradeCWBB() {
        String queryTaxMainSQL = "select fid,ffinancialstatement,ffinancetaxperiod from t_tctb_tax_main where ftaxationsys=1 and fid not in (select fid from t_tctb_categoryinfo where ftaxtype = 'cwbb')";
        try (DataSet taxMainDataSet = DB.queryDataSet((String)TaxInfo2CategoryEntryUpgradeService.class.getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)queryTaxMainSQL);){
            int count = taxMainDataSet.copy().count("fid", true);
            if (count == 0) {
                return;
            }
            long[] entryIds = DB.genLongIds((String)"t_tctb_categoryinfo", (int)count);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            Row row = null;
            ArrayList<Object> param = null;
            int index = 0;
            while (taxMainDataSet.hasNext()) {
                row = taxMainDataSet.next();
                param = new ArrayList<Object>(10);
                boolean financialstatement = row.getBoolean("ffinancialstatement");
                if (financialstatement) {
                    param.add(row.getLong("fid"));
                    param.add(entryIds[index]);
                    param.add(11);
                    param.add("cwbb");
                    param.add("1");
                    param.add(row.getString("ffinancetaxperiod"));
                } else {
                    param.add(row.getLong("fid"));
                    param.add(entryIds[index]);
                    param.add(11);
                    param.add("cwbb");
                    param.add("0");
                    param.add(" ");
                }
                paramList.add(param.toArray());
                ++index;
            }
            if (paramList.size() > 0) {
                List partList = Lists.partition(paramList, (int)5000);
                for (List part : partList) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_CATEGORY_SQL, (List)part);
                }
            }
        }
    }

    private void upgradeQHJT() {
        String queryTaxMainSQL = "select fid,fqhclique from t_tctb_tax_main where ftaxationsys=1 and fid not in (select fid from t_tctb_categoryinfo where ftaxtype = 'qhjt')";
        try (DataSet taxMainDataSet = DB.queryDataSet((String)TaxInfo2CategoryEntryUpgradeService.class.getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)queryTaxMainSQL);){
            int count = taxMainDataSet.copy().count("fid", true);
            if (count == 0) {
                return;
            }
            long[] entryIds = DB.genLongIds((String)"t_tctb_categoryinfo", (int)count);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            Row row = null;
            ArrayList<Object> param = null;
            int index = 0;
            while (taxMainDataSet.hasNext()) {
                row = taxMainDataSet.next();
                param = new ArrayList<Object>(10);
                boolean enableflag = row.getBoolean("fqhclique");
                if (enableflag) {
                    param.add(row.getLong("fid"));
                    param.add(entryIds[index]);
                    param.add(12);
                    param.add("qhjt");
                    param.add("1");
                    param.add(" ");
                } else {
                    param.add(row.getLong("fid"));
                    param.add(entryIds[index]);
                    param.add(12);
                    param.add("qhjt");
                    param.add("0");
                    param.add(" ");
                }
                paramList.add(param.toArray());
                ++index;
            }
            if (paramList.size() > 0) {
                List partList = Lists.partition(paramList, (int)5000);
                for (List part : partList) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_CATEGORY_SQL, (List)part);
                }
            }
        }
    }

    private void upgradeZDSY() {
        String queryTaxMainSQL = "select fid,ftras from t_tctb_tax_main where ftaxationsys=1 and fid not in (select fid from t_tctb_categoryinfo where ftaxtype = 'zdsy')";
        try (DataSet taxMainDataSet = DB.queryDataSet((String)TaxInfo2CategoryEntryUpgradeService.class.getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)queryTaxMainSQL);){
            int count = taxMainDataSet.copy().count("fid", true);
            if (count == 0) {
                return;
            }
            long[] entryIds = DB.genLongIds((String)"t_tctb_categoryinfo", (int)count);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            Row row = null;
            ArrayList<Object> param = null;
            int index = 0;
            while (taxMainDataSet.hasNext()) {
                row = taxMainDataSet.next();
                param = new ArrayList<Object>(10);
                boolean enableflag = row.getBoolean("ftras");
                if (enableflag) {
                    param.add(row.getLong("fid"));
                    param.add(entryIds[index]);
                    param.add(13);
                    param.add("zdsy");
                    param.add("1");
                    param.add(" ");
                } else {
                    param.add(row.getLong("fid"));
                    param.add(entryIds[index]);
                    param.add(13);
                    param.add("zdsy");
                    param.add("0");
                    param.add(" ");
                }
                paramList.add(param.toArray());
                ++index;
            }
            if (paramList.size() > 0) {
                List partList = Lists.partition(paramList, (int)5000);
                for (List part : partList) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)INSERT_CATEGORY_SQL, (List)part);
                }
            }
        }
    }
}

