/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tctb.mservice.upgrade.TaxMainTaxOrgEntryFieldUpgradeService;

public class TaxMainResidenttypeFieldUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxMainTaxOrgEntryFieldUpgradeService.class);
    private UpgradeResult result = new UpgradeResult();
    private boolean success = true;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    protected String doUpgrade() {
        try {
            long start;
            block29: {
                logger.info("\u7eb3\u7a0e\u4e3b\u4f53\u5c45\u6c11\u4f01\u4e1a\u7c7b\u578b\u6570\u636e\u5347\u7ea7\uff0c\u5f00\u59cb\u6267\u884c");
                start = System.currentTimeMillis();
                String upgradeRangeSql = "select fid,fentryid from t_tctb_categoryinfo where ftaxtype = 'qysds' and (fresidenttype =' ' or fresidenttype='' or fresidenttype is null)";
                try (DataSet upgradeRangeSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)upgradeRangeSql);){
                    ArrayList<Object> idList = new ArrayList<Object>(1000);
                    HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(1000);
                    while (upgradeRangeSet.hasNext()) {
                        Row row = upgradeRangeSet.next();
                        idList.add(row.get("fid"));
                        entryIdMap.put(row.getLong("fid"), row.getLong("fentryid"));
                    }
                    if (idList.size() <= 0) break block29;
                    SqlBuilder taxMainSql = new SqlBuilder();
                    taxMainSql.append(" select fid,fregistertype from t_tctb_tax_main  where", new Object[0]);
                    taxMainSql.appendIn("fid", idList);
                    try (DataSet taxMainDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)taxMainSql);){
                        String updateSql = "update t_tctb_categoryinfo set fresidenttype=? where fid = ? and  fentryid = ?";
                        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1000);
                        Object[] param = null;
                        while (taxMainDataSet.hasNext()) {
                            Row row = taxMainDataSet.next();
                            String residenttype = this.getResidenttypeByRegistertype(row.getLong("fregistertype"));
                            param = new Object[]{residenttype, row.getLong("fid"), entryIdMap.get(row.getLong("fid"))};
                            paramList.add(param);
                            if (paramList.size() != 1000) continue;
                            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, paramList);
                            paramList.clear();
                        }
                        if (paramList.size() > 0) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, paramList);
                            paramList.clear();
                        }
                    }
                }
            }
            logger.info("\u7eb3\u7a0e\u4e3b\u4f53\u5c45\u6c11\u4f01\u4e1a\u7c7b\u578b\u6570\u636e\u5347\u7ea7\uff0c\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_4", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            logger.error("\u7eb3\u7a0e\u4e3b\u4f53\u5c45\u6c11\u4f01\u4e1a\u7c7b\u578b\u6570\u636e\u5347\u7ea7\uff0c\u5f02\u5e38\u62a5\u9519" + e.getMessage());
            throw e;
        }
    }

    private String getResidenttypeByRegistertype(Long registertype) {
        if (registertype >= 350L && registertype <= 359L) {
            return "fjmqy";
        }
        return "jmqy";
    }
}

