/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class TaxMainTaxOrgEntryFieldUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxMainTaxOrgEntryFieldUpgradeService.class);
    private UpgradeResult result = new UpgradeResult();
    private boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doUpgrade() {
        try {
            logger.info("\u7eb3\u7a0e\u4e3b\u4f53\u7a0e\u52a1\u7ec4\u7ec7\u5206\u5f55\u5b57\u6bb5 \u6570\u636e\u5347\u7ea7\uff0c\u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(100);
            DataSet taxMainDataSet = null;
            DataSet taxOrgDataSet = null;
            DataSet dataSet = null;
            try {
                String taxMainDataSelectSql = "select fid as id,ftaxorg as taxorgid,ftaxationsys as taxationsysid from t_tctb_tax_main where ftaxorgentryid = 0 or ftaxorgentryid is null";
                taxMainDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)taxMainDataSelectSql);
                String taxOrgSelectSql = "select t1.forgid as orgid,t2.fentryid as entryid,t2.ftaxationsys as taxationsys  from t_bastax_taxorg t1 inner join t_bastax_taxorg_entity t2 on t1.fid = t2.fid";
                taxOrgDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)taxOrgSelectSql);
                dataSet = taxMainDataSet.join(taxOrgDataSet).on("taxorgid", "orgid").on("taxationsysid", "taxationsys").select(new String[]{"id", "entryid"}).finish();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Object[] param = new Object[]{row.getLong("entryid"), row.getLong("id")};
                    paramList.add(param);
                }
            }
            finally {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (taxMainDataSet != null) {
                    taxMainDataSet.close();
                }
                if (taxOrgDataSet != null) {
                    taxOrgDataSet.close();
                }
            }
            if (paramList.size() > 0) {
                String updateSql = "UPDATE t_tctb_tax_main SET ftaxorgentryid = ? WHERE fid = ? and ( ftaxorgentryid = 0 or ftaxorgentryid is null )";
                List partList = Lists.partition(paramList, (int)1000);
                partList.forEach(v -> DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, (List)v));
            }
            logger.info("\u7eb3\u7a0e\u4e3b\u4f53\u7a0e\u52a1\u7ec4\u7ec7\u5206\u5f55\u5b57\u6bb5\uff0c\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"ProvisionRuleSharePlanUpgradeMServiceImpl_4", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            logger.error("\u7eb3\u7a0e\u4e3b\u4f53\u7a0e\u52a1\u7ec4\u7ec7\u5206\u5f55\u5b57\u6bb5\uff0c\u5f02\u5e38\u62a5\u9519" + e.getMessage());
            throw e;
        }
    }
}

