/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.common.util.DBUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaxOfficeUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxOfficeUpgradeService.class);
    private static final Map<String, String> targetEntities2Fields = new HashMap<String, String>(){
        {
            this.put("t_tdm_tds_basic_info", "FORGID,FID");
            this.put("t_tdm_house_rental_info", "FORG,FID");
            this.put("t_tdm_fcs_basic_info", "FORG,FID");
        }
    };

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        String msg = TaxOfficeUpgradeService.update();
        result.setLog(ResManager.loadKDString((String)msg, (String)"TaxOfficeUpgradeService_0", (String)"TaxOfficeUpgradeService_0", (Object[])new Object[0]));
        return result;
    }

    public static String update() {
        try {
            for (Map.Entry<String, String> entry : targetEntities2Fields.entrySet()) {
                String sql = " SELECT " + entry.getValue() + " FROM " + entry.getKey();
                List datas = DBUtils.query((String)sql);
                HashMap<Long, List> orgId2Dyo = new HashMap<Long, List>(16);
                if (null == datas) continue;
                for (Map data : datas) {
                    Long orgId = (Long)data.get(entry.getValue().split(",")[0]);
                    List target = orgId2Dyo.getOrDefault(orgId, new ArrayList());
                    target.add((Long)data.get("FID"));
                    orgId2Dyo.put(orgId, target);
                }
                if (orgId2Dyo.size() == 0) continue;
                List taxInfoMainDatas = DBUtils.query((String)(" SELECT forgid,ftaxoffice From t_tctb_tax_main WHERE forgid IN (" + StringUtils.join((Object[])orgId2Dyo.keySet().toArray(), (String)",") + ")"));
                for (Map taxInfoMainData : taxInfoMainDatas) {
                    List targetDatas = (List)orgId2Dyo.get((Long)taxInfoMainData.get("FORGID"));
                    String updateSql = " UPDATE " + entry.getKey() + " SET ftaxauthoritydyo='" + taxInfoMainData.get("FTAXOFFICE") + "' WHERE ftaxauthoritydyo=0 and fid IN ('" + StringUtils.join((Object[])targetDatas.toArray(), (String)"','") + "')";
                    DBUtils.execute((String)updateSql);
                }
            }
            return ResManager.loadKDString((String)"\u66f4\u65b0\u7a0e\u6e90\u6570\u636e\u7a0e\u52a1\u673a\u5173\u6570\u636e\u6210\u529f", (String)"TaxOfficeUpgradeService_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }
}

