/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.PermResult;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;

public class TaxPlanPermItemUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxPlanPermItemUpgradeService.class);
    private static List<Object[]> oldEntPerItem2NewMapList = new ArrayList<Object[]>(10);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            logger.info("\u8ba1\u7a0e\u65b9\u6848\u6743\u9650\u6570\u636e\u5347\u7ea7\uff0c\u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            try {
                StringBuilder pProcessInfo = new StringBuilder();
                Method appendPermItemAuthUpgrade = PermissionServiceHelper.class.getMethod("appendPermItemAuthUpgrade", List.class, StringBuilder.class);
                PermResult upgradeResult = (PermResult)appendPermItemAuthUpgrade.invoke(null, oldEntPerItem2NewMapList, pProcessInfo);
                if (upgradeResult.isOk()) {
                    result.setSuccess(true);
                } else {
                    result.setSuccess(false);
                    result.setErrorInfo(pProcessInfo.toString());
                }
            }
            catch (NoSuchMethodException e) {
                logger.error("PermissionServiceHelper.appendPermItemAuthUpgrade\uff0c\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                this.upgradePermItemBySql();
                result.setSuccess(true);
            }
            logger.info("\u8ba1\u7a0e\u65b9\u6848\u6743\u9650\u6570\u636e\u5347\u7ea7\uff0c\u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.error("\u8ba1\u7a0e\u65b9\u6848\u6743\u9650\u6570\u636e\u5347\u7ea7-\u5347\u7ea7\u7a0b\u5e8f\u5347\u7ea7\u6267\u884c\u5f02\u5e38\u3002", (Throwable)e);
            throw new KDBizException("TaxPlanPermItemUpgradeService erro:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private void upgradePermItemBySql() {
        String bizAppId = TaxPlanPermItemUpgradeService.getBizappByNum("basedata");
        if (bizAppId == null || bizAppId.length() == 0) {
            return;
        }
        DBRoute dbRoute = DBRoute.of((String)"sys");
        ArrayList<Object[]> permitemParamList = new ArrayList<Object[]>(10);
        Object[] objects = null;
        int size = oldEntPerItem2NewMapList.size();
        for (int i = 0; i < size; ++i) {
            objects = oldEntPerItem2NewMapList.get(i);
            Object[] permitemObject = new Object[]{objects[0], objects[1], objects[2], objects[3], bizAppId};
            permitemParamList.add(permitemObject);
        }
        String userpermdetailSQL = "update t_perm_userpermdetail set FENTITYTYPEID = ?,fpermitemid = ? WHERE FENTITYTYPEID = ? and fpermitemid = ? and fbizappid=?";
        DB.executeBatch((DBRoute)dbRoute, (String)userpermdetailSQL, permitemParamList);
        String rolepermdetialSQL = "update t_perm_rolepermdetial set FENTITYTYPEID = ?,fpermitemid = ? WHERE FENTITYTYPEID = ? and fpermitemid = ? and fbizappid=?";
        DB.executeBatch((DBRoute)dbRoute, (String)rolepermdetialSQL, permitemParamList);
        String disfunpermSQL = " update t_perm_disfunperm  set FENTITYTYPEID = ?,fpermitemid = ? WHERE FENTITYTYPEID = ? and fpermitemid = ? and fbizappid=?";
        DB.executeBatch((DBRoute)dbRoute, (String)disfunpermSQL, permitemParamList);
        String bizrolepermSQL = "update t_perm_bizroleperm set FENTITYTYPEID = ?,fpermitemid = ? WHERE FENTITYTYPEID = ? and fpermitemid = ? and fbizappid=?";
        DB.executeBatch((DBRoute)dbRoute, (String)bizrolepermSQL, permitemParamList);
        String bizroledispermSQL = "update t_perm_bizroledisperm set FENTITYTYPEID = ?,fpermitemid = ? WHERE FENTITYTYPEID = ? and fpermitemid = ? and fbizappid=?";
        DB.executeBatch((DBRoute)dbRoute, (String)bizroledispermSQL, permitemParamList);
    }

    public static String getBizappByNum(String num) {
        QFilter bizappidQfilter = new QFilter("number", "=", (Object)num);
        DynamicObjectCollection bizappObj = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{bizappidQfilter});
        if (bizappObj == null || bizappObj.size() == 0) {
            return null;
        }
        return ((DynamicObject)bizappObj.get(0)).getString("id");
    }

    static {
        oldEntPerItem2NewMapList.add(new Object[]{"tctb_jtfa_shareplan_form", "0=KX5+QVF5+R", "tctb_jtfa_shareplan_form", "4715a0df000000ac", null});
    }
}

