/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxPlanUpgradeMServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxPlanUpgradeMServiceImpl.class);
    private static final String TABLE_PLAN_MAIN = "t_itp_proviston_plan";
    private static final String TABLE_PLAN_BUSINESSDIM = "t_tctb_business_dimension";
    private static final String TABLE_PLAN_SHARE = "t_tctb_jtfashare";
    private static final String TABLE_PLAN_SHARE_L = "t_tctb_jtfashare_l";
    private static final String TABLE_PLAN_ENTRY_RULE = "t_tctb_jtfashare_rules";
    private static final String TABLE_PLAN_ENTRY_ORG = "t_tctb_jtfashare_orgs";
    private static final String SQL_SELECT_EXISTPLANNUMBER = "SELECT fid, fnumber FROM t_itp_proviston_plan";
    private static final String SQL_SELECT_EXSITSHARENUMBER = "SELECT fid, fnumber FROM t_tctb_jtfashare";
    private static final String SQL_UPDATE_PLAN = "update  t_itp_proviston_plan set fplanuse =',1,' where  fplanuse = ' '";
    private static final String SQL_INSER_PLAN = "INSERT INTO t_itp_proviston_plan(fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, ftaxsystem, ftaxtype, fsystemset, fcycle, fmethod, ftaxarea, fbooktype,  fisdimprovision, fprovisiondimension, fstartdate, fenddate,  fplanuse)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_INSER_PLAN_BUSINESSDIM = "INSERT INTO t_tctb_business_dimension(fpkid, fid, fbasedataid)VALUES(?, ?, ?)";
    private static final String SQL_INSER_SHARE = "INSERT INTO t_tctb_jtfashare(fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid)VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String SQL_INSER_SHARE_L = "INSERT INTO t_tctb_jtfashare_l(fpkid, fid, flocaleid, fname)VALUES(?, ?, ?, ?);";
    private static final String SQL_INSER_SHARE_RULE = "INSERT INTO t_tctb_jtfashare_rules(fid, fentryid, fseq,  frule)VALUES(?, ?, ?, ?);";
    private static final String SQL_INSER_SHARE_ORG = "INSERT INTO t_tctb_jtfashare_orgs(fid, fentryid, fseq, forg)VALUES(?, ?, ?, ?);";
    private UpgradeResult result = new UpgradeResult();
    private boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            HashMap<Long, Long> planIdTranslate = new HashMap<Long, Long>(8);
            this.updateJtOld();
            this.updateJsOld(planIdTranslate);
            this.updateJsShare(planIdTranslate);
            this.result.setLog("taxplan update suceess!");
            this.result.setSuccess(this.success);
            return this.result;
        }
        catch (Exception e) {
            this.result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            this.result.setSuccess(false);
            this.result.setLog("taxplan update erro!");
            return this.result;
        }
    }

    private void updateJtOld() {
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_UPDATE_PLAN);
    }

    private Map<String, Long> getNumbersFromNewJsPlan() {
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)SQL_SELECT_EXISTPLANNUMBER);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String number = row.getString("fnumber");
                Long id = row.getLong("fid");
                map.put(number, id);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return map;
    }

    private Map<String, Long> getNumbersFromNewJsShare() {
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)SQL_SELECT_EXSITSHARENUMBER);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String number = row.getString("fnumber");
                Long id = row.getLong("fid");
                map.put(number, id);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return map;
    }

    private void updateJsOld(Map<Long, Long> planIdTranslate) {
        Map<String, Long> existNumbers = this.getNumbersFromNewJsPlan();
        ArrayList<Object[]> taxPlanInserList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> businessDimInserList = new ArrayList<Object[]>(10);
        this.getPlanInserParams(taxPlanInserList, businessDimInserList, existNumbers, planIdTranslate);
        if (taxPlanInserList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_INSER_PLAN, taxPlanInserList);
        }
        if (businessDimInserList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_INSER_PLAN_BUSINESSDIM, businessDimInserList);
        }
    }

    private void updateJsShare(Map<Long, Long> planIdTranslate) {
        ArrayList<Object[]> taxPlanShareInsertList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> taxPlanShareLInsertList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> planEntryInsertList = new ArrayList<Object[]>(10);
        ArrayList<Object[]> orgEntryInsertList = new ArrayList<Object[]>(10);
        this.getPlanShareInsertParams(taxPlanShareInsertList, taxPlanShareLInsertList, planEntryInsertList, orgEntryInsertList, planIdTranslate);
        if (taxPlanShareInsertList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_INSER_SHARE, taxPlanShareInsertList);
        }
        if (taxPlanShareLInsertList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_INSER_SHARE_L, taxPlanShareLInsertList);
        }
        if (planEntryInsertList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_INSER_SHARE_RULE, planEntryInsertList);
        }
        if (orgEntryInsertList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_INSER_SHARE_ORG, orgEntryInsertList);
        }
    }

    private void getPlanInserParams(List<Object[]> taxPlanInserList, List<Object[]> businessDimInserList, Map<String, Long> existNumbers, Map<Long, Long> planIdTranslate) {
        try (DataSet planDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)"select fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, ftaxtype, ftaxdimension, fstartdate, fenddate, fbusinessdimesion from t_tctb_tax_plan");){
            while (planDs.hasNext()) {
                Row row = planDs.next();
                Long oldPlanId = row.getLong("fid");
                Long planId = DB.genLongId((String)TABLE_PLAN_MAIN);
                String number = row.getString("fnumber");
                if (existNumbers.containsKey(number)) {
                    planIdTranslate.put(oldPlanId, existNumbers.get(number));
                    continue;
                }
                planIdTranslate.put(oldPlanId, planId);
                String name = " ";
                Long taxType = row.getLong("ftaxtype");
                String taxDim = this.translateTaxDim(row.getString("ftaxdimension"));
                Long businessDim = row.getLong("fbusinessdimesion");
                Date startDate = row.getDate("fstartdate");
                Date endDate = row.getDate("fenddate");
                Object enable = row.get("fenable");
                Long creator = row.getLong("fcreatorid");
                Date createTime = row.getDate("fcreatetime");
                Long modifer = row.getLong("fmodifierid");
                Date modifytime = row.getDate("fmodifytime");
                Long taxarea = 1708040530098667520L;
                String isdimprovision = StringUtil.isNotEmpty((CharSequence)taxDim) ? "1" : "0";
                Object[] planParam = new Object[]{planId, number, name, "C", creator, modifer, enable, createTime, modifytime, creator, 1, taxType, Character.valueOf('0'), "", " ", taxarea, " ", isdimprovision, taxDim, startDate, endDate, "2"};
                taxPlanInserList.add(planParam);
                if (businessDim == null || businessDim.compareTo(0L) == 0) continue;
                Object[] businessDimParam = new Object[]{DB.genLongId((String)TABLE_PLAN_BUSINESSDIM), planId, businessDim};
                businessDimInserList.add(businessDimParam);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private void getPlanShareInsertParams(List<Object[]> taxPlanShareInsertList, List<Object[]> taxPlanShareLInsertList, List<Object[]> planEntryInsertList, List<Object[]> orgEntryInsertList, Map<Long, Long> planIdTranslate) {
        Long entryId;
        Object[] params;
        Long id;
        Long oldId;
        Row row2;
        Throwable throwable;
        HashMap<Long, Long> shareIdTranslate = new HashMap<Long, Long>(8);
        Map<String, Long> existShareNumber = this.getNumbersFromNewJsShare();
        HashSet<Long> existOldShareId = new HashSet<Long>(8);
        try {
            throwable = null;
            try (DataSet shareDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)"select fid, fnumber, fname, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid from t_tctb_jsfashare");){
                while (shareDs.hasNext()) {
                    row2 = shareDs.next();
                    oldId = row2.getLong("fid");
                    id = DB.genLongId((String)TABLE_PLAN_SHARE);
                    shareIdTranslate.put(oldId, id);
                    String number = row2.getString("fnumber");
                    if (existShareNumber.containsKey(number)) {
                        existOldShareId.add(oldId);
                        continue;
                    }
                    String name = row2.getString("fname");
                    String status = row2.getString("fstatus");
                    Long creatorId = row2.getLong("fcreatorid");
                    Long modifierid = row2.getLong("fmodifierid");
                    String enable = row2.getString("fenable");
                    Date createtime = row2.getDate("fcreatetime");
                    Date modifytime = row2.getDate("fmodifytime");
                    Long masterid = row2.getLong("fmasterid");
                    Object[] params2 = new Object[]{id, number, name, status, creatorId, modifierid, enable, createtime, modifytime, masterid};
                    taxPlanShareInsertList.add(params2);
                }
            }
            catch (Throwable row2) {
                throwable = row2;
                throw row2;
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        try {
            throwable = null;
            try (DataSet shareLDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)"select fpkid, fid, flocaleid, fname from t_tctb_jsfashare_l");){
                while (shareLDs.hasNext()) {
                    row2 = shareLDs.next();
                    oldId = row2.getLong("fid");
                    if (existOldShareId.contains(oldId)) continue;
                    id = (Long)shareIdTranslate.get(oldId);
                    Long pkid = DB.genLongId((String)TABLE_PLAN_SHARE_L);
                    String localeid = row2.getString("flocaleid");
                    String name = row2.getString("fname");
                    params = new Object[]{pkid, id, localeid, name};
                    taxPlanShareLInsertList.add(params);
                }
            }
            catch (Throwable row3) {
                throwable = row3;
                throw row3;
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        try {
            throwable = null;
            try (DataSet planEntryDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)"select fid, fentryid, fseq,  frule from t_tctb_jsfashare_rules");){
                while (planEntryDs.hasNext()) {
                    row2 = planEntryDs.next();
                    oldId = row2.getLong("fid");
                    if (existOldShareId.contains(oldId)) continue;
                    id = (Long)shareIdTranslate.get(oldId);
                    entryId = DB.genLongId((String)TABLE_PLAN_ENTRY_RULE);
                    int seq = row2.getInteger("fseq");
                    Long rule = planIdTranslate.get(row2.getLong("frule"));
                    params = new Object[]{id, entryId, seq, rule};
                    planEntryInsertList.add(params);
                }
            }
            catch (Throwable row4) {
                throwable = row4;
                throw row4;
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        try {
            throwable = null;
            try (DataSet orgEntryDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)"select fid, fentryid, fseq, forg from t_tctb_jsfashare_orgs");){
                while (orgEntryDs.hasNext()) {
                    row2 = orgEntryDs.next();
                    oldId = row2.getLong("fid");
                    if (existOldShareId.contains(oldId)) continue;
                    id = (Long)shareIdTranslate.get(oldId);
                    entryId = DB.genLongId((String)TABLE_PLAN_ENTRY_ORG);
                    int seq = row2.getInteger("fseq");
                    Long org = row2.getLong("forg");
                    params = new Object[]{id, entryId, seq, org};
                    orgEntryInsertList.add(params);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private String translateTaxDim(String oldTaxDim) {
        oldTaxDim = oldTaxDim.replaceAll("1", "accountorg");
        oldTaxDim = oldTaxDim.replaceAll("2", "businessdimension");
        return oldTaxDim;
    }
}

