/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class TaxinfoTaxOfficeUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxinfoTaxOfficeUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        String msg = TaxinfoTaxOfficeUpgradeService.update();
        result.setLog(ResManager.loadKDString((String)msg, (String)"TaxinfoTaxOfficeUpgradeService_0", (String)"TaxinfoTaxOfficeUpgradeService_0", (Object[])new Object[0]));
        return result;
    }

    public static String update() {
        try {
            List nullDatas = DBUtils.query((String)" SELECT fregisteraddress,fnumber FROM t_tctb_tax_main WHERE fisentity='1' AND fregisteraddress <> ' ' AND (ftaxoffice IS NULL OR ftaxoffice='0') ");
            if (null != nullDatas) {
                List countryTaxOrganDatas;
                String updateSql;
                List target;
                String sql;
                List taxOrganDatas;
                String oldAddrId;
                HashMap<String, List> address2Dyo = new HashMap<String, List>(nullDatas.size());
                for (Map data : nullDatas) {
                    String addressId = (String)data.get("FREGISTERADDRESS");
                    List target2 = address2Dyo.getOrDefault(addressId, new ArrayList());
                    target2.add((String)data.get("FNUMBER"));
                    address2Dyo.put(addressId, target2);
                }
                HashMap<String, String> countryAddress2Dyo = new HashMap<String, String>();
                HashMap<String, String> cityAddress2Dyo = new HashMap<String, String>();
                DynamicObjectCollection addresses = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,fullname", (QFilter[])new QFilter[]{new QFilter("id", "in", address2Dyo.keySet())});
                for (DynamicObject addressDyo : addresses) {
                    String address = addressDyo.getString("fullname");
                    String[] cityAndCountry = TaxinfoTaxOfficeUpgradeService.getCityAndCountry(address);
                    cityAddress2Dyo.put(cityAndCountry[0], addressDyo.getString("id"));
                    if (StringUtil.isEmpty((CharSequence)cityAndCountry[1])) continue;
                    countryAddress2Dyo.put(cityAndCountry[1], addressDyo.getString("id"));
                }
                DynamicObjectCollection cityAddresses = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,fullname", (QFilter[])new QFilter[]{new QFilter("fullname", "in", cityAddress2Dyo.keySet())});
                DynamicObjectCollection countryAddresses = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,fullname", (QFilter[])new QFilter[]{new QFilter("fullname", "in", countryAddress2Dyo.keySet())});
                HashMap<String, List> newCityAddress2Dyo = new HashMap<String, List>();
                HashMap newCountryAddress2Dyo = new HashMap();
                for (DynamicObject country : countryAddresses) {
                    oldAddrId = (String)countryAddress2Dyo.get(country.getString("fullname"));
                    newCountryAddress2Dyo.put(country.getString("id"), address2Dyo.get(oldAddrId));
                }
                for (DynamicObject city : cityAddresses) {
                    oldAddrId = (String)cityAddress2Dyo.get(city.getString("fullname"));
                    List addressDyos = (List)address2Dyo.get(oldAddrId);
                    if (null == addressDyos) continue;
                    newCityAddress2Dyo.put(city.getString("id"), addressDyos);
                }
                if (newCityAddress2Dyo.size() != 0 && null != (taxOrganDatas = DBUtils.query((String)"sys", (String)(sql = " SELECT ftaxorganaddress,fid FROM t_bastax_taxorgan WHERE ftaxorganaddress IN (" + StringUtils.join((Object[])newCityAddress2Dyo.keySet().toArray(), (String)",") + ")")))) {
                    for (Map taxOrganData : taxOrganDatas) {
                        if (null == taxOrganData.get("FTAXORGANADDRESS") || null == (target = (List)newCityAddress2Dyo.get(String.valueOf(taxOrganData.get("FTAXORGANADDRESS"))))) continue;
                        updateSql = " UPDATE t_tctb_tax_main SET ftaxoffice='" + taxOrganData.get("FID") + "' WHERE fnumber IN ('" + StringUtils.join((Object[])target.toArray(), (String)"','") + "')";
                        DBUtils.execute((String)updateSql);
                    }
                }
                if (newCountryAddress2Dyo.size() != 0 && null != (countryTaxOrganDatas = DBUtils.query((String)"sys", (String)(sql = " SELECT ftaxorganaddress,fid FROM t_bastax_taxorgan WHERE ftaxorganaddress IN (" + StringUtils.join((Object[])newCountryAddress2Dyo.keySet().toArray(), (String)",") + ")")))) {
                    for (Map taxOrganData : countryTaxOrganDatas) {
                        if (null == taxOrganData.get("FTAXORGANADDRESS") || null == (target = (List)newCountryAddress2Dyo.get(String.valueOf(taxOrganData.get("FTAXORGANADDRESS"))))) continue;
                        updateSql = " UPDATE t_tctb_tax_main SET ftaxoffice='" + taxOrganData.get("FID") + "' WHERE fnumber IN ('" + StringUtils.join((Object[])target.toArray(), (String)"','") + "')";
                        DBUtils.execute((String)updateSql);
                    }
                }
            }
            return ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u66f4\u65b0\u7a0e\u52a1\u673a\u5173\u6210\u529f", (String)"TaxinfoTaxOfficeUpgradeService_1", (String)"taxc-tctb-mservice", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.toString() + "====" + e.getMessage() + "=====" + Arrays.toString(e.getStackTrace());
        }
    }

    private static String[] getCityAndCountry(String address) {
        if (StringUtil.isEmpty((CharSequence)address)) {
            return new String[]{address, ""};
        }
        String[] res = new String[2];
        String[] parts = address.split("_");
        if (parts.length <= 2) {
            res[0] = address;
        } else {
            res[0] = parts[0] + "_" + parts[1];
            res[1] = res[0] + "_" + parts[2];
        }
        return res;
    }
}

