/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.mservice.upgrade;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.common.util.DBUtils;

public class TcvatDraftMainUpgradeService
implements IUpgradeService {
    private static final String DRAFTMAIN_ISMODIFIED_DATA_UPGRADE_SUCCESS = "TCVAT DRAFTMAIN ISMODIFIED DATA Upgrade SUCCESS!";
    private static final String CHECK_DRAFT_EDIT = "select fid FROM t_tctb_draft_main where fismodified = '1' and fdrafttype = 'zzs'";
    private static final String QUERY_EDIT_DRAFT = "select distinct fdraftnumber from t_tcvat_draft_edit ttde";
    private static final String UPDATE_DRAFT_MAIN = "update t_tctb_draft_main set fismodified = 1 where fbillno in (%s)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = DRAFTMAIN_ISMODIFIED_DATA_UPGRADE_SUCCESS;
        String info = DRAFTMAIN_ISMODIFIED_DATA_UPGRADE_SUCCESS;
        try {
            this.update();
        }
        catch (Exception var9) {
            info = log = this.getStackTraceMessage(var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List checkTargetData = DBUtils.query((String)CHECK_DRAFT_EDIT);
        if (!CollectionUtils.isEmpty((Collection)checkTargetData)) {
            return;
        }
        List sourceData = DBUtils.query((String)QUERY_EDIT_DRAFT);
        if (CollectionUtils.isEmpty((Collection)sourceData)) {
            return;
        }
        HashSet<String> draftNumberSet = new HashSet<String>(sourceData.size());
        for (Map sourceEntry : sourceData) {
            draftNumberSet.add("'" + sourceEntry.get("FDRAFTNUMBER") + "'");
        }
        if (!CollectionUtils.isEmpty(draftNumberSet)) {
            DBUtils.execute((String)String.format(UPDATE_DRAFT_MAIN, StringUtils.join((Object[])draftNumberSet.toArray(), (String)",")));
        }
    }

    private String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

