/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.bosorg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgParam;
import kd.bos.service.ServiceFactory;

public class BosOrgService {
    private static final Log logger = LogFactory.getLog(BosOrgService.class);

    public boolean addOrUpdate(Long orgId, String taxpayerType, String effectiveDate) {
        try {
            ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>(8);
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId.longValue());
            HashMap<String, String> propertyMap = new HashMap<String, String>(8);
            if (Objects.equals("ybnsr", taxpayerType)) {
                propertyMap.put("taxpayertype", "1");
            } else if (Objects.equals("xgmnsr", taxpayerType)) {
                propertyMap.put("taxpayertype", "2");
            }
            orgParam.setPropertyMap(propertyMap);
            orgParams.add(orgParam);
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            orgService.addOrUpdate(orgParams);
            for (OrgParam result : orgParams) {
                if (result.isSuccess()) continue;
                return false;
            }
        }
        catch (Exception e) {
            logger.error("BosOrgService addOrUpdate cause exception\uff1a", (Throwable)e);
        }
        return true;
    }
}

