/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.enums.provision;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum TaxPlanCfgEnum {
    JT_001_001("1", "001", "001"),
    JT_001_003("1", "001", "003"),
    JT_001_008("1", "001", "008"),
    JT_001_007("1", "001", "007"),
    JT_001_009("1", "001", "009"),
    JT_001_018("1", "001", "018"),
    JT_001_011("1", "001", "011"),
    JT_001_022("1", "001", "022"),
    JT_001_023("1", "001", "023"),
    JT_001_024("1", "001", "024"),
    JT_001_025("1", "001", "025"),
    JT_001_026("1", "001", "026"),
    JT_001_027("1", "001", "027"),
    JT_001_034("1", "001", "034"),
    JT_001_036("1", "001", "036"),
    JT_AUS_AUS_CIT("1", "AUS", "AUS-CIT"),
    JT_AUS_AUS_GST("1", "AUS", "AUS-GST"),
    JT_DEU_DEU_SS("1", "DEU", "DEU-SS"),
    JT_DEU_DEU_TT("1", "DEU", "DEU-TT"),
    JT_DEU_DEU_CIT("1", "DEU", "DEU-CIT"),
    JT_DEU_DEU_VAT("1", "DEU", "DEU-VAT"),
    JT_USA_USA_CIT("1", "USA", "USA-CIT"),
    JT_USA_USA_FT("1", "USA", "USA-FT"),
    JT_USA_USA_SUT("1", "USA", "USA-SUT"),
    JT_USA_USA_GRT("1", "USA", "USA-GRT"),
    JT_JAP_JAP_LCIT("1", "JAP", "JAP-LCIT"),
    JT_JAP_JAP_IT_1("1", "JAP", "JAP-IT-1"),
    JT_JAP_JAP_IT_2("1", "JAP", "JAP-IT-2"),
    JT_JAP_JAP_ET("1", "JAP", "JAP-ET"),
    JT_JAP_JAP_SET("1", "JAP", "JAP-SET"),
    JT_JAP_JAP_CIT("1", "JAP", "JAP-CIT"),
    JT_JAP_JAP_CT("1", "JAP", "JAP-CT"),
    JT_SGP_SGP_CIT("1", "SGP", "SGP-CIT"),
    JT_SGP_SGP_GST("1", "SGP", "SGP-GST"),
    JT_GBR_GBR_CIT("1", "GBR", "GBR-CIT"),
    JT_GBR_GBR_VAT("1", "GBR", "GBR-VAT"),
    JT_HKG_HKG_CIT("1", "HKG", "HKG-CIT"),
    JS_001_001("2", "001", "001"),
    JS_001_007("2", "001", "007"),
    JS_001_009("2", "001", "009"),
    JS_001_011("2", "001", "011"),
    JTJS_001_001("1&2", "001", "001");

    private String planuseCode;
    private String taxsysCode;
    private String taxtypeCode;

    private TaxPlanCfgEnum(String planuseCode, String taxsysCode, String taxtypeCode) {
        this.planuseCode = planuseCode;
        this.taxsysCode = taxsysCode;
        this.taxtypeCode = taxtypeCode;
    }

    public String getPlanuseCode() {
        return this.planuseCode;
    }

    public String getTaxsysCode() {
        return this.taxsysCode;
    }

    public String getTaxtypeCode() {
        return this.taxtypeCode;
    }

    public static TaxPlanCfgEnum valueOf(String planuseCode, String taxsysCode, String taxtypeCode) {
        Optional<TaxPlanCfgEnum> op = Arrays.stream(TaxPlanCfgEnum.values()).filter(item -> item.getPlanuseCode().equals(TaxPlanCfgEnum.formatPlanUse(planuseCode)) && item.getTaxsysCode().equals(taxsysCode) && item.getTaxtypeCode().equals(taxtypeCode)).findFirst();
        return op.isPresent() ? op.get() : null;
    }

    public static List<TaxPlanCfgEnum> getByPlanuse(String planuseCode) {
        return Arrays.stream(TaxPlanCfgEnum.values()).filter(item -> item.getPlanuseCode().equals(TaxPlanCfgEnum.formatPlanUse(planuseCode))).collect(Collectors.toList());
    }

    public static List<TaxPlanCfgEnum> getByPlanuseAndTaxsys(String planuseCode, String taxsysCode) {
        return TaxPlanCfgEnum.getByPlanuse(TaxPlanCfgEnum.formatPlanUse(planuseCode)).stream().filter(item -> item.getTaxsysCode().equals(taxsysCode)).collect(Collectors.toList());
    }

    public static String formatPlanUse(String planuseCode) {
        if (planuseCode == null) {
            return null;
        }
        if (planuseCode.contains("1") && planuseCode.contains("2")) {
            planuseCode = "1&2";
        } else if (planuseCode.contains("1")) {
            planuseCode = "1";
        } else if (planuseCode.contains("2")) {
            planuseCode = "2";
        }
        return planuseCode;
    }
}

