/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.enums.szyh;

import kd.bos.dataentity.entity.DynamicObject;
import org.apache.commons.lang3.StringUtils;

public enum TaxTypeAsZspmEnums {
    WHSYJSF("026", "1527638834936912896"),
    CJRJYBZJ("027", "1494965873226903552");

    private String taxType;
    private String zspmId;

    private TaxTypeAsZspmEnums(String taxType, String zspmId) {
        this.taxType = taxType;
        this.zspmId = zspmId;
    }

    public String getTaxType() {
        return this.taxType;
    }

    public String getZspmId() {
        return this.zspmId;
    }

    public static String getIdByTaxTypeNumber(String taxTypeNumber) {
        for (TaxTypeAsZspmEnums type : TaxTypeAsZspmEnums.values()) {
            if (!type.getTaxType().equals(taxTypeNumber)) continue;
            return type.getZspmId();
        }
        return "";
    }

    public static String getZspmIdByDynamicObject(DynamicObject dynamicObject) {
        DynamicObject zspm = dynamicObject.getDynamicObject("zspm");
        if (zspm == null) {
            return "";
        }
        String zspmId = zspm.getString("id");
        String tatyZspmId = TaxTypeAsZspmEnums.getIdByTaxTypeNumber(dynamicObject.getDynamicObject("zsxm").getString("number"));
        if (StringUtils.isNotBlank((CharSequence)tatyZspmId)) {
            zspmId = tatyZspmId;
        }
        return zspmId;
    }
}

