/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.message;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.metadata.MetadataUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.FilterBuilderUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.message.IMessageFilterDataSource;
import kd.taxc.tctb.business.message.RemindTaskRequest;
import kd.taxc.tctb.business.message.RiskReminderTaskDto;
import kd.taxc.tctb.business.org.OrgService;

public class FxlMessageFilterDataSourceImpl
implements IMessageFilterDataSource {
    private static final Log logger = LogFactory.getLog(FxlMessageFilterDataSourceImpl.class);
    public static final String TCTRC_RISK_RUN_RESULT = "tctrc_risk_run_result";
    private OrgService orgService = new OrgService();

    @Override
    public Map<Long, Map<String, List<DynamicObject>>> filterDataSource(DynamicObject task) {
        Map<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        DynamicObjectCollection ruleentryentity = task.getDynamicObjectCollection("ruleentryentity");
        if (ruleentryentity == null || ruleentryentity.isEmpty()) {
            return result;
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<DynamicObject>>(16);
        for (int i = 0; i < ruleentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)ruleentryentity.get(i);
            DynamicObject table = dynamicObject.getDynamicObject("table");
            String tableName = table.getString("name");
            String conditionjson = dynamicObject.getString("conditionjson");
            QFilter qFilter = FilterBuilderUtils.buildFilter((String)this.parseNDayFilter(conditionjson), (String)tableName);
            qFilter.and(new QFilter("risk.risktype", "=", (Object)"1"));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)tableName, (String)MetadataUtil.getAllSubFieldString((String)tableName), (QFilter[])new QFilter[]{qFilter}, (String)"startdate asc");
            logger.info("\u6700\u521d\u59cb\u6570\u636e\u603b\u6761\u6570\u4e3a: " + load.length);
            if (EmptyCheckUtils.isNotEmpty((Object)load)) {
                List resultList = Arrays.stream(load).filter(this::checkZeroAndLessthanZero).collect(Collectors.toList());
                logger.info("\u81ea\u7136\u5e74\u51850\u7533\u62a5\u6216\u8005\u8d1f\u7533\u62a5\u6570\u636e\u6761\u6570\u4e3a: " + resultList.size());
                map.put(tableName, new ArrayList(resultList));
                continue;
            }
            map = new HashMap(16);
        }
        result = this.mergeMap(map);
        this.removeNoData(result, ruleentryentity);
        for (Map.Entry<Long, Map<String, List<DynamicObject>>> entry : result.entrySet()) {
            Map<String, List<DynamicObject>> values = entry.getValue();
            for (Map.Entry<String, List<DynamicObject>> entry1 : values.entrySet()) {
                List<DynamicObject> resultList = entry1.getValue();
                if (resultList.size() >= 5) {
                    logger.info("\u81ea\u7136\u5e74\u51850\u7533\u62a5\u6216\u8005\u8d1f\u7533\u62a5\u6570\u636e\u6761\u6570\u5927\u4e8e\u7b49\u4e8e5\u6761\uff0c\u4e3a " + resultList.size());
                    continue;
                }
                logger.info("\u81ea\u7136\u5e74\u51850\u7533\u62a5\u6216\u8005\u8d1f\u7533\u62a5\u6570\u636e\u6761\u6570\u5c0f\u4e8e5\u6761\uff0c\u4e3a " + resultList.size());
                HashMap<Date, DynamicObject> tempMap = new HashMap<Date, DynamicObject>(16);
                for (DynamicObject dynamic : resultList) {
                    tempMap.put(dynamic.getDate("startdate"), dynamic);
                }
                boolean isflag = false;
                ArrayList<DynamicObject> allList = new ArrayList<DynamicObject>(16);
                for (DynamicObject dynamic : resultList) {
                    DynamicObject dy = (DynamicObject)tempMap.get(DateUtils.addMonth((Date)dynamic.getDate("startdate"), (int)1));
                    if (!EmptyCheckUtils.isNotEmpty((Object)dy)) continue;
                    isflag = true;
                    allList.add(dynamic);
                    allList.add(dy);
                    DynamicObject dy3 = (DynamicObject)tempMap.get(DateUtils.addMonth((Date)dynamic.getDate("startdate"), (int)2));
                    if (!EmptyCheckUtils.isNotEmpty((Object)dy3)) continue;
                    allList.add(dy3);
                    DynamicObject dy4 = (DynamicObject)tempMap.get(DateUtils.addMonth((Date)dynamic.getDate("startdate"), (int)3));
                    if (!EmptyCheckUtils.isNotEmpty((Object)dy4)) continue;
                    allList.add(dy4);
                    break;
                }
                if (isflag) {
                    logger.info("\u81ea\u7136\u5e74\u51850\u7533\u62a5\u6216\u8005\u8d1f\u7533\u62a5\u6570\u636e\u5b58\u5728\u4e24\u4e2a\u6216\u8005\u4ee5\u4e0a\u8fde\u7eed,\u65f6\u95f4\u5206\u522b\u4e3a:" + allList.stream().distinct().map(s -> s.getDate("startdate")).collect(Collectors.toList()));
                    resultList.clear();
                    resultList.addAll(allList.stream().distinct().collect(Collectors.toList()));
                    continue;
                }
                logger.info("\u81ea\u7136\u5e74\u51850\u7533\u62a5\u6216\u8005\u8d1f\u7533\u62a5\u6570\u636e\u4e0d\u5b58\u5728\u4e24\u4e2a\u6216\u8005\u4ee5\u4e0a\u8fde\u7eed");
                resultList.clear();
            }
        }
        return result;
    }

    private void removeNoData(Map<Long, Map<String, List<DynamicObject>>> result, DynamicObjectCollection ruleentryentity) {
        Iterator<Map.Entry<Long, Map<String, List<DynamicObject>>>> iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<String, List<DynamicObject>>> entry = iterator.next();
            Map<String, List<DynamicObject>> value = entry.getValue();
            if (value.size() == ruleentryentity.size()) continue;
            iterator.remove();
        }
    }

    private boolean checkZeroAndLessthanZero(DynamicObject s) {
        int endYear;
        Date startDate = s.getDate("startDate");
        Date endDate = s.getDate("endDate");
        int startYear = DateUtils.getYearOfDate((Date)startDate);
        return startYear == (endYear = DateUtils.getYearOfDate((Date)endDate)) && (EmptyCheckUtils.isEmpty((Object)s.getString("result")) || this.isNotNullNumber(s) && s.getBigDecimal("result").compareTo(BigDecimal.ZERO) <= 0);
    }

    private boolean isNotNullNumber(DynamicObject s) {
        return EmptyCheckUtils.isNotEmpty((Object)s.getString("result")) && !"null".equals(s.getString("result")) && StringUtil.isNumeric((String)s.getString("result"));
    }

    private String parseNDayFilter(String conditionjson) {
        FilterCondition filterCondition = FilterBuilderUtils.buildFilterCondition((String)conditionjson);
        boolean parse = false;
        for (SimpleFilterRow simpleFilterRow : filterCondition.getFilterRow()) {
            if (!CompareTypeEnum.LASTNDAYS.getId().equals(simpleFilterRow.getCompareType())) continue;
            String nday = (String)((FilterValue)simpleFilterRow.getValue().get(0)).getValue();
            simpleFilterRow.setCompareType(CompareTypeEnum.LESSOREQUAL.getId());
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)DateUtils.addDay((Date)new Date(), (int)Integer.parseInt(nday)));
            simpleFilterRow.setValue(Collections.singletonList(filterValue));
            parse = true;
        }
        return parse ? this.filterConditionToJson(filterCondition) : conditionjson;
    }

    private String filterConditionToJson(FilterCondition filterCondition) {
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        return SerializationUtils.toJsonString((Object)filterConditionMap);
    }

    private Map<Long, Map<String, List<DynamicObject>>> mergeMap(Map<String, List<DynamicObject>> map) {
        HashMap<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String tableName = entry.getKey();
            List<DynamicObject> values = entry.getValue();
            for (DynamicObject dynamicObject : values) {
                Map<String, ArrayList> innerMap;
                long orgId = dynamicObject.getDynamicObject("runorg").getLong("id");
                if (!result.containsKey(orgId)) {
                    innerMap = new HashMap<String, ArrayList>(16);
                    innerMap.put(tableName, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                    result.put(orgId, innerMap);
                    continue;
                }
                innerMap = (Map)result.get(orgId);
                List list = (List)innerMap.get(tableName);
                if (list == null) {
                    innerMap.put(tableName, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                    continue;
                }
                list.add(dynamicObject);
            }
        }
        return result;
    }

    @Override
    public Set<Long> getMessageReceiver(Long orgId, DynamicObject task) {
        HashSet<Long> result = new HashSet<Long>();
        String roletype = task.getString("roletype");
        DynamicObjectCollection ccusers = task.getDynamicObjectCollection("ccuser");
        if (!CollectionUtils.isEmpty((Collection)ccusers)) {
            ccusers.stream().forEach(s -> result.add(s.getLong("fbasedataid_id")));
        }
        if ("common".equals(roletype)) {
            DynamicObjectCollection commsysrole = task.getDynamicObjectCollection("commsysrole");
            if (!CollectionUtils.isEmpty((Collection)commsysrole)) {
                List commsysroleIds = commsysrole.stream().map(s -> s.getString("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"perm_userrole", (String)"user.id as userId", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("role", "in", commsysroleIds)});
                if (!CollectionUtils.isEmpty((Collection)userObjs)) {
                    userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
                }
            }
        } else if ("biz".equals(roletype)) {
            DynamicObjectCollection bizsysrole = task.getDynamicObjectCollection("bizsysrole");
            if (!CollectionUtils.isEmpty((Collection)bizsysrole)) {
                DynamicObjectCollection userObjs;
                List bizsysroleIds = bizsysrole.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection bizRoleObjs = QueryServiceHelper.query((String)"perm_bizrole", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizroleorg.org.id", "=", (Object)orgId), new QFilter("id", "in", bizsysroleIds)});
                if (!CollectionUtils.isEmpty((Collection)bizRoleObjs)) {
                    bizsysroleIds = bizRoleObjs.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty((Collection)(userObjs = QueryServiceHelper.query((String)"perm_userbizrole", (String)"user.id as userId", (QFilter[])new QFilter[]{new QFilter("bizrole", "in", bizsysroleIds)})))) {
                    userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
                }
            }
        } else if ("position".equals(roletype)) {
            List<String> names = this.orgService.getPersonNames(orgId, roletype);
            DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", names)});
            if (!CollectionUtils.isEmpty((Collection)userObjs)) {
                userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
            }
        }
        return result;
    }

    @Override
    public List<? super RemindTaskRequest> buildRemindTaskDto(Long orgId, DynamicObject task, Map<String, List<DynamicObject>> values) {
        logger.info("\u8fdb\u5165\u53d1\u9001\u901a\u77e5\u7ec4\u88c5\u6570\u636e\u9636\u6bb5\u5f00\u59cb\u524d: \u7ec4\u7ec7\u4e3a:" + orgId);
        ArrayList<RiskReminderTaskDto> list = new ArrayList<RiskReminderTaskDto>(16);
        if (!values.containsKey(TCTRC_RISK_RUN_RESULT)) {
            return list;
        }
        List<DynamicObject> dynamicObjects = values.get(TCTRC_RISK_RUN_RESULT);
        for (DynamicObject dynamicObject : dynamicObjects) {
            RiskReminderTaskDto remindTaskDto = new RiskReminderTaskDto();
            remindTaskDto.setTaskId(task.getLong("id"));
            remindTaskDto.setOrgId(String.valueOf(orgId));
            remindTaskDto.setRemindType(task.getString("remindtype"));
            remindTaskDto.setOrgName(Optional.ofNullable(dynamicObject.getDynamicObject("runorg")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setOrgNumber(Optional.ofNullable(dynamicObject.getDynamicObject("runorg")).map(s -> s.getString("number")).orElse(""));
            remindTaskDto.setSkssqq(DateUtils.format((Date)dynamicObject.getDate("startdate")));
            remindTaskDto.setSkssqz(DateUtils.format((Date)dynamicObject.getDate("enddate")));
            remindTaskDto.setRiskName(Optional.ofNullable(dynamicObject.getDynamicObject("risk")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setRiskNumber(Optional.ofNullable(dynamicObject.getDynamicObject("risk")).map(s -> s.getString("number")).orElse(""));
            list.add(remindTaskDto);
            logger.info("\u53d1\u9001\u901a\u77e5\u7ec4\u88c5\u6570\u636e\u9636\u6bb5\u8fdb\u884c\u4e2d: \u7ec4\u7ec7\u4e3a:" + orgId + ",taskid:" + task.getLong("id") + ",remindType:" + task.getString("remindtype") + ",startdate:" + DateUtils.format((Date)dynamicObject.getDate("startdate")) + ",enddate:" + DateUtils.format((Date)dynamicObject.getDate("enddate")) + ",riskName:" + Optional.ofNullable(dynamicObject.getDynamicObject("risk")).map(s -> s.getString("name")).orElse("") + ",riskNumber:" + Optional.ofNullable(dynamicObject.getDynamicObject("risk")).map(s -> s.getString("name")).orElse(""));
        }
        logger.info("\u8fdb\u5165\u53d1\u9001\u901a\u77e5\u7ec4\u88c5\u6570\u636e\u9636\u6bb5\u7ed3\u675f\u540e: \u7d2f\u8ba1\u9700\u8981\u53d1\u9001\u7684\u6570\u636e\u6761\u6570\u4e3a:" + list.size());
        return list;
    }

    private static Map<String, List<ValueMapItem>> getAllComboitems() {
        HashMap<String, List<ValueMapItem>> map = new HashMap<String, List<ValueMapItem>>(16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)TCTRC_RISK_RUN_RESULT);
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            if (property instanceof BillStatusProp) {
                map.put(property.getName(), ((BillStatusProp)property).getComboItems());
            }
            if (!(property instanceof ComboProp)) continue;
            map.put(property.getName(), ((ComboProp)property).getComboItems());
        }
        return map;
    }
}

