/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.message;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.FilterBuilderUtils;
import kd.taxc.tctb.business.message.IMessageFilterDataSource;
import kd.taxc.tctb.business.message.RemindTaskDto;
import kd.taxc.tctb.business.message.RemindTaskRequest;
import kd.taxc.tctb.business.org.OrgService;

public class NssbMessageFilterDataSourceImpl
implements IMessageFilterDataSource {
    public static final String BDTAXR_TAXABLE_LISTING = "bdtaxr_taxable_listing";
    public static Map<String, List<ValueMapItem>> allComboitems = NssbMessageFilterDataSourceImpl.getAllComboitems();
    private OrgService orgService = new OrgService();

    @Override
    public Map<Long, Map<String, List<DynamicObject>>> filterDataSource(DynamicObject task) {
        Map<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        DynamicObjectCollection ruleentryentity = task.getDynamicObjectCollection("ruleentryentity");
        if (ruleentryentity == null || ruleentryentity.isEmpty()) {
            return result;
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<DynamicObject>>(16);
        List<Object> lastOrgIds = new ArrayList();
        for (int i = 0; i < ruleentryentity.size(); ++i) {
            DynamicObject[] load;
            DynamicObject dynamicObject = (DynamicObject)ruleentryentity.get(i);
            DynamicObject table = dynamicObject.getDynamicObject("table");
            String tableName = table.getString("name");
            String conditionjson = dynamicObject.getString("conditionjson");
            QFilter qFilter = FilterBuilderUtils.buildFilter((String)this.parseNDayFilter(conditionjson), (String)tableName);
            if (i > 0) {
                qFilter.and(new QFilter("org.id", "in", lastOrgIds));
            }
            if ((load = BusinessDataServiceHelper.load((String)tableName, (String)MetadataUtil.getAllSubFieldString((String)tableName), (QFilter[])new QFilter[]{qFilter})) != null && load.length > 0) {
                lastOrgIds = Arrays.stream(load).map(s -> s.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
                map.put(tableName, Arrays.stream(load).collect(Collectors.toList()));
                continue;
            }
            map = new HashMap(16);
        }
        result = this.mergeMap(map);
        Iterator<Map.Entry<Long, Map<String, List<DynamicObject>>>> iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<String, List<DynamicObject>>> entry = iterator.next();
            Map<String, List<DynamicObject>> value = entry.getValue();
            if (value.size() == ruleentryentity.size()) continue;
            iterator.remove();
        }
        return result;
    }

    private String parseNDayFilter(String conditionjson) {
        FilterCondition filterCondition = FilterBuilderUtils.buildFilterCondition((String)conditionjson);
        boolean parse = false;
        for (SimpleFilterRow simpleFilterRow : filterCondition.getFilterRow()) {
            if (!CompareTypeEnum.LASTNDAYS.getId().equals(simpleFilterRow.getCompareType())) continue;
            String nday = (String)((FilterValue)simpleFilterRow.getValue().get(0)).getValue();
            simpleFilterRow.setCompareType(CompareTypeEnum.LESSOREQUAL.getId());
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)DateUtils.addDay((Date)new Date(), (int)Integer.parseInt(nday)));
            simpleFilterRow.setValue(Collections.singletonList(filterValue));
            parse = true;
        }
        return parse ? this.filterConditionToJson(filterCondition) : conditionjson;
    }

    private String filterConditionToJson(FilterCondition filterCondition) {
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        return SerializationUtils.toJsonString((Object)filterConditionMap);
    }

    private Map<Long, Map<String, List<DynamicObject>>> mergeMap(Map<String, List<DynamicObject>> map) {
        HashMap<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String tableName = entry.getKey();
            List<DynamicObject> values = entry.getValue();
            for (DynamicObject dynamicObject : values) {
                Map<String, ArrayList> innerMap;
                long orgId = dynamicObject.getDynamicObject("org").getLong("id");
                if (!result.containsKey(orgId)) {
                    innerMap = new HashMap<String, ArrayList>(16);
                    innerMap.put(tableName, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                    result.put(orgId, innerMap);
                    continue;
                }
                innerMap = (Map)result.get(orgId);
                List list = (List)innerMap.get(tableName);
                if (list == null) {
                    innerMap.put(tableName, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                    continue;
                }
                list.add(dynamicObject);
            }
        }
        return result;
    }

    @Override
    public Set<Long> getMessageReceiver(Long orgId, DynamicObject task) {
        HashSet<Long> result = new HashSet<Long>();
        String roletype = task.getString("roletype");
        DynamicObjectCollection ccusers = task.getDynamicObjectCollection("ccuser");
        if (!CollectionUtils.isEmpty((Collection)ccusers)) {
            ccusers.stream().forEach(s -> result.add(s.getLong("fbasedataid_id")));
        }
        if ("common".equals(roletype)) {
            DynamicObjectCollection commsysrole = task.getDynamicObjectCollection("commsysrole");
            if (!CollectionUtils.isEmpty((Collection)commsysrole)) {
                List commsysroleIds = commsysrole.stream().map(s -> s.getString("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"perm_userrole", (String)"user.id as userId", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("role", "in", commsysroleIds)});
                if (!CollectionUtils.isEmpty((Collection)userObjs)) {
                    userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
                }
            }
        } else if ("biz".equals(roletype)) {
            DynamicObjectCollection bizsysrole = task.getDynamicObjectCollection("bizsysrole");
            if (!CollectionUtils.isEmpty((Collection)bizsysrole)) {
                DynamicObjectCollection userObjs;
                List bizsysroleIds = bizsysrole.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection bizRoleObjs = QueryServiceHelper.query((String)"perm_bizrole", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizroleorg.org.id", "=", (Object)orgId), new QFilter("id", "in", bizsysroleIds)});
                if (!CollectionUtils.isEmpty((Collection)bizRoleObjs)) {
                    bizsysroleIds = bizRoleObjs.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty((Collection)(userObjs = QueryServiceHelper.query((String)"perm_userbizrole", (String)"user.id as userId", (QFilter[])new QFilter[]{new QFilter("bizrole", "in", bizsysroleIds)})))) {
                    userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
                }
            }
        } else if ("position".equals(roletype)) {
            List<String> names = this.orgService.getPersonNames(orgId, roletype);
            DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", names)});
            if (!CollectionUtils.isEmpty((Collection)userObjs)) {
                userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
            }
        }
        return result;
    }

    @Override
    public List<? super RemindTaskRequest> buildRemindTaskDto(Long orgId, DynamicObject task, Map<String, List<DynamicObject>> values) {
        ArrayList<RemindTaskDto> list = new ArrayList<RemindTaskDto>(16);
        if (!values.containsKey(BDTAXR_TAXABLE_LISTING)) {
            return list;
        }
        List<DynamicObject> dynamicObjects = values.get(BDTAXR_TAXABLE_LISTING);
        for (DynamicObject dynamicObject : dynamicObjects) {
            RemindTaskDto remindTaskDto = new RemindTaskDto();
            remindTaskDto.setTaskId(task.getLong("id"));
            remindTaskDto.setOrgId(String.valueOf(orgId));
            remindTaskDto.setRemindType(task.getString("remindtype"));
            remindTaskDto.setOrgName(Optional.ofNullable(dynamicObject.getDynamicObject("org")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setOrgNumber(Optional.ofNullable(dynamicObject.getDynamicObject("org")).map(s -> s.getString("number")).orElse(""));
            remindTaskDto.setTaxtype(Optional.ofNullable(dynamicObject.getDynamicObject("taxcatetory")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setSkssqq(DateUtils.format((Date)dynamicObject.getDate("skssqq")));
            remindTaskDto.setSkssqz(DateUtils.format((Date)dynamicObject.getDate("skssqz")));
            remindTaskDto.setTaxofficeName(Optional.ofNullable(dynamicObject.getDynamicObject("taxauthority")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setSbbBillno(dynamicObject.getString("sbbno"));
            remindTaskDto.setDraftStatusName(this.getItemName(dynamicObject, "draftstatus"));
            remindTaskDto.setSbbStatusName(this.getItemName(dynamicObject, "declarestatus"));
            remindTaskDto.setPayStatusName(this.getItemName(dynamicObject, "paystatus"));
            remindTaskDto.setDraftTypeName(this.getItemName(dynamicObject, "dgcategory"));
            remindTaskDto.setSbbTypeName(this.getItemName(dynamicObject, "sbbcategory"));
            remindTaskDto.setTemplateName(Optional.ofNullable(dynamicObject.getDynamicObject("templatetype")).map(s -> s.getString("name")).orElseGet(() -> ""));
            list.add(remindTaskDto);
        }
        return list;
    }

    private static Map<String, List<ValueMapItem>> getAllComboitems() {
        HashMap<String, List<ValueMapItem>> map = new HashMap<String, List<ValueMapItem>>(16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)BDTAXR_TAXABLE_LISTING);
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            if (property instanceof BillStatusProp) {
                map.put(property.getName(), ((BillStatusProp)property).getComboItems());
            }
            if (!(property instanceof ComboProp)) continue;
            map.put(property.getName(), ((ComboProp)property).getComboItems());
        }
        return map;
    }

    private String getItemName(DynamicObject dynamicObject, String property) {
        Optional optional = Optional.ofNullable(allComboitems.get(property)).flatMap(s -> s.stream().filter(a -> a.getValue().equals(dynamicObject.getString(property))).findFirst());
        return optional.isPresent() ? ((ValueMapItem)optional.get()).getName().toString() : "";
    }
}

