/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.business.message;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.metadata.MetadataUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.FilterBuilderUtils;
import kd.taxc.tctb.business.message.FixedFillingReminderTaskDto;
import kd.taxc.tctb.business.message.IMessageFilterDataSource;
import kd.taxc.tctb.business.message.RemindTaskRequest;
import kd.taxc.tctb.business.org.OrgService;

public class TjMessageFilterDataSourceImpl
implements IMessageFilterDataSource {
    private static final Log logger = LogFactory.getLog(TjMessageFilterDataSourceImpl.class);
    public static final String TCTSA_FIXED_FILLING_QUERY = "tctsa_fixed_filling_query";
    private OrgService orgService = new OrgService();

    @Override
    public Map<Long, Map<String, List<DynamicObject>>> filterDataSource(DynamicObject task) {
        Map<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        DynamicObjectCollection ruleentryentity = task.getDynamicObjectCollection("ruleentryentity");
        if (ruleentryentity == null || ruleentryentity.isEmpty()) {
            return result;
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<DynamicObject>>(16);
        for (int i = 0; i < ruleentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)ruleentryentity.get(i);
            DynamicObject table = dynamicObject.getDynamicObject("table");
            String tableName = table.getString("name");
            String conditionjson = dynamicObject.getString("conditionjson");
            QFilter qFilter = FilterBuilderUtils.buildFilter((String)this.parseNDayFilter(conditionjson), (String)tableName);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)tableName, (String)MetadataUtil.getAllSubFieldString((String)tableName), (QFilter[])new QFilter[]{qFilter}, (String)"skssqq asc");
            logger.info("\u6700\u521d\u59cb\u6570\u636e\u603b\u6761\u6570\u4e3a: " + load.length);
            if (EmptyCheckUtils.isNotEmpty((Object)load)) {
                List resultList = Arrays.stream(load).collect(Collectors.toList());
                logger.info("\u8868={}\uff0c\u6570\u636e\u6761\u6570={} ", (Object)table, (Object)resultList.size());
                map.put(tableName, new ArrayList(resultList));
                continue;
            }
            map = new HashMap(16);
        }
        result = this.mergeMap(map);
        this.removeNoData(result, ruleentryentity);
        return result;
    }

    private void removeNoData(Map<Long, Map<String, List<DynamicObject>>> result, DynamicObjectCollection ruleentryentity) {
        Iterator<Map.Entry<Long, Map<String, List<DynamicObject>>>> iterator = result.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<String, List<DynamicObject>>> entry = iterator.next();
            Map<String, List<DynamicObject>> value = entry.getValue();
            if (value.size() == ruleentryentity.size()) continue;
            iterator.remove();
        }
    }

    private String parseNDayFilter(String conditionjson) {
        FilterCondition filterCondition = FilterBuilderUtils.buildFilterCondition((String)conditionjson);
        boolean parse = false;
        for (SimpleFilterRow simpleFilterRow : filterCondition.getFilterRow()) {
            if (!CompareTypeEnum.LASTNDAYS.getId().equals(simpleFilterRow.getCompareType())) continue;
            String nday = (String)((FilterValue)simpleFilterRow.getValue().get(0)).getValue();
            simpleFilterRow.setCompareType(CompareTypeEnum.LESSOREQUAL.getId());
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)DateUtils.addDay((Date)new Date(), (int)Integer.parseInt(nday)));
            simpleFilterRow.setValue(Collections.singletonList(filterValue));
            parse = true;
        }
        return parse ? this.filterConditionToJson(filterCondition) : conditionjson;
    }

    private String filterConditionToJson(FilterCondition filterCondition) {
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        return SerializationUtils.toJsonString((Object)filterConditionMap);
    }

    private Map<Long, Map<String, List<DynamicObject>>> mergeMap(Map<String, List<DynamicObject>> map) {
        HashMap<Long, Map<String, List<DynamicObject>>> result = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String tableName = entry.getKey();
            List<DynamicObject> values = entry.getValue();
            for (DynamicObject dynamicObject : values) {
                Map<String, ArrayList> innerMap;
                long orgId = dynamicObject.getDynamicObject("org").getLong("id");
                if (!result.containsKey(orgId)) {
                    innerMap = new HashMap<String, ArrayList>(16);
                    innerMap.put(tableName, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                    result.put(orgId, innerMap);
                    continue;
                }
                innerMap = (Map)result.get(orgId);
                List list = (List)innerMap.get(tableName);
                if (list == null) {
                    innerMap.put(tableName, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
                    continue;
                }
                list.add(dynamicObject);
            }
        }
        return result;
    }

    @Override
    public Set<Long> getMessageReceiver(Long orgId, DynamicObject task) {
        HashSet<Long> result = new HashSet<Long>();
        String roletype = task.getString("roletype");
        DynamicObjectCollection ccusers = task.getDynamicObjectCollection("ccuser");
        logger.info("TjMessageFilterDataSourceImpl.getMessageReceiver.roletype={};ccusers={}", (Object)roletype, (Object)ccusers);
        if (!CollectionUtils.isEmpty((Collection)ccusers)) {
            ccusers.stream().forEach(s -> result.add(s.getLong("fbasedataid_id")));
        }
        if ("common".equals(roletype)) {
            DynamicObjectCollection commsysrole = task.getDynamicObjectCollection("commsysrole");
            if (!CollectionUtils.isEmpty((Collection)commsysrole)) {
                List commsysroleIds = commsysrole.stream().map(s -> s.getString("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"perm_userrole", (String)"user.id as userId", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("role", "in", commsysroleIds)});
                if (!CollectionUtils.isEmpty((Collection)userObjs)) {
                    userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
                }
            }
        } else if ("biz".equals(roletype)) {
            DynamicObjectCollection bizsysrole = task.getDynamicObjectCollection("bizsysrole");
            if (!CollectionUtils.isEmpty((Collection)bizsysrole)) {
                DynamicObjectCollection userObjs;
                List bizsysroleIds = bizsysrole.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toList());
                DynamicObjectCollection bizRoleObjs = QueryServiceHelper.query((String)"perm_bizrole", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizroleorg.org.id", "=", (Object)orgId), new QFilter("id", "in", bizsysroleIds)});
                if (!CollectionUtils.isEmpty((Collection)bizRoleObjs)) {
                    bizsysroleIds = bizRoleObjs.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty((Collection)(userObjs = QueryServiceHelper.query((String)"perm_userbizrole", (String)"user.id as userId", (QFilter[])new QFilter[]{new QFilter("bizrole", "in", bizsysroleIds)})))) {
                    userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
                }
            }
        } else if ("position".equals(roletype)) {
            List<String> names = this.orgService.getPersonNames(orgId, roletype);
            DynamicObjectCollection userObjs = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", names)});
            if (!CollectionUtils.isEmpty((Collection)userObjs)) {
                userObjs.stream().forEach(s -> result.add(s.getLong("userId")));
            }
        }
        logger.info("TjMessageFilterDataSourceImpl.getMessageReceiver.result={};", result);
        return result;
    }

    @Override
    public List<? super RemindTaskRequest> buildRemindTaskDto(Long orgId, DynamicObject task, Map<String, List<DynamicObject>> values) {
        logger.info("\u56fa\u5b9a\u586b\u62a5\u8fdb\u5165\u53d1\u9001\u901a\u77e5\u7ec4\u88c5\u6570\u636e\u9636\u6bb5\u5f00\u59cb\u524d: \u7ec4\u7ec7\u4e3a:" + orgId);
        ArrayList<FixedFillingReminderTaskDto> list = new ArrayList<FixedFillingReminderTaskDto>(16);
        if (!values.containsKey(TCTSA_FIXED_FILLING_QUERY)) {
            return list;
        }
        List<DynamicObject> dynamicObjects = values.get(TCTSA_FIXED_FILLING_QUERY);
        for (DynamicObject dynamicObject : dynamicObjects) {
            FixedFillingReminderTaskDto remindTaskDto = new FixedFillingReminderTaskDto();
            remindTaskDto.setTaskId(task.getLong("id"));
            remindTaskDto.setOrgId(String.valueOf(orgId));
            remindTaskDto.setRemindType(task.getString("remindtype"));
            remindTaskDto.setNumber(dynamicObject.getString("number"));
            remindTaskDto.setTaxtype(Optional.ofNullable(dynamicObject.getDynamicObject("taxtype")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setName(dynamicObject.getLocaleString("name").getLocaleValue());
            remindTaskDto.setOrg(Optional.ofNullable(dynamicObject.getDynamicObject("org")).map(s -> s.getString("name")).orElse(""));
            remindTaskDto.setSkssqq(DateUtils.format((Date)dynamicObject.getDate("skssqq")));
            remindTaskDto.setSkssqz(DateUtils.format((Date)dynamicObject.getDate("skssqz")));
            list.add(remindTaskDto);
            logger.info("\u53d1\u9001\u901a\u77e5\u7ec4\u88c5\u6570\u636e\u9636\u6bb5\u8fdb\u884c\u4e2d: taskid={};\u540d\u79f0={}\uff1b\u7ec4\u7ec7\u4e3a:{};number={};\u7a0e\u79cd={}\uff1b\u6240\u5c5e\u671f\u8d77={}\uff1b\u6240\u5c5e\u671f\u6b62={}", new Object[]{task.getLong("id"), remindTaskDto.getName(), orgId, dynamicObject.getString("number"), remindTaskDto.getTaxtype(), remindTaskDto.getSkssqq(), remindTaskDto.getSkssqz()});
        }
        logger.info("\u56fa\u5b9a\u586b\u62a5\u8fdb\u5165\u53d1\u9001\u901a\u77e5\u7ec4\u88c5\u6570\u636e\u9636\u6bb5\u7ed3\u675f\u540e: \u7d2f\u8ba1\u9700\u8981\u53d1\u9001\u7684\u6570\u636e\u6761\u6570\u4e3a:" + list.size());
        return list;
    }
}

